/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedSearchException;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.lucene.search.DocumentFieldConstants;
import org.apache.james.mailbox.lucene.search.LenientImapSearchAnalyzer;
import org.apache.james.mailbox.lucene.search.LuceneIndexableDocument;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LuceneMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final Logger log = LoggerFactory.getLogger(LuceneMessageSearchIndex.class);
    private static final Date MAX_DATE;
    private static final Date MIN_DATE;
    public static final Group GROUP;
    private static final int DEFAULT_MAX_QUERY_RESULTS = 100000;
    private static final boolean INCLUDE_LOWER = true;
    private static final boolean INCLUDE_UPPER = true;
    private static final SortField UID_SORT;
    private static final SortField UID_SORT_REVERSE;
    private static final SortField SIZE_SORT;
    private static final SortField SIZE_SORT_REVERSE;
    private static final SortField FIRST_CC_MAILBOX_SORT;
    private static final SortField FIRST_CC_MAILBOX_SORT_REVERSE;
    private static final SortField FIRST_TO_MAILBOX_SORT;
    private static final SortField FIRST_TO_MAILBOX_SORT_REVERSE;
    private static final SortField FIRST_FROM_MAILBOX_SORT;
    private static final SortField FIRST_FROM_MAILBOX_SORT_REVERSE;
    private static final SortField ARRIVAL_MAILBOX_SORT;
    private static final SortField ARRIVAL_MAILBOX_SORT_REVERSE;
    private static final SortField BASE_SUBJECT_SORT;
    private static final SortField BASE_SUBJECT_SORT_REVERSE;
    private static final SortField SENT_DATE_SORT;
    private static final SortField SENT_DATE_SORT_REVERSE;
    private final MailboxId.Factory mailboxIdFactory;
    private final MessageId.Factory messageIdFactory;
    private final LuceneIndexableDocument indexableDocument;
    @VisibleForTesting
    final IndexWriter writer;
    private final Directory directory;
    private int maxQueryResults = 100000;
    private boolean suffixMatch = false;

    @Inject
    public LuceneMessageSearchIndex(MailboxSessionMapperFactory factory, MailboxId.Factory mailboxIdFactory, Directory directory, MessageId.Factory messageIdFactory, SessionProvider sessionProvider, TextExtractor textExtractor) throws IOException {
        this(factory, mailboxIdFactory, directory, false, messageIdFactory, sessionProvider, textExtractor);
    }

    public LuceneMessageSearchIndex(MailboxSessionMapperFactory factory, MailboxId.Factory mailboxIdFactory, Directory directory, boolean dropIndexOnStart, MessageId.Factory messageIdFactory, SessionProvider sessionProvider, TextExtractor textExtractor) throws IOException {
        super(factory, (Set)ImmutableSet.of(), sessionProvider);
        this.mailboxIdFactory = mailboxIdFactory;
        this.messageIdFactory = messageIdFactory;
        this.indexableDocument = new LuceneIndexableDocument(textExtractor);
        this.directory = directory;
        try {
            this.writer = new IndexWriter(this.directory, this.createConfig(LenientImapSearchAnalyzer.INSTANCE, dropIndexOnStart));
        }
        catch (IndexFormatTooOldException e) {
            throw new RuntimeException("Old lucene index version detected, automatic migration is not supported. See https://github.com/james/james-project/blob/master/upgrade-instructions.md#james-4046-refactor-and-update-apache-james-mailbox-lucene for details", e);
        }
    }

    @PreDestroy
    public void close() throws IOException {
        log.trace("Closing Lucene index");
        this.writer.commit();
        this.writer.close();
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, new MailboxManager.SearchCapabilities[]{MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.FullText, MailboxManager.SearchCapabilities.AttachmentFileName, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.HighlightSearch});
    }

    public void setMaxQueryResults(int maxQueryResults) {
        this.maxQueryResults = maxQueryResults;
    }

    protected IndexWriterConfig createConfig(Analyzer analyzer, boolean dropIndexOnStart) {
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        if (dropIndexOnStart) {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        return config;
    }

    public void setEnableSuffixMatch(boolean suffixMatch) {
        this.suffixMatch = suffixMatch;
    }

    public Flux<MessageUid> doSearch(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        return Flux.fromIterable(this.searchMultimap((Collection<MailboxId>)ImmutableList.of((Object)mailbox.getMailboxId()), searchQuery)).map(MessageSearchIndex.SearchResult::getMessageUid);
    }

    public Flux<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) throws MailboxException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        if (mailboxIds.isEmpty()) {
            return Flux.empty();
        }
        return Flux.fromIterable((Iterable)((Iterable)this.searchMultimap(mailboxIds, searchQuery).stream().filter(searchResult -> searchResult.getMessageId().isPresent()).map(searchResult -> (MessageId)searchResult.getMessageId().get()).filter(SearchUtil.distinct()).limit(Long.valueOf(limit).intValue()).collect(ImmutableList.toImmutableList())));
    }

    private List<MessageSearchIndex.SearchResult> searchMultimap(Collection<MailboxId> mailboxIds, SearchQuery searchQuery) throws MailboxException {
        return this.searchDocument(mailboxIds, searchQuery, this.maxQueryResults).stream().map(this::documentToSearchResult).toList();
    }

    private MessageSearchIndex.SearchResult documentToSearchResult(Document doc) {
        MessageUid uid = MessageUid.of((long)doc.getField("uid").numericValue().longValue());
        MailboxId mailboxId = this.mailboxIdFactory.fromString(doc.get("mailboxid"));
        Optional<MessageId> messageId = Optional.ofNullable(doc.get("messageid")).map(arg_0 -> ((MessageId.Factory)this.messageIdFactory).fromString(arg_0));
        return new MessageSearchIndex.SearchResult(messageId, mailboxId, uid);
    }

    public List<Document> searchDocument(Collection<MailboxId> mailboxIds, SearchQuery searchQuery, int maxQueryResults) throws MailboxException {
        List<Document> list;
        block9: {
            Query inMailboxes = this.buildQueryFromMailboxes(mailboxIds);
            DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer);
            try {
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                queryBuilder.add(inMailboxes, BooleanClause.Occur.MUST);
                queryBuilder.add((Query)new PrefixQuery(new Term("flags", "")), BooleanClause.Occur.MUST_NOT);
                List crits = searchQuery.getCriteria();
                for (SearchQuery.Criterion crit : crits) {
                    queryBuilder.add(this.createQuery(crit, inMailboxes, searchQuery.getRecentMessageUids()), BooleanClause.Occur.MUST);
                }
                TopFieldDocs docs = searcher.search((Query)queryBuilder.build(), maxQueryResults, this.createSort(searchQuery.getSorts()));
                list = Stream.of(docs.scoreDocs).map(Throwing.function(sDoc -> searcher.storedFields().document(sDoc.doc))).toList();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to search the mailbox", (Throwable)e);
                }
            }
            reader.close();
        }
        return list;
    }

    private Query buildQueryFromMailboxes(Collection<MailboxId> mailboxIds) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (MailboxId id : mailboxIds) {
            String idAsString = id.serialize();
            queryBuilder.add((Query)new TermQuery(new Term("mailboxid", idAsString)), BooleanClause.Occur.SHOULD);
        }
        return queryBuilder.build();
    }

    private String toSentDateField(SearchQuery.DateResolution res) {
        return switch (res) {
            default -> throw new MatchException(null, null);
            case SearchQuery.DateResolution.Year -> "sentdateYearResolution";
            case SearchQuery.DateResolution.Month -> "sentdateMonthResolution";
            case SearchQuery.DateResolution.Day -> "sentdateDayResolution";
            case SearchQuery.DateResolution.Hour -> "sentdateHourResolution";
            case SearchQuery.DateResolution.Minute -> "sentdateMinuteResolution";
            case SearchQuery.DateResolution.Second -> "sentdateSecondResolution";
        };
    }

    private String toInteralDateField(SearchQuery.DateResolution res) {
        return switch (res) {
            default -> throw new MatchException(null, null);
            case SearchQuery.DateResolution.Year -> "internaldateYearResolution";
            case SearchQuery.DateResolution.Month -> "internaldateMonthResolution";
            case SearchQuery.DateResolution.Day -> "internaldateDayResolution";
            case SearchQuery.DateResolution.Hour -> "internaldateHourResolution";
            case SearchQuery.DateResolution.Minute -> "internaldateMinuteResolution";
            case SearchQuery.DateResolution.Second -> "internaldateSecondResolution";
        };
    }

    private String toSaveDateField(SearchQuery.DateResolution res) {
        return switch (res) {
            default -> throw new MatchException(null, null);
            case SearchQuery.DateResolution.Year -> "saveDateYearResolution";
            case SearchQuery.DateResolution.Month -> "saveDateMonthResolution";
            case SearchQuery.DateResolution.Day -> "saveDateDayResolution";
            case SearchQuery.DateResolution.Hour -> "saveDateHourResolution";
            case SearchQuery.DateResolution.Minute -> "saveDateMinuteResolution";
            case SearchQuery.DateResolution.Second -> "saveDateSecondResolution";
        };
    }

    private Query createInternalDateQuery(SearchQuery.InternalDateCriterion crit) {
        SearchQuery.DateOperator dop = crit.getOperator();
        SearchQuery.DateResolution res = dop.getDateResultion();
        String field = this.toInteralDateField(res);
        return this.createQuery(field, dop);
    }

    private Query createSaveDateQuery(SearchQuery.SaveDateCriterion crit) {
        SearchQuery.DateOperator dop = crit.getOperator();
        SearchQuery.DateResolution res = dop.getDateResultion();
        String field = this.toSaveDateField(res);
        return this.createQuery(field, dop);
    }

    private Query createSizeQuery(SearchQuery.SizeCriterion crit) {
        SearchQuery.NumericOperator op = crit.getOperator();
        return switch (op.getType()) {
            default -> throw new MatchException(null, null);
            case SearchQuery.NumericComparator.EQUALS -> LongPoint.newExactQuery((String)"size", (long)op.getValue());
            case SearchQuery.NumericComparator.GREATER_THAN -> LongPoint.newRangeQuery((String)"size", (long)(op.getValue() + 1L), (long)Long.MAX_VALUE);
            case SearchQuery.NumericComparator.LESS_THAN -> LongPoint.newRangeQuery((String)"size", (long)Long.MIN_VALUE, (long)(op.getValue() - 1L));
        };
    }

    private Query createTermQuery(String fieldName, String value) {
        if (this.suffixMatch) {
            return new WildcardQuery(new Term(fieldName, "*" + value + "*"));
        }
        return new PrefixQuery(new Term(fieldName, value));
    }

    private Query createHeaderQuery(SearchQuery.HeaderCriterion crit) throws UnsupportedSearchException {
        if (crit.getOperator() == null) {
            throw new UnsupportedSearchException();
        }
        String name = crit.getHeaderName().toUpperCase(Locale.US);
        String fieldName = "header_" + name;
        SearchQuery.HeaderOperator headerOperator = crit.getOperator();
        Objects.requireNonNull(headerOperator);
        SearchQuery.HeaderOperator headerOperator2 = headerOperator;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SearchQuery.ContainsOperator.class, SearchQuery.ExistsOperator.class, SearchQuery.DateOperator.class, SearchQuery.AddressOperator.class}, (Object)headerOperator2, n)) {
            case 0 -> {
                SearchQuery.ContainsOperator cop = (SearchQuery.ContainsOperator)headerOperator2;
                yield this.createTermQuery(fieldName, cop.getValue().toUpperCase(Locale.US));
            }
            case 1 -> {
                SearchQuery.ExistsOperator existsOperator = (SearchQuery.ExistsOperator)headerOperator2;
                yield new PrefixQuery(new Term(fieldName, ""));
            }
            case 2 -> {
                SearchQuery.DateOperator dop = (SearchQuery.DateOperator)headerOperator2;
                yield this.createQuery(this.toSentDateField(dop.getDateResultion()), dop);
            }
            case 3 -> {
                SearchQuery.AddressOperator addressOperator = (SearchQuery.AddressOperator)headerOperator2;
                yield this.createTermQuery(name.toLowerCase(Locale.US), addressOperator.getAddress().toUpperCase(Locale.US));
            }
            default -> throw new UnsupportedSearchException();
        };
    }

    private Query createQuery(String field, SearchQuery.DateOperator dop) {
        Date date = dop.getDate();
        SearchQuery.DateResolution res = dop.getDateResultion();
        DateTools.Resolution dRes = this.toResolution(res);
        String value = DateTools.dateToString((Date)date, (DateTools.Resolution)dRes);
        return switch (dop.getType()) {
            default -> throw new MatchException(null, null);
            case SearchQuery.DateComparator.ON -> new TermQuery(new Term(field, value));
            case SearchQuery.DateComparator.BEFORE -> TermRangeQuery.newStringRange((String)field, (String)DateTools.dateToString((Date)MIN_DATE, (DateTools.Resolution)dRes), (String)value, (boolean)true, (boolean)false);
            case SearchQuery.DateComparator.AFTER -> TermRangeQuery.newStringRange((String)field, (String)value, (String)DateTools.dateToString((Date)MAX_DATE, (DateTools.Resolution)dRes), (boolean)false, (boolean)true);
        };
    }

    private DateTools.Resolution toResolution(SearchQuery.DateResolution res) {
        return switch (res) {
            default -> throw new MatchException(null, null);
            case SearchQuery.DateResolution.Year -> DateTools.Resolution.YEAR;
            case SearchQuery.DateResolution.Month -> DateTools.Resolution.MONTH;
            case SearchQuery.DateResolution.Day -> DateTools.Resolution.DAY;
            case SearchQuery.DateResolution.Hour -> DateTools.Resolution.HOUR;
            case SearchQuery.DateResolution.Minute -> DateTools.Resolution.MINUTE;
            case SearchQuery.DateResolution.Second -> DateTools.Resolution.SECOND;
        };
    }

    private Query createUidQuery(SearchQuery.UidCriterion crit) {
        SearchQuery.UidRange[] ranges = crit.getOperator().getRange();
        if (ranges.length == 1) {
            SearchQuery.UidRange range = ranges[0];
            return LongPoint.newRangeQuery((String)"uid", (long)range.getLowValue().asLong(), (long)range.getHighValue().asLong());
        }
        BooleanQuery.Builder rangesQuery = new BooleanQuery.Builder();
        for (SearchQuery.UidRange range : ranges) {
            rangesQuery.add(LongPoint.newRangeQuery((String)"uid", (long)range.getLowValue().asLong(), (long)range.getHighValue().asLong()), BooleanClause.Occur.SHOULD);
        }
        return rangesQuery.build();
    }

    private Query createModSeqQuery(SearchQuery.ModSeqCriterion crit) {
        SearchQuery.NumericOperator op = crit.getOperator();
        return switch (op.getType()) {
            default -> throw new MatchException(null, null);
            case SearchQuery.NumericComparator.EQUALS -> LongPoint.newRangeQuery((String)"modSeq", (long)op.getValue(), (long)op.getValue());
            case SearchQuery.NumericComparator.GREATER_THAN -> LongPoint.newRangeQuery((String)"modSeq", (long)op.getValue(), (long)Long.MAX_VALUE);
            case SearchQuery.NumericComparator.LESS_THAN -> LongPoint.newRangeQuery((String)"modSeq", (long)Long.MIN_VALUE, (long)op.getValue());
        };
    }

    private Query createAttachmentQuery(boolean isSet) {
        return new TermQuery(new Term("hasAttachment", Boolean.toString(isSet)));
    }

    private Query createFlagQuery(String flag, boolean isSet, Query inMailboxes, Collection<MessageUid> recentUids) throws MailboxException {
        Query query;
        block15: {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            if (isSet) {
                queryBuilder.add((Query)new TermQuery(new Term("flags", flag)), BooleanClause.Occur.MUST);
            } else {
                BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
                bQuery.add((Query)new PrefixQuery(new Term("flags", "")), BooleanClause.Occur.MUST);
                bQuery.add((Query)new TermQuery(new Term("flags", flag)), BooleanClause.Occur.MUST_NOT);
                queryBuilder.add((Query)bQuery.build(), BooleanClause.Occur.MUST);
            }
            queryBuilder.add(inMailboxes, BooleanClause.Occur.MUST);
            DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer);
            try {
                ScoreDoc[] sDocs;
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                HashSet<MessageUid> uids = new HashSet<MessageUid>();
                TopFieldDocs docs = searcher.search((Query)queryBuilder.build(), this.maxQueryResults, new Sort(new SortField[]{UID_SORT}));
                for (ScoreDoc sDoc : sDocs = docs.scoreDocs) {
                    MessageUid uid = MessageUid.of((long)searcher.storedFields().document(sDoc.doc).getField("uid").numericValue().longValue());
                    uids.add(uid);
                }
                if (flag.equalsIgnoreCase("\\RECENT")) {
                    if (isSet) {
                        uids.addAll(recentUids);
                    } else {
                        uids.removeAll(recentUids);
                    }
                }
                List ranges = MessageRange.toRanges(new ArrayList(uids));
                SearchQuery.UidRange[] nRanges = new SearchQuery.UidRange[ranges.size()];
                for (int i = 0; i < ranges.size(); ++i) {
                    MessageRange range = (MessageRange)ranges.get(i);
                    nRanges[i] = new SearchQuery.UidRange(range.getUidFrom(), range.getUidTo());
                }
                query = this.createUidQuery((SearchQuery.UidCriterion)SearchQuery.uid((SearchQuery.UidRange[])nRanges));
                if (reader == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MailboxException("Unable to search mailbox " + String.valueOf(inMailboxes), (Throwable)e);
                }
            }
            reader.close();
        }
        return query;
    }

    private Sort createSort(List<SearchQuery.Sort> sorts) {
        ArrayList<SortField> fields = new ArrayList<SortField>();
        for (SearchQuery.Sort sort : sorts) {
            boolean reverse;
            SortField sortField = this.createSortField(sort, reverse = sort.isReverse());
            if (sortField == null) continue;
            fields.add(sortField);
            if (sortField == SENT_DATE_SORT) {
                fields.add(UID_SORT);
                continue;
            }
            if (sortField != SENT_DATE_SORT_REVERSE) continue;
            fields.add(UID_SORT_REVERSE);
        }
        fields.add(UID_SORT);
        return new Sort((SortField[])fields.toArray(SortField[]::new));
    }

    private SortField createSortField(SearchQuery.Sort s, boolean reverse) {
        if (s.getSortClause() == null) {
            return null;
        }
        if (reverse) {
            return switch (s.getSortClause()) {
                case SearchQuery.Sort.SortClause.Arrival -> ARRIVAL_MAILBOX_SORT_REVERSE;
                case SearchQuery.Sort.SortClause.SentDate -> SENT_DATE_SORT_REVERSE;
                case SearchQuery.Sort.SortClause.MailboxCc -> FIRST_CC_MAILBOX_SORT_REVERSE;
                case SearchQuery.Sort.SortClause.MailboxFrom -> FIRST_FROM_MAILBOX_SORT_REVERSE;
                case SearchQuery.Sort.SortClause.Size -> SIZE_SORT_REVERSE;
                case SearchQuery.Sort.SortClause.BaseSubject -> BASE_SUBJECT_SORT_REVERSE;
                case SearchQuery.Sort.SortClause.MailboxTo -> FIRST_TO_MAILBOX_SORT_REVERSE;
                case SearchQuery.Sort.SortClause.Uid -> UID_SORT_REVERSE;
                default -> null;
            };
        }
        return switch (s.getSortClause()) {
            case SearchQuery.Sort.SortClause.Arrival -> ARRIVAL_MAILBOX_SORT;
            case SearchQuery.Sort.SortClause.SentDate -> SENT_DATE_SORT;
            case SearchQuery.Sort.SortClause.MailboxCc -> FIRST_CC_MAILBOX_SORT;
            case SearchQuery.Sort.SortClause.MailboxFrom -> FIRST_FROM_MAILBOX_SORT;
            case SearchQuery.Sort.SortClause.Size -> SIZE_SORT;
            case SearchQuery.Sort.SortClause.BaseSubject -> BASE_SUBJECT_SORT;
            case SearchQuery.Sort.SortClause.MailboxTo -> FIRST_TO_MAILBOX_SORT;
            case SearchQuery.Sort.SortClause.Uid -> UID_SORT;
            default -> null;
        };
    }

    private String toString(Flags.Flag flag) {
        if (Flags.Flag.ANSWERED.equals(flag)) {
            return "\\ANSWERED";
        }
        if (Flags.Flag.DELETED.equals(flag)) {
            return "\\DELETED";
        }
        if (Flags.Flag.DRAFT.equals(flag)) {
            return "\\DRAFT";
        }
        if (Flags.Flag.FLAGGED.equals(flag)) {
            return "\\FLAGGED";
        }
        if (Flags.Flag.RECENT.equals(flag)) {
            return "\\RECENT";
        }
        if (Flags.Flag.SEEN.equals(flag)) {
            return "\\FLAG";
        }
        return flag.toString();
    }

    private Query createTextQuery(SearchQuery.TextCriterion crit) {
        String value = crit.getOperator().getValue().toUpperCase(Locale.US);
        return switch (crit.getType()) {
            default -> throw new MatchException(null, null);
            case SearchQuery.Scope.BODY -> this.createTermQuery("body", value);
            case SearchQuery.Scope.ATTACHMENTS -> this.createTermQuery(DocumentFieldConstants.ATTACHMENT_TEXT_CONTENT_FIELD, value);
            case SearchQuery.Scope.ATTACHMENT_FILE_NAME -> this.createTermQuery(DocumentFieldConstants.ATTACHMENT_FILE_NAME_FIELD, value);
            case SearchQuery.Scope.FULL -> {
                BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                queryBuilder.add(this.createTermQuery("body", value), BooleanClause.Occur.SHOULD);
                queryBuilder.add(this.createTermQuery("headers", value), BooleanClause.Occur.SHOULD);
                queryBuilder.add(this.createTermQuery(DocumentFieldConstants.ATTACHMENT_TEXT_CONTENT_FIELD, value), BooleanClause.Occur.SHOULD);
                yield queryBuilder.build();
            }
        };
    }

    private Query createAllQuery() {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(this.createQuery(MessageRange.all()), BooleanClause.Occur.MUST);
        queryBuilder.add((Query)new PrefixQuery(new Term("flags", "")), BooleanClause.Occur.MUST_NOT);
        return queryBuilder.build();
    }

    private Query createConjunctionQuery(SearchQuery.ConjunctionCriterion crit, Query inMailboxes, Collection<MessageUid> recentUids) throws MailboxException {
        List crits = crit.getCriteria();
        BooleanQuery.Builder conQuery = new BooleanQuery.Builder();
        switch (crit.getType()) {
            case AND: {
                for (SearchQuery.Criterion criterion : crits) {
                    conQuery.add(this.createQuery(criterion, inMailboxes, recentUids), BooleanClause.Occur.MUST);
                }
                return conQuery.build();
            }
            case OR: {
                for (SearchQuery.Criterion criterion : crits) {
                    conQuery.add(this.createQuery(criterion, inMailboxes, recentUids), BooleanClause.Occur.SHOULD);
                }
                return conQuery.build();
            }
            case NOR: {
                BooleanQuery.Builder nor = new BooleanQuery.Builder();
                for (SearchQuery.Criterion criterion : crits) {
                    conQuery.add(this.createQuery(criterion, inMailboxes, recentUids), BooleanClause.Occur.SHOULD);
                }
                nor.add(inMailboxes, BooleanClause.Occur.MUST);
                nor.add((Query)conQuery.build(), BooleanClause.Occur.MUST_NOT);
                return nor.build();
            }
        }
        throw new UnsupportedSearchException();
    }

    private Query createQuery(SearchQuery.Criterion criterion, Query inMailboxes, Collection<MessageUid> recentUids) throws MailboxException {
        if (criterion instanceof SearchQuery.InternalDateCriterion) {
            SearchQuery.InternalDateCriterion crit = (SearchQuery.InternalDateCriterion)criterion;
            return this.createInternalDateQuery(crit);
        }
        if (criterion instanceof SearchQuery.SaveDateCriterion) {
            SearchQuery.SaveDateCriterion crit = (SearchQuery.SaveDateCriterion)criterion;
            return this.createSaveDateQuery(crit);
        }
        if (criterion instanceof SearchQuery.SizeCriterion) {
            SearchQuery.SizeCriterion crit = (SearchQuery.SizeCriterion)criterion;
            return this.createSizeQuery(crit);
        }
        if (criterion instanceof SearchQuery.MessageIdCriterion) {
            SearchQuery.MessageIdCriterion crit = (SearchQuery.MessageIdCriterion)criterion;
            return new TermQuery(new Term("messageid", crit.getMessageId().serialize()));
        }
        if (criterion instanceof SearchQuery.HeaderCriterion) {
            SearchQuery.HeaderCriterion crit = (SearchQuery.HeaderCriterion)criterion;
            return this.createHeaderQuery(crit);
        }
        if (criterion instanceof SearchQuery.UidCriterion) {
            SearchQuery.UidCriterion crit = (SearchQuery.UidCriterion)criterion;
            return this.createUidQuery(crit);
        }
        if (criterion instanceof SearchQuery.FlagCriterion) {
            SearchQuery.FlagCriterion crit = (SearchQuery.FlagCriterion)criterion;
            return this.createFlagQuery(this.toString(crit.getFlag()), crit.getOperator().isSet(), inMailboxes, recentUids);
        }
        if (criterion instanceof SearchQuery.AttachmentCriterion) {
            SearchQuery.AttachmentCriterion crit = (SearchQuery.AttachmentCriterion)criterion;
            return this.createAttachmentQuery(crit.getOperator().isSet());
        }
        if (criterion instanceof SearchQuery.CustomFlagCriterion) {
            SearchQuery.CustomFlagCriterion crit = (SearchQuery.CustomFlagCriterion)criterion;
            return this.createFlagQuery(crit.getFlag().toLowerCase(Locale.US), crit.getOperator().isSet(), inMailboxes, recentUids);
        }
        if (criterion instanceof SearchQuery.TextCriterion) {
            SearchQuery.TextCriterion crit = (SearchQuery.TextCriterion)criterion;
            return this.createTextQuery(crit);
        }
        if (criterion instanceof SearchQuery.AllCriterion) {
            return this.createAllQuery();
        }
        if (criterion instanceof SearchQuery.ConjunctionCriterion) {
            SearchQuery.ConjunctionCriterion crit = (SearchQuery.ConjunctionCriterion)criterion;
            return this.createConjunctionQuery(crit, inMailboxes, recentUids);
        }
        if (criterion instanceof SearchQuery.ModSeqCriterion) {
            return this.createModSeqQuery((SearchQuery.ModSeqCriterion)criterion);
        }
        if (criterion instanceof SearchQuery.MimeMessageIDCriterion) {
            SearchQuery.MimeMessageIDCriterion mimeMessageIDCriterion = (SearchQuery.MimeMessageIDCriterion)criterion;
            return this.createHeaderQuery(mimeMessageIDCriterion.asHeaderCriterion());
        }
        if (criterion instanceof SearchQuery.SubjectCriterion) {
            SearchQuery.SubjectCriterion subjectCriterion = (SearchQuery.SubjectCriterion)criterion;
            return this.createHeaderQuery(subjectCriterion.asHeaderCriterion());
        }
        if (criterion instanceof SearchQuery.ThreadIdCriterion) {
            SearchQuery.ThreadIdCriterion threadIdCriterion = (SearchQuery.ThreadIdCriterion)criterion;
            return this.createTermQuery("threadId", threadIdCriterion.getThreadId().serialize());
        }
        throw new UnsupportedSearchException();
    }

    public Mono<Void> add(MailboxSession session, Mailbox mailbox, MailboxMessage membership) {
        return Mono.fromCallable(() -> this.retrieveFlags(mailbox, membership.getUid())).filter(flags -> !new Flags().equals(flags)).flatMap(any -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.update(mailbox.getMailboxId(), membership.getUid(), membership.createFlags())))).switchIfEmpty(Mono.defer(() -> this.indexableDocument.createMessageDocument(membership, session).flatMap(document -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
            this.writer.addDocument((Iterable)document);
            this.writer.addDocument((Iterable)this.indexableDocument.createFlagsDocument(membership));
        }))))).then();
    }

    public Mono<Void> update(MailboxSession session, MailboxId mailboxId, List<UpdatedFlags> updatedFlagsList) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
            for (UpdatedFlags updatedFlags : updatedFlagsList) {
                this.update(mailboxId, updatedFlags.getUid(), updatedFlags.getNewFlags());
            }
        }));
    }

    private void update(MailboxId mailboxId, MessageUid uid, Flags f) throws IOException {
        String flagsID = LuceneIndexableDocument.createFlagsIdField(mailboxId, uid);
        Term term = new Term("id", flagsID);
        Document doc = this.indexableDocument.createFlagsDocument(mailboxId, uid, f);
        log.trace("Updating flags document, mailboxId:{}, message uid: {}, flags:'{}', term: {}, new document: {}", new Object[]{mailboxId, uid, f, term, doc});
        this.writer.updateDocument(term, (Iterable)doc);
    }

    private Query createQuery(MessageRange range) {
        return switch (range.getType()) {
            case MessageRange.Type.ONE -> LongPoint.newRangeQuery((String)"uid", (long)range.getUidFrom().asLong(), (long)range.getUidTo().asLong());
            case MessageRange.Type.FROM -> LongPoint.newRangeQuery((String)"uid", (long)range.getUidFrom().asLong(), (long)MessageUid.MAX_VALUE.asLong());
            default -> LongPoint.newRangeQuery((String)"uid", (long)MessageUid.MIN_VALUE.asLong(), (long)MessageUid.MAX_VALUE.asLong());
        };
    }

    public Mono<Void> delete(MailboxSession session, MailboxId mailboxId, Collection<MessageUid> expungedUids) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> MessageRange.toRanges((Collection)expungedUids).forEach(Throwing.consumer(messageRange -> this.delete(mailboxId, (MessageRange)messageRange)).sneakyThrow())));
    }

    public Mono<Void> deleteAll(MailboxSession session, MailboxId mailboxId) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.delete(mailboxId, MessageRange.all())));
    }

    public void delete(MailboxId mailboxId, MessageRange range) throws IOException {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add((Query)new TermQuery(new Term("mailboxid", mailboxId.serialize())), BooleanClause.Occur.MUST);
        queryBuilder.add(this.createQuery(range), BooleanClause.Occur.MUST);
        this.writer.deleteDocuments(new Query[]{queryBuilder.build()});
    }

    public void commit() throws IOException {
        this.writer.commit();
    }

    public void postReindexing() {
        try {
            this.commit();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while commiting to index", e);
        }
    }

    public Mono<Flags> retrieveIndexedFlags(Mailbox mailbox, MessageUid uid) {
        return Mono.fromCallable(() -> this.retrieveFlags(mailbox, uid));
    }

    private Flags retrieveFlags(Mailbox mailbox, MessageUid uid) throws IOException {
        try (DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer);){
            Flags sDocs;
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            Flags retrievedFlags = new Flags();
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            queryBuilder.add((Query)new TermQuery(new Term("mailboxid", mailbox.getMailboxId().serialize())), BooleanClause.Occur.MUST);
            queryBuilder.add(this.createQuery(MessageRange.one((MessageUid)uid)), BooleanClause.Occur.MUST);
            queryBuilder.add((Query)new PrefixQuery(new Term("flags", "")), BooleanClause.Occur.MUST);
            TopDocs docs = searcher.search((Query)queryBuilder.build(), 100000);
            for (Flags sDoc : sDocs = docs.scoreDocs) {
                Document doc = searcher.storedFields().document(sDoc.doc);
                Stream.of(doc.getValues("flags")).forEach(flag -> this.fromString((String)flag).ifPresentOrElse(arg_0 -> ((Flags)retrievedFlags).add(arg_0), () -> retrievedFlags.add(flag)));
            }
            Flags flags = retrievedFlags;
            return flags;
        }
    }

    private Optional<Flags.Flag> fromString(String flag) {
        return switch (flag) {
            case "\\ANSWERED" -> Optional.of(Flags.Flag.ANSWERED);
            case "\\DELETED" -> Optional.of(Flags.Flag.DELETED);
            case "\\DRAFT" -> Optional.of(Flags.Flag.DRAFT);
            case "\\FLAGGED" -> Optional.of(Flags.Flag.FLAGGED);
            case "\\RECENT" -> Optional.of(Flags.Flag.RECENT);
            case "\\FLAG" -> Optional.of(Flags.Flag.SEEN);
            default -> Optional.empty();
        };
    }

    static {
        GROUP = new LuceneMessageSearchIndexGroup();
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        MAX_DATE = cal.getTime();
        cal.set(0, 0, 1);
        MIN_DATE = cal.getTime();
        UID_SORT = new SortField("uid", SortField.Type.LONG);
        UID_SORT_REVERSE = new SortField("uid", SortField.Type.LONG, true);
        SIZE_SORT = new SortField("size", SortField.Type.LONG);
        SIZE_SORT_REVERSE = new SortField("size", SortField.Type.LONG, true);
        FIRST_CC_MAILBOX_SORT = new SortedSetSortField("firstCcMailboxName", false);
        FIRST_CC_MAILBOX_SORT_REVERSE = new SortedSetSortField("firstCcMailboxName", true);
        FIRST_TO_MAILBOX_SORT = new SortedSetSortField("firstToMailboxName", false);
        FIRST_TO_MAILBOX_SORT_REVERSE = new SortedSetSortField("firstToMailboxName", true);
        FIRST_FROM_MAILBOX_SORT = new SortedSetSortField("firstFromMailboxName", false);
        FIRST_FROM_MAILBOX_SORT_REVERSE = new SortedSetSortField("firstFromMailboxName", true);
        ARRIVAL_MAILBOX_SORT = new SortField("internaldateMillisecondResolution", SortField.Type.LONG);
        ARRIVAL_MAILBOX_SORT_REVERSE = new SortField("internaldateMillisecondResolution", SortField.Type.LONG, true);
        BASE_SUBJECT_SORT = new SortedSetSortField("baseSubject", false);
        BASE_SUBJECT_SORT_REVERSE = new SortedSetSortField("baseSubject", true);
        SENT_DATE_SORT = new SortField("sentdateSort", SortField.Type.LONG);
        SENT_DATE_SORT_REVERSE = new SortField("sentdateSort", SortField.Type.LONG, true);
    }

    public static class LuceneMessageSearchIndexGroup
    extends Group {
    }
}

