/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import jakarta.mail.Flags;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.lucene.search.DocumentFieldConstants;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mailbox.store.search.mime.EMailers;
import org.apache.james.mailbox.store.search.mime.HeaderCollection;
import org.apache.james.mailbox.store.search.mime.MimePart;
import org.apache.james.mailbox.store.search.mime.MimePartParser;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import reactor.core.publisher.Mono;

public class LuceneIndexableDocument {
    public static final Map<Flags.Flag, String> SYSTEM_FLAG_STRING_MAP = ImmutableMap.builder().put((Object)Flags.Flag.ANSWERED, (Object)"\\ANSWERED").put((Object)Flags.Flag.DELETED, (Object)"\\DELETED").put((Object)Flags.Flag.DRAFT, (Object)"\\DRAFT").put((Object)Flags.Flag.FLAGGED, (Object)"\\FLAGGED").put((Object)Flags.Flag.RECENT, (Object)"\\RECENT").put((Object)Flags.Flag.SEEN, (Object)"\\FLAG").build();
    private final TextExtractor textExtractor;

    public LuceneIndexableDocument(TextExtractor textExtractor) {
        this.textExtractor = textExtractor;
    }

    public Mono<Document> createMessageDocument(MailboxMessage message, MailboxSession session) {
        return ((MimePart.ParsedMimePart)Throwing.supplier(() -> new MimePartParser(this.textExtractor).parse(message.getFullContent())).get()).asMimePart(this.textExtractor).map(parsingResult -> this.createMessageDocument(message, session, (MimePart)parsingResult));
    }

    public Document createMessageDocument(MailboxMessage message, MailboxSession session, MimePart mimePartExtracted) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("userSession", session.getUser().asString().toUpperCase(Locale.US), Field.Store.YES));
        doc.add((IndexableField)new StringField("mailboxid", message.getMailboxId().serialize().toUpperCase(Locale.US), Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("uid", message.getUid().asLong()));
        doc.add((IndexableField)new LongPoint("uid", new long[]{message.getUid().asLong()}));
        doc.add((IndexableField)new StoredField("uid", message.getUid().asLong()));
        doc.add((IndexableField)new StringField("hasAttachment", Boolean.toString(MessageAttachmentMetadata.hasNonInlinedAttachment((List)message.getAttachments())), Field.Store.YES));
        doc.add((IndexableField)new LongPoint("size", new long[]{message.getFullContentOctets()}));
        doc.add((IndexableField)new NumericDocValuesField("size", message.getFullContentOctets()));
        doc.add((IndexableField)new StringField("id", message.getMailboxId().serialize().toUpperCase(Locale.US) + "-" + message.getUid().asLong(), Field.Store.YES));
        Optional.ofNullable(SearchUtil.getSerializedMessageIdIfSupportedByUnderlyingStorageOrNull((MailboxMessage)message)).ifPresent(serializedMessageId -> doc.add((IndexableField)new StringField("messageid", serializedMessageId, Field.Store.YES)));
        Optional.ofNullable(SearchUtil.getSerializedThreadIdIfSupportedByUnderlyingStorageOrNull((MailboxMessage)message)).ifPresent(serializedThreadId -> doc.add((IndexableField)new StringField("threadId", serializedThreadId, Field.Store.YES)));
        HeaderCollection headerCollection = mimePartExtracted.getHeaderCollection();
        LuceneIndexableDocument.indexInternalDateFields(message.getInternalDate(), doc);
        message.getSaveDate().ifPresent(saveDate -> LuceneIndexableDocument.indexSaveDateFields(saveDate, doc));
        headerCollection.getSentDate().map(zonedDateTime -> Date.from(zonedDateTime.toInstant())).or(() -> Optional.ofNullable(message.getInternalDate())).ifPresent(sentDate -> LuceneIndexableDocument.indexSentDateFields(sentDate, doc));
        headerCollection.getHeaders().forEach(header -> {
            String headerName = LuceneIndexableDocument.uppercase(header.getHeaderName());
            String headerValue = LuceneIndexableDocument.uppercase(header.getValue());
            doc.add((IndexableField)new TextField("headers", String.format("%s: %s", headerName, headerValue), Field.Store.NO));
            doc.add((IndexableField)new TextField("header_" + headerName, headerValue, Field.Store.NO));
            switch (headerName) {
                case "TO": {
                    doc.add((IndexableField)new TextField("to", headerValue, Field.Store.NO));
                    doc.add((IndexableField)new SortedSetDocValuesField("firstToMailboxName", new BytesRef((CharSequence)SearchUtil.getMailboxAddress((String)header.getValue()))));
                    break;
                }
                case "FROM": {
                    doc.add((IndexableField)new TextField("from", headerValue, Field.Store.NO));
                    doc.add((IndexableField)new SortedSetDocValuesField("firstFromMailboxName", new BytesRef((CharSequence)SearchUtil.getMailboxAddress((String)header.getValue()))));
                    break;
                }
                case "CC": {
                    doc.add((IndexableField)new TextField("cc", headerValue, Field.Store.NO));
                    doc.add((IndexableField)new SortedSetDocValuesField("firstCcMailboxName", new BytesRef((CharSequence)SearchUtil.getMailboxAddress((String)header.getValue()))));
                    break;
                }
                case "BCC": {
                    doc.add((IndexableField)new TextField("bcc", headerValue, Field.Store.NO));
                    break;
                }
                case "SUBJECT": {
                    doc.add((IndexableField)new StringField("subject", header.getValue(), Field.Store.YES));
                    doc.add((IndexableField)new StringField("baseSubject", headerValue, Field.Store.NO));
                    doc.add((IndexableField)new SortedSetDocValuesField("baseSubject", new BytesRef((CharSequence)SearchUtil.getBaseSubject((String)headerValue))));
                    break;
                }
            }
        });
        doc.add((IndexableField)new TextField("from", LuceneIndexableDocument.uppercase(EMailers.from((Set)headerCollection.getFromAddressSet()).serialize()), Field.Store.YES));
        doc.add((IndexableField)new TextField("to", LuceneIndexableDocument.uppercase(EMailers.from((Set)headerCollection.getToAddressSet()).serialize()), Field.Store.YES));
        doc.add((IndexableField)new TextField("cc", LuceneIndexableDocument.uppercase(EMailers.from((Set)headerCollection.getCcAddressSet()).serialize()), Field.Store.YES));
        doc.add((IndexableField)new TextField("bcc", LuceneIndexableDocument.uppercase(EMailers.from((Set)headerCollection.getBccAddressSet()).serialize()), Field.Store.YES));
        Optional<String> bodyText = mimePartExtracted.locateFirstTextBody().map(SearchUtil::removeGreaterThanCharactersAtBeginningOfLine);
        Optional bodyHtml = mimePartExtracted.locateFirstHtmlBody();
        bodyText.or(() -> bodyHtml).ifPresent(bodyContent -> doc.add((IndexableField)new TextField("body", bodyContent, Field.Store.YES)));
        mimePartExtracted.getAttachmentsStream().forEach(attachmentFields -> {
            attachmentFields.getTextualBody().ifPresent(textualBody -> doc.add((IndexableField)new TextField(DocumentFieldConstants.ATTACHMENT_TEXT_CONTENT_FIELD, textualBody, Field.Store.YES)));
            attachmentFields.getFileName().ifPresent(fileName -> doc.add((IndexableField)new StringField(DocumentFieldConstants.ATTACHMENT_FILE_NAME_FIELD, LuceneIndexableDocument.uppercase(fileName), Field.Store.YES)));
        });
        return doc;
    }

    public Document createFlagsDocument(MailboxMessage message) {
        return this.createFlagsDocument(message.getMailboxId(), message.getUid(), message.createFlags());
    }

    public Document createFlagsDocument(MailboxId mailboxId, MessageUid messageUid, Flags messageFlags) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", LuceneIndexableDocument.createFlagsIdField(mailboxId, messageUid), Field.Store.YES));
        doc.add((IndexableField)new StringField("mailboxid", mailboxId.serialize(), Field.Store.YES));
        Optional.of(messageUid.asLong()).ifPresent(uidAsLong -> {
            doc.add((IndexableField)new NumericDocValuesField("uid", uidAsLong));
            doc.add((IndexableField)new LongPoint("uid", new long[]{uidAsLong}));
            doc.add((IndexableField)new StoredField("uid", uidAsLong.longValue()));
        });
        Arrays.stream(messageFlags.getSystemFlags()).forEach(sysFlag -> doc.add((IndexableField)new StringField("flags", Optional.ofNullable(SYSTEM_FLAG_STRING_MAP.get(sysFlag)).orElse(sysFlag.toString()), Field.Store.YES)));
        Arrays.stream(messageFlags.getUserFlags()).forEach(userFlag -> doc.add((IndexableField)new StringField("flags", LuceneIndexableDocument.lowercase(userFlag), Field.Store.YES)));
        if (messageFlags.getSystemFlags().length == 0 && messageFlags.getUserFlags().length == 0) {
            doc.add((IndexableField)new StringField("flags", "", Field.Store.NO));
        }
        return doc;
    }

    public static String createFlagsIdField(MailboxId mailboxId, MessageUid messageUid) {
        return "flags-" + mailboxId.serialize() + "-" + messageUid.asLong();
    }

    private static void indexSaveDateFields(Date saveDate, Document doc) {
        doc.add((IndexableField)new StringField("saveDateYearResolution", DateTools.dateToString((Date)saveDate, (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO));
        doc.add((IndexableField)new StringField("saveDateMonthResolution", DateTools.dateToString((Date)saveDate, (DateTools.Resolution)DateTools.Resolution.MONTH), Field.Store.NO));
        doc.add((IndexableField)new StringField("saveDateDayResolution", DateTools.dateToString((Date)saveDate, (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.NO));
        doc.add((IndexableField)new StringField("saveDateHourResolution", DateTools.dateToString((Date)saveDate, (DateTools.Resolution)DateTools.Resolution.HOUR), Field.Store.NO));
        doc.add((IndexableField)new StringField("saveDateMinuteResolution", DateTools.dateToString((Date)saveDate, (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.NO));
        doc.add((IndexableField)new StringField("saveDateSecondResolution", DateTools.dateToString((Date)saveDate, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.NO));
    }

    private static void indexInternalDateFields(Date date, Document doc) {
        doc.add((IndexableField)new StringField("internaldateYearResolution", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO));
        doc.add((IndexableField)new StringField("internaldateMonthResolution", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.MONTH), Field.Store.NO));
        doc.add((IndexableField)new StringField("internaldateDayResolution", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.NO));
        doc.add((IndexableField)new StringField("internaldateHourResolution", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.HOUR), Field.Store.NO));
        doc.add((IndexableField)new StringField("internaldateMinuteResolution", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.NO));
        doc.add((IndexableField)new StringField("internaldateSecondResolution", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("internaldateMillisecondResolution", Long.parseLong(DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.MILLISECOND))));
    }

    private static void indexSentDateFields(Date sentDate, Document doc) {
        doc.add((IndexableField)new StringField("sentdateYearResolution", DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO));
        doc.add((IndexableField)new StringField("sentdateMonthResolution", DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MONTH), Field.Store.NO));
        doc.add((IndexableField)new StringField("sentdateDayResolution", DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.NO));
        doc.add((IndexableField)new StringField("sentdateHourResolution", DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.HOUR), Field.Store.NO));
        doc.add((IndexableField)new StringField("sentdateMinuteResolution", DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.NO));
        doc.add((IndexableField)new StringField("sentdateSecondResolution", DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.NO));
        doc.add((IndexableField)new StringField("sentdateMillisecondResolution", DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("sentdateSort", Long.parseLong(DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND))));
    }

    public static String uppercase(String value) {
        return value.toUpperCase(Locale.US);
    }

    public static String lowercase(String value) {
        return value.toLowerCase(Locale.US);
    }
}

