/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.events;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.quota.model.HistoryEvolution;
import org.apache.james.mailbox.quota.model.QuotaThreshold;
import org.apache.james.mailbox.quota.model.QuotaThresholdChange;

public record HistoryEvolutionDTO(@JsonProperty(value="change") HistoryEvolution.HistoryChangeType change, @JsonProperty(value="recentness") Optional<HistoryEvolution.HighestThresholdRecentness> recentness, @JsonProperty(value="threshold") Optional<Double> threshold, @JsonProperty(value="instant") Optional<Long> instant) {
    @JsonIgnore
    public static HistoryEvolutionDTO toDto(HistoryEvolution historyEvolution) {
        return new HistoryEvolutionDTO(historyEvolution.getThresholdHistoryChange(), historyEvolution.getRecentness(), historyEvolution.getThresholdChange().map(QuotaThresholdChange::getQuotaThreshold).map(QuotaThreshold::getQuotaOccupationRatio), historyEvolution.getThresholdChange().map(QuotaThresholdChange::getInstant).map(Instant::toEpochMilli));
    }

    @JsonIgnore
    public HistoryEvolution toHistoryEvolution() {
        Preconditions.checkState((Booleans.countTrue((boolean[])new boolean[]{this.threshold.isPresent(), this.instant.isPresent()}) != 1 ? 1 : 0) != 0, (Object)"threshold and instant needs to be both set, or both unset. Mixed states not allowed.");
        Optional<QuotaThresholdChange> quotaThresholdChange = this.threshold.map(QuotaThreshold::new).map(value -> new QuotaThresholdChange((QuotaThreshold)value, Instant.ofEpochMilli(this.instant.get())));
        return new HistoryEvolution(this.change, this.recentness, quotaThresholdChange);
    }
}

