/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class MinimalCopyBytesResponseTransformer
implements AsyncResponseTransformer<GetObjectResponse, ResponseBytes<GetObjectResponse>> {
    private final S3BlobStoreConfiguration configuration;
    private final BlobId blobId;
    private volatile CompletableFuture<byte[]> cf;
    private volatile GetObjectResponse response;

    public MinimalCopyBytesResponseTransformer(S3BlobStoreConfiguration configuration, BlobId blobId) {
        this.configuration = configuration;
        this.blobId = blobId;
    }

    public CompletableFuture<ResponseBytes<GetObjectResponse>> prepare() {
        this.cf = new CompletableFuture();
        return this.cf.thenApply(arr -> ResponseBytes.fromByteArrayUnsafe((Object)this.response, (byte[])arr));
    }

    public void onResponse(GetObjectResponse response) {
        boolean exceedMaximumSize = this.configuration.getInMemoryReadLimit().map(limit -> response.contentLength() > limit).orElse(false);
        if (exceedMaximumSize) {
            throw new IllegalArgumentException(String.format("%s blob of %l size exceed maximum size allowed for in memory reads (%l)", this.blobId.asString(), response.contentLength(), this.configuration.getInMemoryReadLimit().orElse(-1L)));
        }
        this.response = response;
    }

    public void onStream(SdkPublisher<ByteBuffer> publisher) {
        publisher.subscribe((Subscriber)new BaosSubscriber(this.cf, this.response.contentLength().intValue()));
    }

    public void exceptionOccurred(Throwable throwable) {
        this.cf.completeExceptionally(throwable);
    }

    static class BaosSubscriber
    implements Subscriber<ByteBuffer> {
        private final CompletableFuture<byte[]> resultFuture;
        private final byte[] buffer;
        private int pos = 0;
        private Subscription subscription;

        BaosSubscriber(CompletableFuture<byte[]> resultFuture, int size) {
            this.resultFuture = resultFuture;
            this.buffer = new byte[size];
        }

        public void onSubscribe(Subscription s) {
            if (this.subscription != null) {
                s.cancel();
            } else {
                this.subscription = s;
                this.subscription.request(Long.MAX_VALUE);
            }
        }

        public void onNext(ByteBuffer byteBuffer) {
            int written = byteBuffer.remaining();
            byteBuffer.get(this.buffer, this.pos, written);
            this.pos += written;
            this.subscription.request(1L);
        }

        public void onError(Throwable throwable) {
            this.resultFuture.completeExceptionally(throwable);
        }

        public void onComplete() {
            this.resultFuture.complete(this.buffer);
        }
    }
}

