/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public abstract class AbstractDeserializer<T>
implements Deserializer<T> {
    protected static final int EOF = -1;
    private static final byte[] EMPTY_BYTES = new byte[0];

    protected AbstractDeserializer() {
    }

    @Override
    public final T deserialize(byte[] bytes) throws DeserializationException {
        bytes = bytes == null ? EMPTY_BYTES : bytes;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
        return this.deserialize(reader);
    }

    @Override
    public final T deserialize(Reader reader) throws DeserializationException {
        Assert.notNull(reader, "Reader argument cannot be null.");
        try {
            return this.doDeserialize(reader);
        }
        catch (Throwable t) {
            if (t instanceof DeserializationException) {
                throw (DeserializationException)t;
            }
            String msg = "Unable to deserialize: " + t.getMessage();
            throw new DeserializationException(msg, t);
        }
    }

    protected abstract T doDeserialize(Reader var1) throws Exception;
}

