/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.JmapChange;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxAndEmailChange
implements JmapChange {
    private final AccountId accountId;
    private final EmailChange emailChange;
    private final MailboxChange mailboxChange;

    public MailboxAndEmailChange(AccountId accountId, EmailChange emailChange, MailboxChange mailboxChange) {
        Preconditions.checkArgument((boolean)accountId.equals(emailChange.getAccountId()));
        Preconditions.checkArgument((boolean)accountId.equals(mailboxChange.getAccountId()));
        this.accountId = accountId;
        this.emailChange = emailChange;
        this.mailboxChange = mailboxChange;
    }

    @Override
    public AccountId getAccountId() {
        return this.accountId;
    }

    public EmailChange getEmailChange() {
        return this.emailChange;
    }

    public MailboxChange getMailboxChange() {
        return this.mailboxChange;
    }

    public Optional<JmapChange> normalize() {
        if (this.isNoop()) {
            return Optional.empty();
        }
        if (this.mailboxChange.isNoop()) {
            return Optional.of(this.emailChange);
        }
        return Optional.of(this);
    }

    @Override
    public boolean isNoop() {
        return this.mailboxChange.isNoop() && this.emailChange.isNoop();
    }

    @Override
    public MailboxAndEmailChange forSharee(AccountId accountId, Supplier<State> state) {
        return new MailboxAndEmailChange(accountId, (EmailChange)this.emailChange.forSharee(accountId, (Supplier)state), (MailboxChange)this.mailboxChange.forSharee(accountId, (Supplier)state));
    }

    public static class Factory {
        private final State.Factory stateFactory;
        private final MessageIdManager messageIdManager;
        private final SessionProvider sessionProvider;

        @Inject
        public Factory(State.Factory stateFactory, MessageIdManager messageIdManager, SessionProvider sessionProvider) {
            this.stateFactory = stateFactory;
            this.messageIdManager = messageIdManager;
            this.sessionProvider = sessionProvider;
        }

        public List<JmapChange> fromAdded(MailboxEvents.Added messageAdded, ZonedDateTime now, List<AccountId> sharees) {
            AccountId accountId = AccountId.fromUsername(messageAdded.getUsername());
            EmailChange.Builder emailChangeBuilder = EmailChange.builder().accountId(accountId).state(this.stateFactory.generate()).date(now).isShared(false).isDelivery(messageAdded.isDelivery());
            MailboxChange mailboxChange = MailboxChange.builder().accountId(accountId).state(this.stateFactory.generate()).date(now).isCountChange(true).updated((List<MailboxId>)ImmutableList.of((Object)messageAdded.getMailboxId())).build();
            if (messageAdded.isAppended()) {
                return new MailboxAndEmailChange(accountId, emailChangeBuilder.created((Collection<MessageId>)messageAdded.getMessageIds()).build(), mailboxChange).propagateToSharee(sharees, this.stateFactory);
            }
            return new MailboxAndEmailChange(accountId, emailChangeBuilder.updated((Collection<MessageId>)messageAdded.getMessageIds()).build(), mailboxChange).propagateToSharee(sharees, this.stateFactory);
        }

        public List<JmapChange> fromFlagsUpdated(MailboxEvents.FlagsUpdated messageFlagUpdated, ZonedDateTime now, List<AccountId> sharees) {
            return (List)this.flagUpdateChange(messageFlagUpdated, now).map(change -> change.propagateToSharee(sharees, this.stateFactory)).orElse(ImmutableList.of());
        }

        private Optional<JmapChange> flagUpdateChange(MailboxEvents.FlagsUpdated event, ZonedDateTime now) {
            AccountId accountId = AccountId.fromUsername(event.getUsername());
            EmailChange.Builder emailChangeBuilder = EmailChange.builder().accountId(accountId).state(this.stateFactory.generate()).date(now).isShared(false);
            ImmutableSet.Builder updatedMailboxes = ImmutableSet.builder();
            event.getUpdatedFlags().forEach(updatedFLags -> this.handleFlagUpdate((UpdatedFlags)updatedFLags, event.getMailboxId()).accept(emailChangeBuilder, (ImmutableSet.Builder<MailboxId>)updatedMailboxes));
            return new MailboxAndEmailChange(accountId, emailChangeBuilder.build(), MailboxChange.builder().accountId(accountId).state(this.stateFactory.generate()).date(now).isCountChange(true).updated((List<MailboxId>)ImmutableList.copyOf((Collection)updatedMailboxes.build())).build()).normalize();
        }

        private BiConsumer<EmailChange.Builder, ImmutableSet.Builder<MailboxId>> handleFlagUpdate(UpdatedFlags updatedFlags, MailboxId mailboxId) {
            return (emailChangeBuilder, mailboxChangeBuilder) -> {
                MessageId messageId = (MessageId)updatedFlags.getMessageId().get();
                if (updatedFlags.isModifiedToSet(Flags.Flag.DELETED)) {
                    emailChangeBuilder.destroyed(messageId);
                    mailboxChangeBuilder.add((Object)mailboxId);
                    return;
                }
                if (updatedFlags.isModifiedToUnset(Flags.Flag.DELETED)) {
                    emailChangeBuilder.created(messageId);
                    mailboxChangeBuilder.add((Object)mailboxId);
                    return;
                }
                if (updatedFlags.getOldFlags().contains(Flags.Flag.DELETED)) {
                    return;
                }
                if (!updatedFlags.flagsChangedIgnoringRecent()) {
                    return;
                }
                emailChangeBuilder.updated(messageId);
                if (updatedFlags.isChanged(Flags.Flag.SEEN)) {
                    mailboxChangeBuilder.add((Object)mailboxId);
                }
            };
        }

        public Flux<JmapChange> fromExpunged(MailboxEvents.Expunged expunged, ZonedDateTime now, List<Username> sharees) {
            State state = this.stateFactory.generate();
            boolean delegated = true;
            Mono<JmapChange> ownerChange = this.fromExpunged(expunged, now, expunged.getUsername(), state, !delegated);
            Flux shareeChanges = Flux.fromIterable(sharees).concatMap(shareeId -> this.fromExpunged(expunged, now, (Username)shareeId, state, delegated));
            return Flux.concat((Publisher[])new Publisher[]{ownerChange, shareeChanges});
        }

        private Mono<JmapChange> fromExpunged(MailboxEvents.Expunged expunged, ZonedDateTime now, Username username, State state, boolean delegated) {
            AccountId accountId = AccountId.fromUsername(username);
            ImmutableSet changedMessageIds = (ImmutableSet)expunged.getExpunged().values().stream().filter(metadata -> !metadata.getFlags().contains(Flags.Flag.DELETED)).map(MessageMetaData::getMessageId).collect(ImmutableSet.toImmutableSet());
            if (changedMessageIds.isEmpty()) {
                return Mono.empty();
            }
            MailboxChange mailboxChange = MailboxChange.builder().accountId(accountId).state(state).date(now).isCountChange(true).shared(delegated).updated((List<MailboxId>)ImmutableList.of((Object)expunged.getMailboxId())).build();
            return Mono.from((Publisher)this.messageIdManager.accessibleMessagesReactive((Collection)expunged.getMessageIds(), this.sessionProvider.createSystemSession(username))).map(accessibleMessageIds -> new MailboxAndEmailChange(accountId, EmailChange.builder().accountId(AccountId.fromUsername(username)).state(state).date(now).isShared(delegated).updated((Collection<MessageId>)Sets.intersection((Set)changedMessageIds, (Set)accessibleMessageIds)).destroyed((Collection<MessageId>)Sets.difference((Set)changedMessageIds, (Set)accessibleMessageIds)).build(), mailboxChange)).switchIfEmpty(Mono.just((Object)mailboxChange));
        }
    }
}

