/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v12;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v12.BaseCommandMarshaller;

public class RemoveInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 12;
    }

    @Override
    public DataStructure createObject() {
        return new RemoveInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        RemoveInfo info = (RemoveInfo)o;
        info.setObjectId(this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info.setLastDeliveredSequenceId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        RemoveInfo info = (RemoveInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info.getObjectId(), bs);
        return (rc += this.tightMarshalLong1(wireFormat, info.getLastDeliveredSequenceId(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        RemoveInfo info = (RemoveInfo)o;
        this.tightMarshalCachedObject2(wireFormat, info.getObjectId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getLastDeliveredSequenceId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        RemoveInfo info = (RemoveInfo)o;
        info.setObjectId(this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info.setLastDeliveredSequenceId(this.looseUnmarshalLong(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        RemoveInfo info = (RemoveInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info.getObjectId(), dataOut);
        this.looseMarshalLong(wireFormat, info.getLastDeliveredSequenceId(), dataOut);
    }
}

