/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.event;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.event.json.MailboxEventSerializer;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusId;
import org.apache.james.events.EventBusReconnectionHandler;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.GroupRegistrationHandler;
import org.apache.james.events.KeyReconnectionHandler;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.RabbitEventBusConsumerHealthCheck;
import org.apache.james.events.RabbitMQEventBus;
import org.apache.james.events.RabbitMQMailboxEventBusDeadLetterQueueHealthCheck;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.RoutingKeyConverter;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import reactor.rabbitmq.Sender;

public class MailboxEventBusModule
extends AbstractModule {
    protected void configure() {
        this.bind(NamingStrategy.class).toInstance((Object)NamingStrategy.MAILBOX_EVENT_NAMING_STRATEGY);
        Multibinder.newSetBinder((Binder)this.binder(), RegistrationKey.Factory.class).addBinding().to(MailboxIdRegistrationKey.Factory.class);
        this.bind(RetryBackoffConfiguration.class).toInstance((Object)RetryBackoffConfiguration.DEFAULT);
        this.bind(EventBusId.class).toInstance((Object)EventBusId.random());
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(RabbitMQMailboxEventBusDeadLetterQueueHealthCheck.class);
    }

    @ProvidesIntoSet
    HealthCheck healthCheck(RabbitMQEventBus eventBus, NamingStrategy namingStrategy, SimpleConnectionPool connectionPool) {
        return new RabbitEventBusConsumerHealthCheck((EventBus)eventBus, namingStrategy, connectionPool, GroupRegistrationHandler.GROUP);
    }

    @ProvidesIntoSet
    SimpleConnectionPool.ReconnectionHandler provideReconnectionHandler(RabbitMQEventBus eventBus) {
        return new EventBusReconnectionHandler((EventBus)eventBus);
    }

    @ProvidesIntoSet
    SimpleConnectionPool.ReconnectionHandler provideReconnectionHandler(NamingStrategy namingStrategy, EventBusId eventBusId, RabbitMQConfiguration configuration) {
        return new KeyReconnectionHandler(namingStrategy, eventBusId, configuration);
    }

    @ProvidesIntoSet
    InitializationOperation workQueue(RabbitMQEventBus instance) {
        return InitilizationOperationBuilder.forClass(RabbitMQEventBus.class).init(() -> ((RabbitMQEventBus)instance).start());
    }

    @Provides
    @Singleton
    RabbitMQEventBus provideRabbitMQEventBus(NamingStrategy namingStrategy, Sender sender, ReceiverProvider receiverProvider, MailboxEventSerializer eventSerializer, RetryBackoffConfiguration retryBackoff, RoutingKeyConverter routingKeyConverter, EventDeadLetters eventDeadLetters, MetricFactory metricFactory, ReactorRabbitMQChannelPool channelPool, EventBusId eventBusId, RabbitMQConfiguration configuration) {
        return new RabbitMQEventBus(namingStrategy, sender, receiverProvider, (EventSerializer)eventSerializer, retryBackoff, routingKeyConverter, eventDeadLetters, metricFactory, channelPool, eventBusId, configuration);
    }

    @Provides
    @Singleton
    EventBus provideEventBus(RabbitMQEventBus rabbitMQEventBus) {
        return rabbitMQEventBus;
    }

    @ProvidesIntoSet
    EventBus registerEventBus(EventBus eventBus) {
        return eventBus;
    }
}

