/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import jakarta.inject.Singleton;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.modules.server.HostnameModule;
import org.apache.james.modules.server.TaskSerializationModule;
import org.apache.james.task.TaskManager;
import org.apache.james.task.eventsourcing.EventSourcingTaskManager;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.apache.james.task.eventsourcing.cassandra.CassandraTaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.cassandra.CassandraTaskExecutionDetailsProjectionModule;
import org.apache.james.task.eventsourcing.distributed.CancelRequestQueueName;
import org.apache.james.task.eventsourcing.distributed.DistributedTaskManagerHealthCheck;
import org.apache.james.task.eventsourcing.distributed.RabbitMQTerminationSubscriber;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueue;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueueConfiguration;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueueConfiguration$;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueueReconnectionHandler;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueueSupplier;
import org.apache.james.task.eventsourcing.distributed.TerminationQueueName;
import org.apache.james.task.eventsourcing.distributed.TerminationReconnectionHandler;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.PropertiesProvider;

public class DistributedTaskManagerModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new HostnameModule());
        this.install((Module)new TaskSerializationModule());
        this.bind(CassandraTaskExecutionDetailsProjection.class).in(Scopes.SINGLETON);
        this.bind(EventSourcingTaskManager.class).in(Scopes.SINGLETON);
        this.bind(RabbitMQWorkQueueSupplier.class).in(Scopes.SINGLETON);
        this.bind(RabbitMQTerminationSubscriber.class).in(Scopes.SINGLETON);
        this.bind(TaskExecutionDetailsProjection.class).to(CassandraTaskExecutionDetailsProjection.class);
        this.bind(TerminationSubscriber.class).to(RabbitMQTerminationSubscriber.class);
        this.bind(TaskManager.class).to(EventSourcingTaskManager.class);
        this.bind(WorkQueueSupplier.class).to(RabbitMQWorkQueueSupplier.class);
        this.bind(CancelRequestQueueName.class).toInstance((Object)CancelRequestQueueName.generate());
        this.bind(TerminationQueueName.class).toInstance((Object)TerminationQueueName.generate());
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraDataDefinition.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraTaskExecutionDetailsProjectionModule.MODULE());
        Multibinder reconnectionHandlerMultibinder = Multibinder.newSetBinder((Binder)this.binder(), SimpleConnectionPool.ReconnectionHandler.class);
        reconnectionHandlerMultibinder.addBinding().to(RabbitMQWorkQueueReconnectionHandler.class);
        reconnectionHandlerMultibinder.addBinding().to(TerminationReconnectionHandler.class);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(DistributedTaskManagerHealthCheck.class);
    }

    @Provides
    @Singleton
    private RabbitMQWorkQueueConfiguration getWorkQueueConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("rabbitmq");
            return RabbitMQWorkQueueConfiguration$.MODULE$.from(configuration);
        }
        catch (FileNotFoundException e) {
            return RabbitMQWorkQueueConfiguration$.MODULE$.enabled();
        }
    }

    @ProvidesIntoSet
    InitializationOperation terminationSubscriber(RabbitMQTerminationSubscriber instance) {
        return InitilizationOperationBuilder.forClass(RabbitMQTerminationSubscriber.class).init(() -> ((RabbitMQTerminationSubscriber)instance).start());
    }

    @ProvidesIntoSet
    InitializationOperation workQueue(EventSourcingTaskManager instance) {
        return InitilizationOperationBuilder.forClass(RabbitMQWorkQueue.class).init(() -> ((EventSourcingTaskManager)instance).start());
    }
}

