/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.vector;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class AbstractVectorToArrayCodec<ArrayT>
implements TypeCodec<ArrayT> {
    @NonNull
    protected final VectorType cqlType;
    @NonNull
    protected final GenericType<ArrayT> javaType;

    protected AbstractVectorToArrayCodec(@NonNull VectorType cqlType, @NonNull GenericType<ArrayT> arrayType) {
        this.cqlType = Objects.requireNonNull(cqlType, "cqlType cannot be null");
        this.javaType = Objects.requireNonNull(arrayType, "arrayType cannot be null");
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Expecting Java array class, got " + arrayType);
        }
    }

    @Override
    @NonNull
    public GenericType<ArrayT> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable ArrayT array, @NonNull ProtocolVersion protocolVersion) {
        if (array == null) {
            return null;
        }
        int length = Array.getLength(array);
        int totalSize = length * this.sizeOfComponentType();
        ByteBuffer output = ByteBuffer.allocate(totalSize);
        for (int i = 0; i < length; ++i) {
            this.serializeElement(output, array, i, protocolVersion);
        }
        output.flip();
        return output;
    }

    @Override
    @Nullable
    public ArrayT decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            throw new IllegalArgumentException("Input ByteBuffer must not be null and must have non-zero remaining bytes");
        }
        ByteBuffer input = bytes.duplicate();
        int length = this.cqlType.getDimensions();
        int elementSize = this.sizeOfComponentType();
        ArrayT array = this.newInstance();
        for (int i = 0; i < length; ++i) {
            if (elementSize < 0) {
                throw new NullPointerException("Primitive arrays cannot store null elements");
            }
            this.deserializeElement(input, array, i, protocolVersion);
        }
        return array;
    }

    @NonNull
    protected abstract ArrayT newInstance();

    protected abstract int sizeOfComponentType();

    protected abstract void serializeElement(@NonNull ByteBuffer var1, @NonNull ArrayT var2, int var3, @NonNull ProtocolVersion var4);

    protected abstract void deserializeElement(@NonNull ByteBuffer var1, @NonNull ArrayT var2, int var3, @NonNull ProtocolVersion var4);
}

