/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.data.ByteUtils;
import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.Immutable;

@Immutable
public class SimpleBlobCodec
extends MappingCodec<ByteBuffer, byte[]> {
    public SimpleBlobCodec() {
        super(TypeCodecs.BLOB, GenericType.of(byte[].class));
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof byte[];
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return byte[].class.equals(javaClass);
    }

    @Override
    @Nullable
    protected byte[] innerToOuter(@Nullable ByteBuffer value) {
        return value == null ? null : ByteUtils.getArray(value);
    }

    @Override
    @Nullable
    protected ByteBuffer outerToInner(@Nullable byte[] value) {
        return value == null ? null : ByteBuffer.wrap(value);
    }
}

