/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.internal.core.data.DefaultTupleValue;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultTupleType
implements TupleType,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<DataType> componentTypes;
    private volatile transient AttachmentPoint attachmentPoint;
    private static final Joiner WITH_COMMA = Joiner.on((String)", ");

    public DefaultTupleType(@NonNull List<DataType> componentTypes, @NonNull AttachmentPoint attachmentPoint) {
        Preconditions.checkNotNull(componentTypes);
        this.componentTypes = ImmutableList.copyOf(componentTypes);
        this.attachmentPoint = attachmentPoint;
    }

    public DefaultTupleType(@NonNull List<DataType> componentTypes) {
        this(componentTypes, AttachmentPoint.NONE);
    }

    @Override
    @NonNull
    public List<DataType> getComponentTypes() {
        return this.componentTypes;
    }

    @Override
    @NonNull
    public TupleValue newValue() {
        return new DefaultTupleValue(this);
    }

    @Override
    @NonNull
    public TupleValue newValue(Object ... values) {
        return new DefaultTupleValue((TupleType)this, values);
    }

    @Override
    public boolean isDetached() {
        return this.attachmentPoint == AttachmentPoint.NONE;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        this.attachmentPoint = attachmentPoint;
        for (DataType componentType : this.componentTypes) {
            componentType.attach(attachmentPoint);
        }
    }

    @Override
    @NonNull
    public AttachmentPoint getAttachmentPoint() {
        return this.attachmentPoint;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TupleType) {
            TupleType that = (TupleType)other;
            return this.componentTypes.equals(that.getComponentTypes());
        }
        return false;
    }

    public int hashCode() {
        return this.componentTypes.hashCode();
    }

    public String toString() {
        return "Tuple(" + WITH_COMMA.join(this.componentTypes) + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Preconditions.checkNotNull(this.componentTypes);
        this.attachmentPoint = AttachmentPoint.NONE;
    }
}

