/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.session.BuiltInRequestProcessors;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.Dependency;
import com.datastax.oss.driver.internal.core.util.GraalDependencyChecker;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;

public class BuiltInRequestProcessorsSubstitutions {

    public static class GraphPresentReactiveMissing
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return GraalDependencyChecker.isPresent(Dependency.TINKERPOP) && !GraalDependencyChecker.isPresent(Dependency.REACTIVE_STREAMS);
        }
    }

    public static class GraphMissingReactivePresent
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !GraalDependencyChecker.isPresent(Dependency.TINKERPOP) && GraalDependencyChecker.isPresent(Dependency.REACTIVE_STREAMS);
        }
    }

    public static class GraphMissingReactiveMissing
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !GraalDependencyChecker.isPresent(Dependency.TINKERPOP) && !GraalDependencyChecker.isPresent(Dependency.REACTIVE_STREAMS);
        }
    }

    @TargetClass(value=BuiltInRequestProcessors.class, onlyWith={GraphPresentReactiveMissing.class})
    public static final class BuiltInRequestProcessorsGraphPresentReactiveMissing {
        @Substitute
        public static List<RequestProcessor<?, ?>> createDefaultProcessors(DefaultDriverContext context) {
            ArrayList processors = new ArrayList();
            BuiltInRequestProcessors.addBasicProcessors(processors, context);
            BuiltInRequestProcessors.addGraphProcessors(context, processors);
            return processors;
        }
    }

    @TargetClass(value=BuiltInRequestProcessors.class, onlyWith={GraphMissingReactivePresent.class})
    public static final class BuiltInRequestProcessorsGraphMissingReactivePresent {
        @Substitute
        public static List<RequestProcessor<?, ?>> createDefaultProcessors(DefaultDriverContext context) {
            ArrayList processors = new ArrayList();
            BuiltInRequestProcessors.addBasicProcessors(processors, context);
            BuiltInRequestProcessors.addReactiveProcessors(processors);
            return processors;
        }
    }

    @TargetClass(value=BuiltInRequestProcessors.class, onlyWith={GraphMissingReactiveMissing.class})
    public static final class BuiltInRequestProcessorsGraphMissingReactiveMissing {
        @Substitute
        public static List<RequestProcessor<?, ?>> createDefaultProcessors(DefaultDriverContext context) {
            ArrayList processors = new ArrayList();
            BuiltInRequestProcessors.addBasicProcessors(processors, context);
            return processors;
        }
    }
}

