/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import java.util.List;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NoopMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NoopMetricsFactory.class);

    public NoopMetricsFactory(DriverContext context) {
        String logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        List<String> enabledSessionMetrics = config.getStringList(DefaultDriverOption.METRICS_SESSION_ENABLED);
        List<String> enabledNodeMetrics = config.getStringList(DefaultDriverOption.METRICS_NODE_ENABLED);
        if (!enabledSessionMetrics.isEmpty() || !enabledNodeMetrics.isEmpty()) {
            LOG.warn("[{}] Some session-level or node-level metrics were enabled, but NoopMetricsFactory is being used: all metrics will be empty", (Object)logPrefix);
        }
    }

    @Override
    public Optional<Metrics> getMetrics() {
        return Optional.empty();
    }

    @Override
    public SessionMetricUpdater getSessionUpdater() {
        return NoopSessionMetricUpdater.INSTANCE;
    }

    @Override
    public NodeMetricUpdater newNodeUpdater(Node node) {
        return NoopNodeMetricUpdater.INSTANCE;
    }
}

