/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.util.Assert;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

abstract class AbstractCopyResponse
implements BackendMessage {
    private final Collection<Format> columnFormats;
    private final Format overallFormat;

    AbstractCopyResponse(Collection<Format> columnFormats, Format overallFormat) {
        this.columnFormats = Assert.requireNonNull(columnFormats, "columnFormats must not be null");
        this.overallFormat = Assert.requireNonNull(overallFormat, "overallFormat must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCopyResponse that = (AbstractCopyResponse)o;
        return Objects.equals(this.columnFormats, that.columnFormats) && this.overallFormat == that.overallFormat;
    }

    public final Collection<Format> getColumnFormats() {
        return this.columnFormats;
    }

    public final Format getOverallFormat() {
        return this.overallFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnFormats, this.overallFormat});
    }

    public String toString() {
        return "AbstractCopyResponse{columnFormats=" + this.columnFormats + ", overallFormat=" + (Object)((Object)this.overallFormat) + '}';
    }

    static Set<Format> readColumnFormats(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        int count = in.readShort();
        EnumSet<Format> formatSet = EnumSet.noneOf(Format.class);
        for (int i = 0; i < count; ++i) {
            formatSet.add(Format.valueOf(in.readShort()));
        }
        return formatSet;
    }
}

