/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractBinaryCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.nio.ByteBuffer;

final class BinaryByteBufferCodec
extends AbstractBinaryCodec<ByteBuffer> {
    BinaryByteBufferCodec(ByteBufAllocator byteBufAllocator) {
        super(ByteBuffer.class, byteBufAllocator);
    }

    @Override
    ByteBuffer doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends ByteBuffer> type) {
        return ByteBuffer.wrap(this.decode(format, buffer));
    }

    @Override
    EncodedParameter doEncode(ByteBuffer value, PostgresTypeIdentifier dataType) {
        return BinaryByteBufferCodec.create(Format.FORMAT_TEXT, dataType, () -> this.encodeToHex(Unpooled.wrappedBuffer((ByteBuffer)value)));
    }

    @Override
    public String encodeToText(ByteBuffer value) {
        Assert.requireNonNull(value, "value must not be null");
        return ByteBufUtils.decode(this.encodeToHex(Unpooled.wrappedBuffer((ByteBuffer)value)));
    }
}

