/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractJsonCodec<T>
extends AbstractCodec<T> {
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.JSON, PostgresqlObjectId.JSONB);

    AbstractJsonCodec(Class<T> type) {
        super(type);
    }

    @Override
    EncodedParameter doEncode(T value) {
        return this.doEncode(value, PostgresqlObjectId.JSON);
    }

    @Override
    public EncodedParameter encodeNull() {
        return AbstractJsonCodec.createNull(Format.FORMAT_BINARY, PostgresqlObjectId.JSONB);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return SUPPORTED_TYPES.contains(type);
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return SUPPORTED_TYPES.stream().map(PostgresTypeIdentifier.class::cast).collect(Collectors.toList());
    }
}

