/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import java.text.NumberFormat;
import java.text.ParsePosition;

public final class Version {
    private final String version;
    private final Integer versionNumber;

    public Version(String version) {
        this(version, Version.parseServerVersionStr(version));
    }

    public Version(String version, int versionNumber) {
        this.version = version;
        this.versionNumber = versionNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public String toString() {
        return "Version{version='" + this.version + '\'' + ", versionNumber=" + this.versionNumber + '}';
    }

    static int parseServerVersionStr(String serverVersion) throws NumberFormatException {
        Number part;
        int versionParts;
        NumberFormat numformat = NumberFormat.getIntegerInstance();
        numformat.setGroupingUsed(false);
        ParsePosition parsepos = new ParsePosition(0);
        if (serverVersion == null) {
            return 0;
        }
        int[] parts = new int[3];
        for (versionParts = 0; versionParts < 3 && (part = (Number)numformat.parseObject(serverVersion, parsepos)) != null; ++versionParts) {
            parts[versionParts] = part.intValue();
            if (parsepos.getIndex() == serverVersion.length() || serverVersion.charAt(parsepos.getIndex()) != '.') break;
            parsepos.setIndex(parsepos.getIndex() + 1);
        }
        ++versionParts;
        if (parts[0] >= 10000) {
            if (parsepos.getIndex() == serverVersion.length() && versionParts == 1) {
                return parts[0];
            }
            throw new NumberFormatException("First major-version part equal to or greater than 10000 in invalid version string: " + serverVersion);
        }
        if (versionParts >= 3) {
            if (parts[1] > 99) {
                throw new NumberFormatException("Unsupported second part of major version > 99 in invalid version string: " + serverVersion);
            }
            if (parts[2] > 99) {
                throw new NumberFormatException("Unsupported second part of minor version > 99 in invalid version string: " + serverVersion);
            }
            return (parts[0] * 100 + parts[1]) * 100 + parts[2];
        }
        if (versionParts == 2) {
            if (parts[0] >= 10) {
                return parts[0] * 100 * 100 + parts[1];
            }
            if (parts[1] > 99) {
                throw new NumberFormatException("Unsupported second part of major version > 99 in invalid version string: " + serverVersion);
            }
            return (parts[0] * 100 + parts[1]) * 100;
        }
        if (versionParts == 1 && parts[0] >= 10) {
            return parts[0] * 100 * 100;
        }
        return 0;
    }
}

