/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLMessages;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HostNameTrustManager
implements X509TrustManager {
    @NotNull
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private final boolean allowWildcards;
    private final boolean checkCNWhenSubjectAltNameIsPresent;
    @NotNull
    private final Set<String> acceptableHostNames;

    public HostNameTrustManager(boolean allowWildcards, String ... acceptableHostNames) {
        this(allowWildcards, StaticUtils.toList(acceptableHostNames));
    }

    public HostNameTrustManager(boolean allowWildcards, @NotNull Collection<String> acceptableHostNames) {
        this(allowWildcards, HostNameSSLSocketVerifier.DEFAULT_CHECK_CN_WHEN_SUBJECT_ALT_NAME_IS_PRESENT, acceptableHostNames);
    }

    public HostNameTrustManager(boolean allowWildcards, boolean checkCNWhenSubjectAltNameIsPresent, @NotNull Collection<String> acceptableHostNames) {
        Validator.ensureNotNull(acceptableHostNames);
        Validator.ensureFalse(acceptableHostNames.isEmpty(), "The set of acceptable host names must not be empty.");
        this.allowWildcards = allowWildcards;
        this.checkCNWhenSubjectAltNameIsPresent = checkCNWhenSubjectAltNameIsPresent;
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(acceptableHostNames.size()));
        for (String s : acceptableHostNames) {
            nameSet.add(StaticUtils.toLowerCase(s));
        }
        this.acceptableHostNames = Collections.unmodifiableSet(nameSet);
    }

    public boolean allowWildcards() {
        return this.allowWildcards;
    }

    @NotNull
    public Set<String> getAcceptableHostNames() {
        return this.acceptableHostNames;
    }

    @Override
    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        StringBuilder buffer = new StringBuilder();
        for (String s : this.acceptableHostNames) {
            buffer.setLength(0);
            if (!HostNameSSLSocketVerifier.certificateIncludesHostname(s, chain[0], this.allowWildcards, this.checkCNWhenSubjectAltNameIsPresent, buffer)) continue;
            return;
        }
        throw new CertificateException(SSLMessages.ERR_HOSTNAME_NOT_FOUND.get(buffer.toString()));
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        StringBuilder buffer = new StringBuilder();
        for (String s : this.acceptableHostNames) {
            buffer.setLength(0);
            if (!HostNameSSLSocketVerifier.certificateIncludesHostname(s, chain[0], this.allowWildcards, this.checkCNWhenSubjectAltNameIsPresent, buffer)) continue;
            return;
        }
        throw new CertificateException(SSLMessages.ERR_HOSTNAME_NOT_FOUND.get(buffer.toString()));
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

