/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TimestampArgument
extends Argument {
    private static final long serialVersionUID = -4842934851103696096L;
    @NotNull
    private final List<ArgumentValueValidator> validators;
    @Nullable
    private final List<Date> defaultValues;
    @NotNull
    private final List<ObjectPair<Date, String>> values;

    public TimestampArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, @NotNull String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, false, 1, null, description);
    }

    public TimestampArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, boolean isRequired, int maxOccurrences, @Nullable String valuePlaceholder, @NotNull String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, (List<Date>)null);
    }

    public TimestampArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, boolean isRequired, int maxOccurrences, @Nullable String valuePlaceholder, @NotNull String description, @Nullable Date defaultValue) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, defaultValue == null ? null : Collections.singletonList(defaultValue));
    }

    public TimestampArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, boolean isRequired, int maxOccurrences, @Nullable String valuePlaceholder, @NotNull String description, @Nullable List<Date> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder == null ? ArgsMessages.INFO_PLACEHOLDER_TIMESTAMP.get() : valuePlaceholder, description);
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList<ObjectPair<Date, String>>(5);
        this.validators = new ArrayList<ArgumentValueValidator>(5);
    }

    private TimestampArgument(@NotNull TimestampArgument source) {
        super(source);
        this.defaultValues = source.defaultValues;
        this.values = new ArrayList<ObjectPair<Date, String>>(5);
        this.validators = new ArrayList<ArgumentValueValidator>(source.validators);
    }

    @Nullable
    public List<Date> getDefaultValues() {
        return this.defaultValues;
    }

    public void addValueValidator(@NotNull ArgumentValueValidator validator) {
        this.validators.add(validator);
    }

    @Override
    protected void addValue(@NotNull String valueString) throws ArgumentException {
        Date d;
        try {
            d = TimestampArgument.parseTimestamp(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_TIMESTAMP_VALUE_NOT_TIMESTAMP.get(valueString, this.getIdentifierString()), e);
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        for (ArgumentValueValidator v : this.validators) {
            v.validateArgumentValue(this, valueString);
        }
        this.values.add(new ObjectPair<Date, String>(d, valueString));
    }

    @NotNull
    public static Date parseTimestamp(@NotNull String s) throws ParseException {
        try {
            return StaticUtils.decodeGeneralizedTime(s);
        }
        catch (Exception exception) {
            try {
                return StaticUtils.decodeRFC3339Time(s);
            }
            catch (Exception exception2) {
                String dateFormatString;
                switch (s.length()) {
                    case 18: {
                        dateFormatString = "yyyyMMddHHmmss.SSS";
                        break;
                    }
                    case 14: {
                        dateFormatString = "yyyyMMddHHmmss";
                        break;
                    }
                    case 12: {
                        dateFormatString = "yyyyMMddHHmm";
                        break;
                    }
                    default: {
                        throw new ParseException(ArgsMessages.ERR_TIMESTAMP_PARSE_ERROR.get(s), 0);
                    }
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
                dateFormat.setLenient(false);
                return dateFormat.parse(s);
            }
        }
    }

    @Nullable
    public Date getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0).getFirst();
    }

    @NotNull
    public List<Date> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        ArrayList<Date> dateList = new ArrayList<Date>(this.values.size());
        for (ObjectPair<Date, String> p : this.values) {
            dateList.add(p.getFirst());
        }
        return Collections.unmodifiableList(dateList);
    }

    @Nullable
    public String getStringValue() {
        if (!this.values.isEmpty()) {
            return this.values.get(0).getSecond();
        }
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            return StaticUtils.encodeGeneralizedTime(this.defaultValues.get(0));
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getValueStringRepresentations(boolean useDefault) {
        if (!this.values.isEmpty()) {
            ArrayList<String> valueStrings = new ArrayList<String>(this.values.size());
            for (ObjectPair<Date, String> p : this.values) {
                valueStrings.add(p.getSecond());
            }
            return Collections.unmodifiableList(valueStrings);
        }
        if (useDefault && this.defaultValues != null && !this.defaultValues.isEmpty()) {
            ArrayList<String> valueStrings = new ArrayList<String>(this.defaultValues.size());
            for (Date d : this.defaultValues) {
                valueStrings.add(StaticUtils.encodeGeneralizedTime(d));
            }
            return Collections.unmodifiableList(valueStrings);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }

    @Override
    @NotNull
    public String getDataTypeName() {
        return ArgsMessages.INFO_TIMESTAMP_TYPE_NAME.get();
    }

    @Override
    @NotNull
    public String getValueConstraints() {
        return ArgsMessages.INFO_TIMESTAMP_CONSTRAINTS.get();
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    @NotNull
    public TimestampArgument getCleanCopy() {
        return new TimestampArgument(this);
    }

    @Override
    protected void addToCommandLine(@NotNull List<String> argStrings) {
        for (ObjectPair<Date, String> p : this.values) {
            argStrings.add(this.getIdentifierString());
            if (this.isSensitive()) {
                argStrings.add("***REDACTED***");
                continue;
            }
            argStrings.add(p.getSecond());
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TimestampArgument(");
        this.appendBasicToStringInfo(buffer);
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            if (this.defaultValues.size() == 1) {
                buffer.append(", defaultValue='");
                buffer.append(StaticUtils.encodeGeneralizedTime(this.defaultValues.get(0)));
            } else {
                buffer.append(", defaultValues={");
                Iterator<Date> iterator = this.defaultValues.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(StaticUtils.encodeGeneralizedTime(iterator.next()));
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

