/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.SubCommand;
import java.util.List;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ArgumentHelper {
    private ArgumentHelper() {
    }

    @InternalUseOnly
    public static void reset(@NotNull ArgumentParser parser) {
        parser.reset();
    }

    @InternalUseOnly
    public static void incrementOccurrences(@NotNull Argument argument) throws ArgumentException {
        argument.incrementOccurrences();
    }

    @InternalUseOnly
    public static void incrementOccurrencesSuppressException(@NotNull Argument argument) {
        try {
            argument.incrementOccurrences();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    @InternalUseOnly
    public static void setSelectedSubCommand(@NotNull ArgumentParser parser, @NotNull SubCommand subcommand) {
        parser.setSelectedSubCommand(subcommand);
    }

    @InternalUseOnly
    public static void addValue(@NotNull Argument argument, @NotNull String valueString) throws ArgumentException {
        argument.addValue(valueString);
        ArgumentHelper.incrementOccurrencesSuppressException(argument);
    }

    @InternalUseOnly
    public static void addValueSuppressException(@NotNull Argument argument, @NotNull String valueString) {
        try {
            argument.addValue(valueString);
            ArgumentHelper.incrementOccurrencesSuppressException(argument);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    @InternalUseOnly
    public static boolean hasDefaultValue(@NotNull Argument argument) {
        return argument.hasDefaultValue();
    }

    @InternalUseOnly
    public static void reset(@NotNull Argument argument) {
        argument.reset();
    }

    @InternalUseOnly
    public static void addToCommandLine(@NotNull Argument argument, @NotNull List<String> argStrings) {
        argument.addToCommandLine(argStrings);
    }

    @InternalUseOnly
    public static void resetTrailingArguments(@NotNull ArgumentParser parser) {
        parser.resetTrailingArguments();
    }

    @InternalUseOnly
    public static void addTrailingArgument(@NotNull ArgumentParser parser, @NotNull String value) throws ArgumentException {
        parser.addTrailingArgument(value);
    }
}

