/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

enum LDIFMessages {
    ERR_LDIFMODIFY_ADD_CONFLICTS_WITH_MOD_DN("Changes file ''{0}'' contains an add change record for an entry with DN ''{1}'', but there was a previous modify DN change record attempting to rename entry ''{2}'' to ''{3}''.  This suggests that the entry being added is already expected to exist.  As such, the add change record will not be processed."),
    ERR_LDIFMODIFY_ADD_TARGETS_MODIFIED_ENTRY("Changes file ''{0}'' contains an add change record for an entry with DN ''{1}'', but there was a previous modify change record for an entry with the same DN.  This suggests that the entry being added is already expected to exist.  As such, the add change record will not be processed."),
    ERR_LDIFMODIFY_ARGS_CANNOT_REFER_TO_SAME_FILE("The {0} and {1} arguments must not refer to the same file"),
    ERR_LDIFMODIFY_CANNOT_COMPRESS_OUTPUT_FILE("An error occurred while attempting to initialize GZIP compression for target LDIF file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_CANNOT_ENCRYPT_OUTPUT_FILE("An error occurred while attempting to initialize encryption for target LDIF file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_CANNOT_OPEN_OUTPUT_FILE("An error occurred while attempting to open file ''{0}'' for writing:  {1}"),
    ERR_LDIFMODIFY_CANNOT_PARSE_CHANGE_RECORD_DN("Unable to parse the DN contained in change record {0} read from changes file ''{1}'':  {2}  Processing will continue, but this change record will be ignored."),
    ERR_LDIFMODIFY_CANNOT_PARSE_ENTRY_DN("No processing was performed for this entry because its DN could not be parsed:  {0}"),
    ERR_LDIFMODIFY_CANNOT_PARSE_NEW_DN("Unable to determine the new DN that would result from processing modify DN change record {0} read from changes file ''{1}'':  {2}  This indicates that at least one of the current DN, new RDN, and new superior (if present) cannot be parsed.  Processing will continue, but this change record will be ignored."),
    ERR_LDIFMODIFY_CANNOT_READ_PW_FILE("An error occurred while attempting to read an encryption passphrase from file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_CANNOT_READ_RECORD_CANNOT_CONTINUE("An unrecoverable error occurred while attempting to read and LDIF record from changes file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_CANNOT_READ_RECORD_CAN_CONTINUE("An error occurred while attempting to read an LDIF record from changes file ''{0}'':  {1}  This is a recoverable error, and processing will continue, but the unparsable change record will be ignored."),
    ERR_LDIFMODIFY_COMMENT_SOURCE_RECORD_NOT_ENTRY("No processing was performed for the following LDIF record because it is a change record rather than an entry:"),
    ERR_LDIFMODIFY_COMPLETED_WITH_ERRORS("Processing completed, but one or more errors were encountered.  Source entries successfully read:  {0,number,0}.  Entries successfully updated:  {1,number,0}.  Entries not updated:  {2,number,0}."),
    ERR_LDIFMODIFY_COULD_NOT_READ_SOURCE_ENTRIES("No entries could be successfully read from source LDIF file ''{0}''."),
    ERR_LDIFMODIFY_DELETE_OF_PREVIOUS_RENAME("Changes file ''{0}'' contains a delete change record for an entry with DN ''{1}'', but a previous modify DN change record renamed an entry with that same DN to ''{2}''.  This suggests that the entry being deleted is not expected to exist.  As such, the delete change record will be processed."),
    ERR_LDIFMODIFY_ERROR_APPLYING_MODIFY("Failed to apply the following LDIF modify change record to the (result code {0} and message {1}):"),
    ERR_LDIFMODIFY_ERROR_CLOSING_READER("An error occurred while attempting to close the LDIF reader used to read from source LDIF file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_ERROR_CLOSING_WRITER("An error occurred while attempting to close the LDIF writer used to write to target LDIF file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_ERROR_OPENING_CHANGES_FILE("An error occurred while attempting to open changes file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_ERROR_OPENING_INPUT_FILE("An error occurred while attempting to open file ''{0}'' for reading:  {1}"),
    ERR_LDIFMODIFY_ERROR_READING_CHANGES_FILE("An error occurred while attempting to read data from changes file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_MODIFY_OF_DELETED_ENTRY("Changes file ''{0}'' contains a modify change record for an entry with DN ''{1}'', but an earlier delete change record removed that entry.  This suggests that the entry is no longer expected to exist.  As such, the modify change record will not be processed."),
    ERR_LDIFMODIFY_MODIFY_OF_RENAMED_ENTRY("Changes file ''{0}'' contains a modify change record for an entry with DN ''{1}'', but an earlier modify DN change record renamed that entry to ''{2}''.  This suggests that the entry is no longer expected to exist.  As such, the modify change record will not be processed."),
    ERR_LDIFMODIFY_MOD_DN_CONFLICTS_WITH_MOD_DN("Changes file ''{0}'' contains a modify DN change record that renames entry ''{1}'' to ''{2}'', but that conflicts with a previous modify DN change record that renames ''{3}'' to ''{4}''.  As such, the newer modify DN change record will not be processed."),
    ERR_LDIFMODIFY_MOD_DN_NEW_DN_CONFLICTS_WITH_ADD("Changes file ''{0}'' contains a modify DN change record to rename entry ''{1}'' to ''{2}'', but an earlier add change record creates entry with DN ''{3}'', which suggests that the new DN would already exist.  As such, the modify DN change record will not be processed."),
    ERR_LDIFMODIFY_MOD_DN_NEW_DN_CONFLICTS_WITH_MOD("Changes file ''{0}'' contains a modify DN change record to rename entry ''{1}'' to ''{2}'', but an earlier modify change record updated entry with DN ''{3}'', which suggests that the new DN would already exist.  As such, the modify DN change record will not be processed."),
    ERR_LDIFMODIFY_MOD_DN_OF_ADDED_ENTRY("Changes file ''{0}'' contains a modify DN change record for an entry with DN ''{1}'', but that entry is created by an earlier add change record.  This tool does not support processing modify DN operations for entries that have been created or altered by an earlier change record.  As such, the modify DN change record will not be processed."),
    ERR_LDIFMODIFY_MOD_DN_OF_DELETED_ENTRY("Changes file ''{0}'' contains a modify DN change record that renames entry ''{1}'', but a previous change record deleted that entry.  This suggests that the target entry no longer exists.  As such, the modify DN change record will not be processed."),
    ERR_LDIFMODIFY_MULTIPLE_ADDS_FOR_DN("Changes file ''{0}'' contains multiple add change records for an entry with DN ''{1}''.  The subsequent add change record for that entry will not be processed."),
    ERR_LDIFMODIFY_MULTIPLE_DELETES_FOR_DN("Changes file ''{0}'' contains a delete change record for an entry with DN ''{1}'', but an earlier delete change record in the file also targeted the same DN.  The subsequent delete change record will not be processed."),
    ERR_LDIFMODIFY_MULTIPLE_MOD_DN_WITH_DN("Changes file ''{0}'' contains a modify DN change record for an entry with DN ''{1}'', but an earlier modify DN operation already targeted that entry.  This suggests that the target entry no longer exists.  As such, the subsequent modify DN change record will not be processed."),
    ERR_LDIFMODIFY_NOT_ADDING_EXISTING_ENTRY("Skipping an add change record because the entry already exists:"),
    ERR_LDIFMODIFY_NO_CHANGES("Changes file ''{0}'' did not contain any LDIF change records."),
    ERR_LDIFMODIFY_NO_CHANGES_APPLIED_WITH_ERRORS("None of the changes read from file ''{0}'' could be applied to any of the entries read from file ''{1}''."),
    ERR_LDIFMODIFY_NO_CHANGES_WITH_ERROR("No changes were successfully read from file ''{0}'', but one or more errors occurred during processing."),
    ERR_LDIFMODIFY_NO_SOURCE_ENTRIES("No entries were found in source LDIF file ''{0}''."),
    ERR_LDIFMODIFY_NO_SUCH_ENTRY_TO_DELETE("Unable to delete entry ''{0}'' because it was not found in the source LDIF file."),
    ERR_LDIFMODIFY_NO_SUCH_ENTRY_TO_MODIFY("Unable to apply the following modify change record because the target entry was not found in the source LDIF file:"),
    ERR_LDIFMODIFY_NO_SUCH_ENTRY_TO_RENAME("Unable to apply the following modify DN change record because the target entry was not found in the source LDIF file:"),
    ERR_LDIFMODIFY_OUTPUT_SOURCE_RECORD_NOT_ENTRY("Source LDIF file ''{0}'' contained the following LDIF change record, but the source LDIF file should only contain entries.  The change record will be written to the target LDIF file as-is without any further processing."),
    ERR_LDIFMODIFY_READ_ERROR("An error occurred while attempting to read from source LDIF file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_RECOVERABLE_DECODE_ERROR("An error occurred while attempting to decode an entry read from file ''{0}'':  {1}  This is a recoverable error, and processing will continue, but the unparsable entry will be omitted from the output."),
    ERR_LDIFMODIFY_UNRECOVERABLE_DECODE_ERROR("An unrecoverable error occurred while attempting to decode an entry read from file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_UNWILLING_TO_MODIFY_DN_MULTIPLE_TIMES("Changes file ''{0}'' contains a modify DN change record that renames entry ''{1}'' to ''{2}'', but a previous modify DN renamed entry ''{3}'' to ''{1}''.  Renaming the same entry multiple times is not supported."),
    ERR_LDIFMODIFY_WRITE_ERROR("An error occurred while attempting to write to target LDIF file ''{0}'':  {1}"),
    ERR_LDIFMODIFY_WRONG_ENCRYPTION_PW("The provided passphrase was not correct."),
    ERR_LDIFSEARCH_APPEND_WITH_COMPRESSION_OR_ENCRYPTION("If the output LDIF file already exists, and if either the {0} or {1} argument is provided, then the {2} argument must also be provided."),
    ERR_LDIFSEARCH_CANNOT_COMPRESS_OUTPUT_FILE("An error occurred while attempting to prepare compression for output file ''{0}'':  {1}"),
    ERR_LDIFSEARCH_CANNOT_ENCRYPT_OUTPUT_FILE("An error occurred while attempting to prepare encryption for output file ''{0}'':  {1}"),
    ERR_LDIFSEARCH_CANNOT_GET_SCHEMA("An error occurred while attempting to obtain the schema to use during processing:  {0}"),
    ERR_LDIFSEARCH_CANNOT_OPEN_LDIF_FILE("Unable to open LDIF file ''{0}'':  {1}"),
    ERR_LDIFSEARCH_CANNOT_OPEN_OUTPUT_FILE("Unable to open output file ''{0}'' for writing:  {1}"),
    ERR_LDIFSEARCH_CANNOT_READ_PW_FILE("An error occurred while attempting to read the encryption passphrase from file ''{0}'':  {1}"),
    ERR_LDIFSEARCH_CANNOT_WRITE_TO_FILE("An error occurred while attempting to open output file ''{0}'' for writing:  {1}"),
    ERR_LDIFSEARCH_DIFFERENT_URL_ATTRS_IN_SAME_FILE("If the --ldapURLFile argument is used to provide multiple LDAP URLs, and if all of those URLs do not have the same set of requested attributes, then the --separateOutputFilePerSearch argument must also be provided to ensure that results from each search are written to separate output files."),
    ERR_LDIFSEARCH_ENTRY_VIOLATES_SCHEMA("Entry ''{0}'' violates the configured schema:"),
    ERR_LDIFSEARCH_ERROR_OPENING_INPUT_FILE("An error occurred while attempting to open file ''{0}'' for reading:  {1}"),
    ERR_LDIFSEARCH_ERROR_READING_FILTER_FILE("An error occurred while attempting to read from filter file ''{0}'':  {1}"),
    ERR_LDIFSEARCH_ERROR_READING_LDAP_URL_FILE("An error occurred while attempting to read from LDAP URL file ''{0}'':  {1}"),
    ERR_LDIFSEARCH_FILTER_FILE_INVALID_FILTER("Unable to parse value ''{0}'' read from file ''{1}'' as a valid LDAP search filter:  {2}"),
    ERR_LDIFSEARCH_FILTER_FILE_WITH_TRAILING_FILTER("If the --filterFile argument is provided, then the first unnamed trailing argument must not also be a filter."),
    ERR_LDIFSEARCH_FIRST_TRAILING_ARG_NOT_FILTER("When neither the --filterFile nor --ldapURLFile argument is provided, the first trailing argument must be a valid search filter.  ''{0}'' cannot be parsed as a valid filter."),
    ERR_LDIFSEARCH_LDAP_URL_FILE_INVALID_URL("Unable to parse value ''{0}'' read from file ''{1}'' as a valid LDAP URL:  {2}"),
    ERR_LDIFSEARCH_LDAP_URL_FILE_WITH_TRAILING_ARGS("If the --ldapURLFile argument is provided, then there must not be any unnamed trailing arguments."),
    ERR_LDIFSEARCH_NO_FILTER("If neither the --filterFile nor --ldapURLFile argument is provided, then there must be at least one unnamed trailing argument, and the first such argument must be the filter to use for the search."),
    ERR_LDIFSEARCH_NO_FILTERS_FROM_FILE("No search filters were found in file ''{0}''."),
    ERR_LDIFSEARCH_NO_URLS_FROM_FILE("No LDAP URLs were found in file ''{0}''."),
    ERR_LDIFSEARCH_OUTPUT_FORMAT_NOT_SUPPORTED_WITH_URLS("The ''{0}'' output format cannot be used in conjunction with the ''{1}'' argument."),
    ERR_LDIFSEARCH_OUTPUT_FORMAT_REQUIRES_REQUESTED_ATTRS("The ''{0}'' output format requires that a set of requested attributes be provided as unnamed trailing arguments."),
    ERR_LDIFSEARCH_RECOVERABLE_READ_ERROR("Encountered an error while attempting to read an entry from LDIF file ''{0}'':  {1}.  This is a recoverable error, and reading will continue."),
    ERR_LDIFSEARCH_UNRECOVERABLE_READ_ERROR("Encountered an error while attempting to read an entry from LDIF file ''{0}'':  {1}.  This is an unrecoverable error, so processing cannot continue."),
    ERR_LDIFSEARCH_WRITE_ERROR_NO_FILE("An error occurred while attempting to write entry ''{0}'' to LDIF:  {1}"),
    ERR_LDIFSEARCH_WRITE_ERROR_WITH_FILE("An error occurred while attempting to write entry ''{0}'' to LDIF file ''{1}'':  {2}"),
    ERR_LDIFSEARCH_WRONG_ENCRYPTION_PW("ERROR:  The provided passphrase was incorrect."),
    ERR_LDIF_DIFF_APPEND_WITH_COMPRESSION_OR_ENCRYPTION("If the output LDIF file already exists, and if either the {0} or {1} argument is provided, then the {2} argument must also be provided."),
    ERR_LDIF_DIFF_CANNOT_COMPRESS_OUTPUT_FILE("Cannot compress the output file:  {0}"),
    ERR_LDIF_DIFF_CANNOT_DECOMPRESS_LDIF_FILE("Unable to decompress the LDIF file:  {0}"),
    ERR_LDIF_DIFF_CANNOT_DECRYPT_LDIF_FILE("Unable to decrypt the LDIF file:  {0}"),
    ERR_LDIF_DIFF_CANNOT_ENCRYPT_OUTPUT_FILE("Cannot encrypt the output file:  {0}"),
    ERR_LDIF_DIFF_CANNOT_GET_SCHEMA("An error occurred while attempting to obtain the schema to use during processing:  {0}"),
    ERR_LDIF_DIFF_CANNOT_OPEN_LDIF_FILE("Unable to open the LDIF file for reading:  {0}"),
    ERR_LDIF_DIFF_CANNOT_OPEN_OUTPUT("An error occurred while attempting to open output file ''{0}'' for writing:  {1}"),
    ERR_LDIF_DIFF_CANNOT_OPEN_OUTPUT_FILE("Cannot open the output file:  {0}"),
    ERR_LDIF_DIFF_CANNOT_OPEN_PW_FILE("Unable to read the encryption passphrase from file ''{0}'':  {1}"),
    ERR_LDIF_DIFF_CANNOT_READ_SOURCE_LDIF("An error occurred while attempting to read from source LDIF file ''{0}'':  {1}"),
    ERR_LDIF_DIFF_CANNOT_READ_TARGET_LDIF("An error occurred while attempting to read from target LDIF file ''{0}'':  {1}"),
    ERR_LDIF_DIFF_CANNOT_WRITE_ADD_FOR_ENTRY("An error occurred while attempting to write an add change record for entry ''{0}'':  {1}"),
    ERR_LDIF_DIFF_CANNOT_WRITE_DELETE_FOR_ENTRY("An error occurred while attempting to write a delete change record for entry ''{0}'':  {1}"),
    ERR_LDIF_DIFF_CANNOT_WRITE_MODS_TO_ENTRY("An error occurred while attempting to write modifications to entry ''{0}'':  {1}"),
    ERR_LDIF_DIFF_ERROR_READING_OR_DECODING("An error occurred while attempting to read or decode an entry:  {0}"),
    ERR_LDIF_DIFF_ERROR_WRITING_OUTPUT("An error occurred while attempting to write to output file ''{0}'':  {1}"),
    ERR_LDIF_DIFF_PROMPT_WRONG_ENC_PW("The provided passphrase was not correct."),
    ERR_READ_CANNOT_BASE64_DECODE_ATTR("Unable to base64-decode a value for attribute {0} in the record starting at or near line number {1,number,0}:  {2}"),
    ERR_READ_CANNOT_BASE64_DECODE_CONTROL("Unable to base64-decode the control value of the change record starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_CANNOT_BASE64_DECODE_CT("Unable to base64-decode the changetype value of the change record starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_CANNOT_BASE64_DECODE_DN("Unable to base64-decode the DN of the entry starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_CONTROL_LINE_CANNOT_BASE64_DECODE_VALUE("Unable decode a control contained in the LDIF change record starting at or near line number {0,number,0} because an error was encountered while attempting to base64-decode the control value:  {1}"),
    ERR_READ_CONTROL_LINE_CANNOT_RETRIEVE_VALUE_FROM_URL("Unable to decode a control contained in the LDIF change record starting at or near line number {0,number,0} because an error was encountered while attempting to retrieve the value from a URL reference:  {1}"),
    ERR_READ_CONTROL_LINE_INVALID_CRITICALITY("Unable to decode ''{0}'' as a valid control criticality in the LDIF change record starting at or near line number {1,number,0}.  The criticality must be either ''true'' or ''false''."),
    ERR_READ_CONTROL_LINE_NO_CONTROL_VALUE("The control line of the change record starting at or near line number {0,number,0} does not have a value."),
    ERR_READ_CR_CANNOT_BASE64_DECODE_DN("Unable to base64-decode the DN of the change record starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_CR_CT_LINE_DOESNT_START_WITH_CONTROL_OR_CT("The second line of the change record starting at or near line number {0,number,0} does not begin with either ''control'' or ''changetype''."),
    ERR_READ_CR_DN_LINE_DOESNT_START_WITH_DN("The first line of the change record starting at or near line number {0,number,0} did not begin with ''dn:''."),
    ERR_READ_CR_EXTRA_DELETE_DATA("Unexpected additional data after the changetype line for the delete change record starting at or near line number {0,number,0}."),
    ERR_READ_CR_EXTRA_MODDN_DATA("Unexpected additional information at the end of the modify DN change record starting at or near line number {0,number,0}."),
    ERR_READ_CR_INVALID_CT("Invalid changetype value ''{0}'' for the change record starting at or near line number {1,number,0}."),
    ERR_READ_CR_NO_ATTRIBUTES("No attributes found for the change record starting at or near line number {0,number,0}."),
    ERR_READ_CR_NO_MODS("No modifications were contained in the modify change record starting at or near line number {0,number,0}."),
    ERR_READ_CR_NO_NEWRDN("No newRDN found for the modify DN change record starting at or near line number {0,number,0}."),
    ERR_READ_CR_SECOND_LINE_MISSING_COLON("The second line of the change record starting at or near line number {0,number,0} does not include a colon to separate the expected ''control'' or ''changetype'' token from its corresponding value."),
    ERR_READ_CR_TOO_SHORT("The change record starting at or near line {0,number,0} is too short to represent a valid change record."),
    ERR_READ_CT_LINE_NO_CT_VALUE("The changetype line of the change record starting at or near line number {0,number,0} does not have a value."),
    ERR_READ_DN_LINE_DOESNT_START_WITH_DN("The first line of the entry starting at or near line number {0,number,0} did not begin with ''dn:''."),
    ERR_READ_DUPLICATE_VALUE("The record for entry ''{0}'' starting near line {1,number,0} contains a duplicate value for attribute ''{2}''."),
    ERR_READ_ILLEGAL_TRAILING_SPACE_WITHOUT_DN("The LDIF record starting at or near line number {0,number,0} contains line ''{1}'' which ends with an illegal trailing space."),
    ERR_READ_ILLEGAL_TRAILING_SPACE_WITH_DN("The LDIF record for entry ''{0}'' starting at or near line number {1,number,0} contains line ''{2}'' which ends with an illegal trailing space."),
    ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_DELOLDRDN("Unable to base64-decode the deleteOldRDN value in the modify DN change record starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWRDN("Unable to base64-decode the newRDN value in the modify DN change record starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_MODDN_CR_CANNOT_BASE64_DECODE_NEWSUPERIOR("Unable to base64-decode the newSuperior value in the modify DN change record starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_MODDN_CR_INVALID_DELOLDRDN("Invalid deleteOldRDN value ''{0}'' found in the modify DN change record starting at or near line {1,number,0}.  The value must be either 0 or 1."),
    ERR_READ_MODDN_CR_NO_DELOLDRDN_COLON("The fourth line of the modify DN change record starting at or near line number {0,number,0} does not begin with ''deleteOldRDN:''."),
    ERR_READ_MODDN_CR_NO_DELOLDRDN_VALUE("The deleteOldRDN line of the modify DN change record starting at or near line number {0,number,0} does not have a value."),
    ERR_READ_MODDN_CR_NO_NEWRDN_COLON("The third line of the modify DN change record starting at or near line number {0,number,0} does not begin with ''newRDN:''."),
    ERR_READ_MODDN_CR_NO_NEWRDN_VALUE("The newRDN line of the modify DN change record starting at or near line number {0,number,0} does not have a value."),
    ERR_READ_MODDN_CR_NO_NEWSUPERIOR_COLON("The fifth line of the modify DN change record starting at or near line number {0,number,0} does not begin with ''newSuperior:''."),
    ERR_READ_MOD_CR_ATTR_MISMATCH("The modify change record starting at or near line {0,number,0} has attribute name {1} where {2} was expected."),
    ERR_READ_MOD_CR_INVALID_INCR_VALUE_COUNT("The modify change record starting at or near line {0,number,0} includes an increment for attribute {1} with an invalid number of values.  Increment changes must have exactly one value."),
    ERR_READ_MOD_CR_INVALID_MODTYPE("Invalid modification type {0} found in the modify change record starting at or near line number {1,number,0}."),
    ERR_READ_MOD_CR_MODTYPE_CANNOT_BASE64_DECODE_ATTR("Unable to base64-decode the attribute name in a modification type line for the modify change record starting at or near line number {0,number,0}:  {1}"),
    ERR_READ_MOD_CR_MODTYPE_NO_ATTR("The modification type line of the modify change record starting at or near line number {0,number,0} does not include an attribute name."),
    ERR_READ_MOD_CR_NO_ADD_VALUES("No values to add for attribute {0} in the modify change record starting at or near line number {1,number,0}."),
    ERR_READ_MOD_CR_NO_MODTYPE("The modify change record starting at or near line {0,number,0} includes a line that does not contain a colon to separate the modification type from the attribute name."),
    ERR_READ_NOT_CHANGE_RECORD("The LDIF record starting at or near line {0,number,0} is an entry, which cannot be converted to an LDIF change record when defaultAdd=false."),
    ERR_READ_NO_ATTR_COLON("The record starting at or near line number {0,number,0} contains a line that does not begin with an attribute name followed by a colon."),
    ERR_READ_NO_DATA("The provided LDIF entry did not contain any non-blank lines."),
    ERR_READ_NO_LDIF_FILES("An LDIF reader cannot be created with an empty set of LDIF files."),
    ERR_READ_ONLY_BLANKS("The provided LDIF content contained only blank lines."),
    ERR_READ_UNEXPECTED_BLANK("Unexpected blank line found at or near line number {0,number,0}."),
    ERR_READ_UNEXPECTED_FIRST_SPACE("Unexpected space found at the beginning of the first line for an LDIF entry on or near line number {0,number,0}."),
    ERR_READ_UNEXPECTED_FIRST_SPACE_NO_NUMBER("Unexpected space found at the beginning of the first line of the LDIF entry."),
    ERR_READ_URL_EXCEPTION("Unable to access the value for attribute {0} using URL {1} in the record starting at or near line number {2,number,0}:  {3}"),
    ERR_READ_URL_FILE_SIZE_CHANGED("Unable retrieve the contents of URL ''{0}'' because the size of file ''{1}'' changed while it was being read."),
    ERR_READ_URL_FILE_TOO_LARGE("Unable to retrieve the contents of URL ''{0}'' because file ''{1}'' is larger than the maximum supported size of {2,number,0} bytes."),
    ERR_READ_URL_INVALID_SCHEME("Unable to retrieve the contents of URL ''{0}'' because this implementation only supports the file:// URL format."),
    ERR_READ_URL_NO_SUCH_FILE("Unable to retrieve the contents of URL ''{0}'' because the file ''{1}'' does not exist."),
    ERR_READ_VALUE_SYNTAX_VIOLATION("The record for entry ''{0}'' starting near line {1,number,0} contains a value for attribute ''{2}'' which violates the associated attribute syntax:  {3}"),
    INFO_LDIFMODIFY_ADDING_ENTRY_NO_MODS("The following entry was created by an LDIF add change record:"),
    INFO_LDIFMODIFY_ADDING_ENTRY_WITH_MODS("The following entry was created by an LDIF add change record, and it was also subsequently updated by later changes.  The add change record was:"),
    INFO_LDIFMODIFY_APPLIED_DELETE("This entry was removed by an LDIF delete change record:"),
    INFO_LDIFMODIFY_APPLIED_DELETE_OF_ANCESTOR("An ancestor of this entry ({0}) was removed by an LDIF delete change record, so all of its descendants are also considered deleted.  The deleted descendant is:"),
    INFO_LDIFMODIFY_APPLIED_MODIFY("This entry was updated with the following LDIF modify change record:"),
    INFO_LDIFMODIFY_APPLIED_MODIFY_DN("This entry was renamed with the following LDIF modify DN change record:"),
    INFO_LDIFMODIFY_ARG_DESC_CHANGES_LDIF("The path to the file containing the LDIF change records that represent the changes to apply.  This argument must be provided exactly once, and the file must exist.  The entire contents of the file will be read into memory so that all changes will be available when processing entries in the source LDIF file."),
    INFO_LDIFMODIFY_ARG_DESC_CHANGES_PW_FILE_PING_SERVER("The path to the file containing the passphrase needed to decrypt the contents of the changes LDIF file (if it is encrypted).  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the changes LDIF file is encrypted but this argument is not provided, and if the file was not encrypted with a key from the server''s encryption settings database, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFMODIFY_ARG_DESC_CHANGES_PW_FILE_STANDALONE("The path to the file containing the passphrase needed to decrypt the contents of the changes LDIF file (if it is encrypted).  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the changes LDIF file is encrypted but this argument is not provided, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFMODIFY_ARG_DESC_COMPRESS_TARGET("GZIP-compress the data written to the target LDIF file."),
    INFO_LDIFMODIFY_ARG_DESC_DO_NOT_WRAP("Do not wrap long lines as they are written."),
    INFO_LDIFMODIFY_ARG_DESC_ENCRYPT_TARGET("Encrypt the data written to the target LDIF file.  If the --targetEncryptionPassphraseFile argument is not provided to supply the passphrase to use to generate the encryption key, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFMODIFY_ARG_DESC_IGNORE_DUPLICATE_DELETES("Ignore subsequent deletes that target an entry that has already been deleted by an earlier change.  By default, subsequent deletes that target an already-deleted entry will be reported as an error."),
    INFO_LDIFMODIFY_ARG_DESC_IGNORE_NONEXISTENT_DELETES("Ignore deletes that target entries that do not exist in the source LDIF file.  By default, deletes targeting nonexistent entries will be reported as an error."),
    INFO_LDIFMODIFY_ARG_DESC_IGNORE_NONEXISTENT_MODIFIES("Ignore modifies that target entries that do not exist in the source LDIF file.  By default, modifies targeting nonexistent entries will be reported as an error."),
    INFO_LDIFMODIFY_ARG_DESC_LENIENT_MODIFICATIONS("Be lenient when applying modifications.  If this argument is provided, then neither attempts to add an attribute value that already exists nor attempts to remove an attribute value that does not exist will be considered an error."),
    INFO_LDIFMODIFY_ARG_DESC_NO_SCHEMA_CHECK("Do not perform schema checking while applying changes to entries."),
    INFO_LDIFMODIFY_ARG_DESC_SOURCE_LDIF("The path to an LDIF file containing the source entries to be updated.  This argument must be provided exactly once, and the file must exist."),
    INFO_LDIFMODIFY_ARG_DESC_SOURCE_PW_FILE_PING_SERVER("The path to the file containing the passphrase needed to decrypt the contents of the source LDIF file (if it is encrypted).  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the source LDIF file is encrypted but this argument is not provided, and if the file was not encrypted with a key from the server''s encryption settings database, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFMODIFY_ARG_DESC_SOURCE_PW_FILE_STANDALONE("The path to the file containing the passphrase needed to decrypt the contents of the source LDIF file (if it is encrypted).  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the source LDIF file is encrypted but this argument is not provided, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFMODIFY_ARG_DESC_STRICT_MODIFICATIONS("Use strict mode when applying modifications to entries.  If this argument is provided, then the tool will report an error when trying to modify an entry to add an attribute value that already exists in the entry or to remove an attribute value that does not exist in the entry.  By default, the tool will operate in lenient mode, and these ''no-op'' modifications will be permitted."),
    INFO_LDIFMODIFY_ARG_DESC_STRIP_TRAILING_SPACES("Strip off any illegal trailing spaces identified in LDIF entries rather than rejecting those entries."),
    INFO_LDIFMODIFY_ARG_DESC_SUPPRESS_COMMENTS("Do not include comments in the target LDIF file.  By default, each entry will include a comment to indicate what changes (if any) were applied to it."),
    INFO_LDIFMODIFY_ARG_DESC_TARGET_LDIF("The path to the file to which the updated entries will be written.  This argument must be provided exactly once.  If the path exists, then it must reference a file rather than a directory, and that file will be overwritten with the updated entries.  If the path does not exist, then its parent directory must exist."),
    INFO_LDIFMODIFY_ARG_DESC_TARGET_PW_FILE("The path to the file containing the passphrase that will be used to encrypt the data as it is written to the target file.  If this argument is not provided and the output file is to be encrypted, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFMODIFY_ARG_DESC_WRAP_COLUMN("The column at which long lines should be wrapped.  By default, long lines will be wrapped based on the terminal width (or 80 columns if the terminal width cannot be determined)."),
    INFO_LDIFMODIFY_ARG_GROUP_INPUT("Input Arguments"),
    INFO_LDIFMODIFY_ARG_GROUP_OUTPUT("Output Arguments"),
    INFO_LDIFMODIFY_COMPLETED_SUCCESSFULLY("Successfully completed processing.  Source entries read:  {0,number,0}.  Entries updated:  {1,number,0}.  Entries not updated:  {2,number,0}."),
    INFO_LDIFMODIFY_CONFIRM_OUTPUT_ENCRYPTION_PW("Confirm the target encryption passphrase:"),
    INFO_LDIFMODIFY_ENTER_INPUT_ENCRYPTION_PW("Enter the passphrase used to encrypt file ''{0}'':"),
    INFO_LDIFMODIFY_ENTER_OUTPUT_ENCRYPTION_PW("Enter the passphrase that should be used to encrypt the target LDIF file:"),
    INFO_LDIFMODIFY_ENTRY_NOT_UPDATED("This entry was not altered:"),
    INFO_LDIFMODIFY_EXAMPLE("Apply the changes contained in LDIF file ''{0}'' to the entries contained in LDIF file ''{1}'' and write the updated entries to LDIF file ''{2}''."),
    INFO_LDIFMODIFY_TOOL_DESCRIPTION("Apply a set of changes (including add, delete, modify, and modify DN operations) to a set of entries contained in an LDIF file.  The changes will be read from a second file (containing change records rather than entries), and the updated entries will be written to a third LDIF file.  Unlike ldapmodify, the ldifmodify cannot read the changes to apply from standard input."),
    INFO_LDIFMODIFY_TOOL_DESCRIPTION_2("All of the change records will be read into memory before processing begins, so it is important to ensure that the tool is given enough memory to hold those change records.  However, it will only operate on a single source entry at a time, so the size of the source LDIF file does not significantly impact the amount of memory that the tool requires."),
    INFO_LDIFMODIFY_TOOL_DESCRIPTION_3("Note that the tool will attempt to correctly handle multiple changes affecting the same entry.  However, because it only operates on one entry at a time, it cannot always behave in exactly the same way as if it were applying the changes over LDAP to a server populated with the source LDIF file.  For example, it is not possible to reject an attempt to delete an entry that has subordinates, so any delete will be treated as a subtree delete."),
    INFO_LDIFMODIFY_TOOL_DESCRIPTION_4("Further, not all types of modify DN change records are supported.  In particular, modify DN change records are not permitted if they target any entry that has been targeted by a previous change record (for example, renaming an entry that was created by a previous add change record)."),
    INFO_LDIFMODIFY_TOOL_DESCRIPTION_5("Finally, it cannot perform other types of validation, like ensuring that all of the necessary superior entries exist when adding a new entry, or ensuring that a modify DN will not introduce a conflict with an existing entry."),
    INFO_LDIFSEARCH_ARG_DESC_BASE_DN("The base DN to use when searching for matching entries.  This argument must not be provided if the --ldapURLFile argument is given, as the base DN from each URL will be used.  If no LDAP URL file is given and this argument is not provided, then the null DN will be used as the search base."),
    INFO_LDIFSEARCH_ARG_DESC_CHECK_SCHEMA("Indicates whether to validate each entry read from an LDIF file to ensure that it conforms to the defined schema.  If this argument is provided, an error will be reported for every entry that does not conform to the schema."),
    INFO_LDIFSEARCH_ARG_DESC_COMPRESS_OUTPUT("GZIP-compress the data as it is written to each output file."),
    INFO_LDIFSEARCH_ARG_DESC_DO_NOT_WRAP("Do not wrap long lines as they are written."),
    INFO_LDIFSEARCH_ARG_DESC_ENCRYPT_OUTPUT("Encrypt the data as it is written to each output file.  If the ''--outputEncryptionPassphraseFile'' argument is provided, then the passphrase contained in that file will be used to encrypt the output.  Otherwise, the tool will interactively prompt for the passphrase."),
    INFO_LDIFSEARCH_ARG_DESC_FILTER_FILE("The path to a file containing one or more search filters (each on a separate line) to use to identify matching entries.  If neither this argument nor the --ldapURLFile argument is provided, then the filter must be provided as the first trailing argument."),
    INFO_LDIFSEARCH_ARG_DESC_IS_COMPRESSED("Indicates whether the input LDIF files are compressed.  This argument is no longer necessary, as the tool will automatically detect whether each file is compressed."),
    INFO_LDIFSEARCH_ARG_DESC_LDAP_URL_FILE("The path to a file containing one or more LDAP URLs (each on a separate line) with the criteria to use to identify matching entries.  Note that only the base DN, scope, filter, and requested attributes will be used from the LDAP URLs; the server address and port (if any) will be ignored.  If neither this argument nor the --filterFile argument is provided, then the filter must be provided as the first trailing argument."),
    INFO_LDIFSEARCH_ARG_DESC_LDIF_FILE("the path to an LDIF file containing the entries to search.  This must be provided at least once, but if multiple files are given, they will be searched in the order provided.  The file may optionally be compressed or encrypted."),
    INFO_LDIFSEARCH_ARG_DESC_LDIF_PW_FILE_PING_SERVER("The path to the file containing the passphrase used to encrypt the contents of the target LDIF file.  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the target LDIF file is encrypted but this argument is not provided, and if the file was not encrypted with a key from the server''s encryption settings database, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFSEARCH_ARG_DESC_LDIF_PW_FILE_STANDALONE("The path to the file containing the passphrase used to encrypt the contents of the input LDIF files.  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the input LDIF file is encrypted but this argument is not provided, then the tool will interactively prompt for the passphrase."),
    INFO_LDIFSEARCH_ARG_DESC_OUTPUT_FILE("The path to an output file to which matching entries will be written.  If this is not provided, then matching entries will be written to standard output."),
    INFO_LDIFSEARCH_ARG_DESC_OUTPUT_FORMAT("Specifies the format that should be used for the output generated by this tool.  Allowed values are ''LDIF'' (LDAP Data Interchange Format, which is the standard string representation for LDAP data), ''JSON'' (JavaScript Object Notation, which is a popular format used by web services), ''CSV'' (comma-separated values, which is a commonly used format for text processing, with only a single value per attribute), ''multi-valued-csv'' (comma-separated values with a vertical bar between values of multivalued attributes), ''tab-delimited'' (another commonly used general text format, with only a single value per attribute), ''multi-valued-tab-delimited'' (tab-delimited text with a vertical bar between values of multivalued attributes), ''dns-only'' (in which only the DN of each matching entry will be written on a line by itself with no information about the entry''s attributes), and ''values-only'' (in which each value returned will be written on a line by itself with no attribute names, entry DNs, or delimiters between entries).  If the single-valued or multivalued CSV or tab-delimited formats are used then there must be a specific set of attributes requested, and the order in which values are returned will match the order in which they are requested.  Further, the CSV and tab-delimited formats cannot be used in conjunction with the ''--ldapURLFile'' argument.  If no output format is specified, a default of ''LDIF'' will be used."),
    INFO_LDIFSEARCH_ARG_DESC_OUTPUT_PW_FILE("The path to a file containing the passphrase to use to encrypt the contents of the output files.  If this argument is provided, then the file must exist, and it must contain exactly one line comprised entirely of the encryption passphrase."),
    INFO_LDIFSEARCH_ARG_DESC_OVERWRITE_EXISTING("Overwrite any output file that already exists, rather than appending to it.  This argument must be provided if the output file already exists and either of the ''--compressOutput'' or ''--encryptOutput'' arguments is provided."),
    INFO_LDIFSEARCH_ARG_DESC_SCHEMA_PATH_PING_SERVER("The path to an LDIF file (or a directory containing multiple LDIF files) with the schema definitions to use during processing.  This argument may be used multiple times to specify multiple schema paths.  If this argument is ot provided, the server''s schema will be used."),
    INFO_LDIFSEARCH_ARG_DESC_SCHEMA_PATH_STANDALONE("The path to an LDIF file (or a directory containing multiple LDIF files) with the schema definitions to use during processing.  This argument may be used multiple times to specify multiple schema paths.  If this argument is ot provided, the LDAP SDK''s default standard schema will be used."),
    INFO_LDIFSEARCH_ARG_DESC_SCOPE("The scope to use when searching for matching entries.  This argument must not be provided if the --ldapURLFile argument is given, as the scope from each URL will be used.  If no LDAP URL file is given and this argument is not provided, then a default scope of ''sub'' will be used."),
    INFO_LDIFSEARCH_ARG_DESC_SEPARATE_OUTPUT_FILES("Use a separate output LDIF file for each search filter.  This argument is only applicable if either the --filterFile or --ldapURLFile argument is provided to specify multiple sets of search criteria.  If this argument is given, then each output file will use the path specified by the --outputFile argument, followed by a period and a number indicating which search criteria is being used (e.g., ''.1''; for the first set of search criteria, ''.2'' for the second, and so on)."),
    INFO_LDIFSEARCH_ARG_DESC_SIZE_LIMIT("The maximum number of entries to return for each search.  If this is not provided, then no size limit will be enforced."),
    INFO_LDIFSEARCH_ARG_DESC_STRIP_TRAILING_SPACES("Strip off any illegal trailing spaces identified in LDIF entries rather than rejecting those entries."),
    INFO_LDIFSEARCH_ARG_DESC_TIME_LIMIT_SECONDS("The maximum length of time in seconds to spend processing.  If this is not provided, then no time limit will be enforced."),
    INFO_LDIFSEARCH_ARG_DESC_WRAP_COLUMN("The column at which long lines should be wrapped.  By default, long lines will be wrapped based on the terminal width (or 80 columns if the terminal width cannot be determined)."),
    INFO_LDIFSEARCH_ARG_GROUP_CRITERIA("Search Criteria Arguments"),
    INFO_LDIFSEARCH_ARG_GROUP_INPUT("Input Arguments"),
    INFO_LDIFSEARCH_ARG_GROUP_OUTPUT("Output Arguments"),
    INFO_LDIFSEARCH_COMPLETED_SUCCESSFULLY("Search processing completed successfully."),
    INFO_LDIFSEARCH_CONFIRM_OUTPUT_FILE_ENC_PW("# Confirm the output file encryption passphrase:"),
    INFO_LDIFSEARCH_ENTER_ENCRYPTION_PW("# Enter the passphrase used to encrypt file ''{0}'':"),
    INFO_LDIFSEARCH_ENTRIES_MATCHING_URL("# Entries matching the search criteria in LDAP URL {0}:"),
    INFO_LDIFSEARCH_ENTRY_MATCHES_URLS("Entry ''{0}'' matches the criteria in the following LDAP URLs:"),
    INFO_LDIFSEARCH_EXAMPLE_1("Search for entries with a uid value of ''jdoe'' in the data.ldif file.  The matching entries will be written to standard output."),
    INFO_LDIFSEARCH_EXAMPLE_2("Search for all entries with the ''person'' object class below ''dc=example,dc=com'' in the data.ldif file.  Write the matching entries to the ''people.ldif'' file, but only include the ''givenName'', ''sn'', and ''cn'' attributes."),
    INFO_LDIFSEARCH_PROMPT_OUTPUT_FILE_ENC_PW("# Enter the passphrase to use to encrypt the output file:"),
    INFO_LDIFSEARCH_TOOL_DESCRIPTION("Search one or more LDIF files to identify entries matching a given set of criteria."),
    INFO_LDIFSEARCH_TRAILING_ARGS_PLACEHOLDER("[filter] [attributes...]"),
    INFO_LDIF_DIFF_ADD_COMMENT("The following entry was in the target LDIF file but not the source LDIF file:"),
    INFO_LDIF_DIFF_ARG_DESC_BYTE_FOR_BYTE("Use byte-for-byte comparisons when identifying differences between entries.  By default, the tool will use schema-aware comparison, and some types of differences (e.g., differences in capitalization in the values of attributes with case-ignore matching) may be ignored.  With byte-for-byte comparison, any difference at all will be considered significant."),
    INFO_LDIF_DIFF_ARG_DESC_CHANGE_TYPE("The type of change to include in the output.  Allowed values are ''add'' (to indicate that the output should include LDIF add change records for all entries that are present in the target LDIF but not in the source), ''delete'' (to indicate that the output should include LDIF delete change records for all entries that are present in the source LDIF but not in the target), and ''modify'' (to indicate that the output should include LDIF modify change records for all entries that are present in both the source and target LDIF files but that differ between the two versions).  This argument may be provided multiple times to specify multiple change types.  By default, all change types will be included."),
    INFO_LDIF_DIFF_ARG_DESC_COMPRESS_OUTPUT("GZIP-compress the data as it is written to the output file."),
    INFO_LDIF_DIFF_ARG_DESC_ENCRYPT_OUTPUT("Encrypt the data as it is written to the output file.  If the ''--outputEncryptionPassphraseFile'' argument is provided, then the passphrase contained in that file will be used to encrypt the output.  Otherwise, the tool will interactively prompt for the passphrase."),
    INFO_LDIF_DIFF_ARG_DESC_EXCLUDE_ATTRIBUTE("Exclude the specified attribute from the change records that are written.  Changes that affect only the specified attribute will be omitted from the results.  This argument may be provided multiple times to specify multiple exclude attributes."),
    INFO_LDIF_DIFF_ARG_DESC_EXCLUDE_FILTER("Exclude changes to entries that match the given filter (either before or after the change).  This argument may be provided multiple times to specify multiple exclude filters (in which case an entry will be excluded if it matches any of the provided filters)."),
    INFO_LDIF_DIFF_ARG_DESC_EXCLUDE_NO_USER_MOD("Exclude operational attributes declared with the NO-USER-MODIFICATION constraint.  This argument is only applicable if the ''--includeOperationalAttributes'' argument is provided."),
    INFO_LDIF_DIFF_ARG_DESC_INCLUDE_ATTRIBUTE("Only include the specified attribute in the change records that are written.  Changes that do not affect the specified attribute will be omitted from the results.  This argument may be provided multiple times to specify multiple include attributes."),
    INFO_LDIF_DIFF_ARG_DESC_INCLUDE_FILTER("Only include changes to entries that match the given filter (either before or after the change).  This argument may be provided multiple times to specify multiple include filters (in which case an entry will only be included if it matches at least one of the provided filters)."),
    INFO_LDIF_DIFF_ARG_DESC_INCLUDE_OPERATIONAL("Include operational attributes in the output file, in both add and modify change records.  By default, only user attributes will be included."),
    INFO_LDIF_DIFF_ARG_DESC_NON_REVERSIBLE_MODS("Generate modify change records in non-reversible form, in which attribute differences are written with the ''replace'' modification type.  By default, modifications will be generated in reversible form, with delete modifications to remove existing values that are no longer included and add modifications to insert new values.  Using reversible form is generally considered safer, as attempts to apply the modifications are more likely to fail if the entry has been updated.  Modifications generated in non-reversible form are more likely to succeed when applied, but at a greater risk of losing changes that have been processed since the LDIF files were generated."),
    INFO_LDIF_DIFF_ARG_DESC_OUTPUT_LDIF("The path to the LDIF file to which the resulting LDIF add, delete, and modify change records will be written.  If this file already exists, then the new LDIF records will be appended to it unless the ''--overwriteExisting'' argument is provided.  If this file does not exist, then the parent directory must exist.  If this argument is not provided, then the changes will be written to standard output."),
    INFO_LDIF_DIFF_ARG_DESC_OUTPUT_PW_FILE("The path to a file containing the passphrase to use to encrypt the contents of the output file.  If this argument is provided, then the file must exist, and it must contain exactly one line comprised entirely of the encryption passphrase."),
    INFO_LDIF_DIFF_ARG_DESC_OVERWRITE_EXISTING("Overwrite the output file if it already exists, rather than appending to it.  This argument must be provided if the output file already exists and either of the ''--compressOutput'' or ''--encryptOutput'' arguments is provided."),
    INFO_LDIF_DIFF_ARG_DESC_SCHEMA_PATH_PING_SERVER("The path to an LDIF file (or a directory containing multiple LDIF files) with the schema definitions to use during processing.  This argument may be used multiple times to specify multiple schema paths.  If this argument is not provided, the server''s schema will be used."),
    INFO_LDIF_DIFF_ARG_DESC_SCHEMA_PATH_STANDALONE("The path to an LDIF file (or a directory containing multiple LDIF files) with the schema definitions to use during processing.  This argument may be used multiple times to specify multiple schema paths.  If this argument is ot provided, the LDAP SDK''s default standard schema will be used."),
    INFO_LDIF_DIFF_ARG_DESC_SINGLE_VALUE_CHANGES("Generate a separate modify change record for each attribute value that is to be removed from or added to the target entry.  By default, all modifications to an entry will be provided in a single modify change record.  If a separate modify change record is generated for each attribute value, it may be easier to apply changes if the data set has changed since the LDIF files were generated (by instructing the tool that is applying changes to ignore failures)."),
    INFO_LDIF_DIFF_ARG_DESC_SOURCE_LDIF("The path to the LDIF file containing the entries to use as the source data set.  This argument must be specified, and the source LDIF file must exist.  The LDIF file may optionally be gzip-compressed and/or passphrase-encrypted."),
    INFO_LDIF_DIFF_ARG_DESC_SOURCE_PW_FILE_PING_SERVER("The path to the file containing the passphrase used to encrypt the contents of the source LDIF file.  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the source LDIF file is encrypted but this argument is not provided, and if the file was not encrypted with a key from the server''s encryption settings database, then the tool will interactively prompt for the passphrase."),
    INFO_LDIF_DIFF_ARG_DESC_SOURCE_PW_FILE_STANDALONE("The path to the file containing the passphrase used to encrypt the contents of the source LDIF file.  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the source LDIF file is encrypted but this argument is not provided, then the tool will interactively prompt for the passphrase."),
    INFO_LDIF_DIFF_ARG_DESC_STRIP_TRAILING_SPACES("Strip off any illegal trailing spaces identified in LDIF entries rather than rejecting those entries."),
    INFO_LDIF_DIFF_ARG_DESC_TARGET_LDIF("The path to the LDIF file containing the entries to use as the target data set.  This argument must be specified, and the target LDIF file must exist.  The LDIF file may optionally be gzip-compressed and/or passphrase-encrypted."),
    INFO_LDIF_DIFF_ARG_DESC_TARGET_PW_FILE_PING_SERVER("The path to the file containing the passphrase used to encrypt the contents of the target LDIF file.  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the target LDIF file is encrypted but this argument is not provided, and if the file was not encrypted with a key from the server''s encryption settings database, then the tool will interactively prompt for the passphrase."),
    INFO_LDIF_DIFF_ARG_DESC_TARGET_PW_FILE_STANDALONE("The path to the file containing the passphrase used to encrypt the contents of the target LDIF file.  If this argument is provided, the file must exist and must contain exactly one line that contains only the encryption passphrase.  If the target LDIF file is encrypted but this argument is not provided, then the tool will interactively prompt for the passphrase."),
    INFO_LDIF_DIFF_ARG_GROUP_CONTENT("Content Arguments"),
    INFO_LDIF_DIFF_ARG_GROUP_OUTPUT("Output LDIF Arguments"),
    INFO_LDIF_DIFF_ARG_GROUP_SOURCE("Source LDIF Arguments"),
    INFO_LDIF_DIFF_ARG_GROUP_TARGET("Target LDIF Arguments"),
    INFO_LDIF_DIFF_ARG_PLACEHOLDER_ATTRIBUTE("'{'attributeName'}'"),
    INFO_LDIF_DIFF_ARG_PLACEHOLDER_CHANGE_TYPE("'{'add|delete|modify'}'"),
    INFO_LDIF_DIFF_COMPLETED("# LDIF diff processing completed successfully."),
    INFO_LDIF_DIFF_COMPLETED_ADD_COUNT("# Add count:  {0,number,0}"),
    INFO_LDIF_DIFF_COMPLETED_DELETE_COUNT("# Delete count:  {0,number,0}"),
    INFO_LDIF_DIFF_COMPLETED_MODIFY_COUNT("# Modify count:  {0,number,0}"),
    INFO_LDIF_DIFF_CONFIRM_OUTPUT_FILE_ENC_PW("Confirm the encryption passphrase:"),
    INFO_LDIF_DIFF_DELETE_COMMENT("The following entry was in the source LDIF file but not the target LDIF file:"),
    INFO_LDIF_DIFF_EXAMPLE_1("Identify the changes needed to transform the set of entries contained in the ''actual.ldif'' file into the set of entries contained in the ''desired.ldif'' file.  Operational attributes will be ignored, and modifications will be presented in reversible form."),
    INFO_LDIF_DIFF_EXAMPLE_2("Identify the changes needed to transform the set of entries contained in the ''actual.ldif'' file into the set of entries contained in the ''desired.ldif'' file.  Operational attributes not declared with the NO-USER-MODIFICATION will be included, and modifications will be presented in non-reversible form."),
    INFO_LDIF_DIFF_MODIFY_COMMENT("The following entry was different between the source and target LDIF files:"),
    INFO_LDIF_DIFF_PROMPT_FOR_ENC_PW("Enter the passphrase used to encrypt ''{0}'':"),
    INFO_LDIF_DIFF_PROMPT_OUTPUT_FILE_ENC_PW("Enter the passphrase to use to encrypt the output LDIF file:"),
    INFO_LDIF_DIFF_READ_FROM_SOURCE_LDIF("# Entries read from source LDIF file ''{0}'':  {1,number,0}"),
    INFO_LDIF_DIFF_READ_FROM_TARGET_LDIF("# Entries read from target LDIF file ''{0}'':  {1,number,0}"),
    INFO_LDIF_DIFF_TOOL_DESCRIPTION_1("Compare the contents of two files containing LDIF entries.  The output will be an LDIF file containing the add, delete, and modify change records needed to convert the data in the source LDIF file into the data in the target LDIF file."),
    INFO_LDIF_DIFF_TOOL_DESCRIPTION_2("This tool works best with small LDIF files because it reads the entire contents of the source and target LDIF files into memory so they can be quickly compared.  If you encounter an out of memory error while running the tool, you may need to increase the amount of memory available to the JVM used to invoke it."),
    INFO_LDIF_DIFF_TOOL_DESCRIPTION_3("The amount of memory available to the JVM may be customized by invoking the JVM with the ''-Xms'' and ''-Xmx'' arguments (which specify the initial and maximum amounts of memory that it may use, respectively).  These arguments should be immediately followed (without any intervening space) by an integer and a unit to specify the amount of memory that may be used.  The unit may be either ''m'' to indicate that the size is in megabytes, or ''g'' to indicate that it is in gigabytes.  For example, ''-Xms512m'' indicates that the JVM should be given an initial heap size of 512 megabytes, while ''-Xmx2g'' indicates that it should be given a maximum heap size of two gigabytes."),
    INFO_LDIF_DIFF_TOOL_DESCRIPTION_4_PING_SERVER("When invoking the {0} tool included in the installation of a Ping Identity server product, you may edit the config/java.properties file to specify the arguments to use when invoking the JVM.  After modifying the file, run the dsjavaproperties tool to ensure that those changes will be used for subsequent tool invocations."),
    INFO_LDIF_DIFF_TOOL_DESCRIPTION_4_STANDALONE("When invoking the {0} tool with the shell script or batch file included as part of the LDAP SDK, you may use the ''JAVA_ARGS'' environment variable to specify the arguments to use when invoking the JVM."),
    INFO_LDIF_WRITER_CHAR_CARRIAGE_RETURN("'{'CARRIAGE RETURN'}'"),
    INFO_LDIF_WRITER_CHAR_CLOSING_CURLY_BRACE("'{'CLOSING CURLY BRACE'}'"),
    INFO_LDIF_WRITER_CHAR_HEX("'{'0x{0}'}'"),
    INFO_LDIF_WRITER_CHAR_LEADING_COLON("'{'LEADING COLON'}'"),
    INFO_LDIF_WRITER_CHAR_LEADING_LESS_THAN("'{'LEADING LESS THAN'}'"),
    INFO_LDIF_WRITER_CHAR_LEADING_SPACE("'{'LEADING SPACE'}'"),
    INFO_LDIF_WRITER_CHAR_LINE_FEED("'{'LINE FEED'}'"),
    INFO_LDIF_WRITER_CHAR_OPENING_CURLY_BRACE("'{'OPENING CURLY BRACE'}'"),
    INFO_LDIF_WRITER_CHAR_TAB("'{'TAB'}'"),
    INFO_LDIF_WRITER_CHAR_TRAILING_SPACE("'{'TRAILING SPACE'}'"),
    WARN_LDIFMODIFY_DELETE_OF_PREVIOUSLY_MODIFIED("Changes file ''{0}'' contains a delete change record for an entry with DN ''{1}'', but at least one earlier modify change record targeted the same entry.  The earlier modify change records will be processed, since the entry will just be removed anyway."),
    WARN_LDIFMODIFY_DELETE_OF_PREVIOUSLY_RENAMED("Changes file ''{0}'' contains a delete change record for an entry with DN ''{1}'', but a previous modify DN change record renamed an entry from ''{2}'' to ''{3}''.  This modify DN (and any subsequent changes to the renamed entry) will not be processed, but instead the delete will be applied to the entry''s original DN."),
    WARN_LDIFMODIFY_DELETE_OF_PREVIOUS_ADD("Changes file ''{0}'' contains a delete change record for an entry with DN ''{1}'', but that entry would have been created by an add change record appearing earlier in the changes file.  The add change record (and any subsequent modifications to the added entry) will not be processed so that the entry is not created in the first place."),
    WARN_LDIFSEARCH_COMPLETED_WITH_ERRORS("Search processing completed, but errors were encountered during processing.");

    private static final boolean IS_WITHIN_UNIT_TESTS;
    private static final Object[] NO_ARGS;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<LDIFMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<LDIFMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private LDIFMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(NO_ARGS);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(args);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    public String toString() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                s = this.defaultText;
            } else {
                try {
                    s = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s);
            }
        }
        return s;
    }

    static {
        IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        NO_ARGS = new Object[0];
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-ldif");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap(100);
        MESSAGES = new ConcurrentHashMap(100);
    }
}

