/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldif.DuplicateValueBehavior;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
class LDIFAttribute
implements Serializable {
    private static final long serialVersionUID = -3771917482408643188L;
    @Nullable
    private LinkedHashSet<ASN1OctetString> normalizedValues;
    @NotNull
    private final ArrayList<ASN1OctetString> values;
    @NotNull
    private final MatchingRule matchingRule;
    @NotNull
    private final String name;

    LDIFAttribute(@NotNull String name, @NotNull MatchingRule matchingRule, @NotNull ASN1OctetString value) {
        this.name = name;
        this.matchingRule = matchingRule;
        this.values = new ArrayList(5);
        this.values.add(value);
        this.normalizedValues = null;
    }

    boolean addValue(@NotNull ASN1OctetString value, @NotNull DuplicateValueBehavior duplicateValueBehavior) throws LDAPException {
        if (this.normalizedValues == null) {
            this.normalizedValues = new LinkedHashSet(StaticUtils.computeMapCapacity(this.values.size() + 1));
            for (ASN1OctetString s : this.values) {
                this.normalizedValues.add(this.matchingRule.normalize(s));
            }
        }
        if (this.normalizedValues.add(this.matchingRule.normalize(value))) {
            this.values.add(value);
            return true;
        }
        if (duplicateValueBehavior == DuplicateValueBehavior.RETAIN) {
            this.values.add(value);
            return true;
        }
        return false;
    }

    @NotNull
    Attribute toAttribute() {
        ASN1OctetString[] valueArray = new ASN1OctetString[this.values.size()];
        this.values.toArray(valueArray);
        return new Attribute(this.name, this.matchingRule, valueArray);
    }
}

