/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.OutputStream;
import java.util.ArrayList;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFLDAPResultWriter
extends LDAPResultWriter {
    @NotNull
    private final ArrayList<String> formattedLines;
    private final int maxWidth;
    @NotNull
    private final StringBuilder formattedLineBuffer;

    public LDIFLDAPResultWriter(@NotNull OutputStream outputStream, int maxWidth) {
        super(outputStream);
        this.maxWidth = maxWidth;
        this.formattedLines = new ArrayList(20);
        this.formattedLineBuffer = new StringBuilder(100);
    }

    @Override
    public void writeComment(@NotNull String comment) {
        for (String line : StaticUtils.wrapLine(comment, this.maxWidth - 2)) {
            this.print("# ");
            this.println(line);
        }
    }

    @Override
    public void writeHeader() {
    }

    @Override
    public void writeSearchResultEntry(@NotNull SearchResultEntry entry) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatSearchResultEntry(this.formattedLines, entry, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.println(this.formattedLineBuffer.toString());
    }

    @Override
    public void writeSearchResultReference(@NotNull SearchResultReference ref) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatSearchResultReference(this.formattedLines, ref, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.println(this.formattedLineBuffer.toString());
    }

    @Override
    public void writeResult(@NotNull LDAPResult result) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatResult(this.formattedLines, result, true, false, 0, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.println(this.formattedLineBuffer.toString());
    }

    @Override
    public void writeUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatUnsolicitedNotification(this.formattedLines, notification, true, 0, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.println(this.formattedLineBuffer.toString());
    }
}

