/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.unboundidds.tasks.ExportTask;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ExportTaskProperties {
    private boolean appendToLDIF;
    private boolean compress;
    private boolean encrypt;
    private boolean sign;
    @Nullable
    private Boolean alertOnError;
    @Nullable
    private Boolean alertOnStart;
    @Nullable
    private Boolean alertOnSuccess;
    @Nullable
    private Date scheduledStartTime;
    @Nullable
    private FailedDependencyAction failedDependencyAction;
    private int wrapColumn;
    @Nullable
    private Integer maxMegabytesPerSecond;
    @NotNull
    private final List<String> dependencyIDs;
    @NotNull
    private final List<String> excludeAttributes;
    @NotNull
    private final List<String> excludeBranches;
    @NotNull
    private final List<String> excludeFilters;
    @NotNull
    private final List<String> includeAttributes;
    @NotNull
    private final List<String> includeBranches;
    @NotNull
    private final List<String> includeFilters;
    @NotNull
    private final List<String> notifyOnCompletion;
    @NotNull
    private final List<String> notifyOnError;
    @NotNull
    private final List<String> notifyOnStart;
    @NotNull
    private final List<String> notifyOnSuccess;
    @NotNull
    private final List<String> postExportTaskProcessors;
    @NotNull
    private String backendID;
    @Nullable
    private String encryptionPassphraseFile;
    @Nullable
    private String encryptionSettingsDefinitionID;
    @NotNull
    private String ldifFile;
    @Nullable
    private String taskID;

    public ExportTaskProperties(@NotNull String backendID, @NotNull String ldifFile) {
        this.backendID = backendID;
        this.ldifFile = ldifFile;
        this.appendToLDIF = false;
        this.compress = false;
        this.encrypt = false;
        this.sign = false;
        this.alertOnError = null;
        this.alertOnStart = null;
        this.alertOnSuccess = null;
        this.scheduledStartTime = null;
        this.failedDependencyAction = null;
        this.wrapColumn = -1;
        this.maxMegabytesPerSecond = null;
        this.dependencyIDs = new ArrayList<String>(5);
        this.excludeAttributes = new ArrayList<String>(5);
        this.excludeBranches = new ArrayList<String>(5);
        this.excludeFilters = new ArrayList<String>(5);
        this.includeAttributes = new ArrayList<String>(5);
        this.includeBranches = new ArrayList<String>(5);
        this.includeFilters = new ArrayList<String>(5);
        this.notifyOnCompletion = new ArrayList<String>(5);
        this.notifyOnError = new ArrayList<String>(5);
        this.notifyOnStart = new ArrayList<String>(5);
        this.notifyOnSuccess = new ArrayList<String>(5);
        this.postExportTaskProcessors = new ArrayList<String>(5);
        this.encryptionPassphraseFile = null;
        this.encryptionSettingsDefinitionID = null;
        this.taskID = null;
    }

    public ExportTaskProperties(@NotNull ExportTaskProperties properties) {
        this.appendToLDIF = properties.appendToLDIF;
        this.compress = properties.compress;
        this.encrypt = properties.encrypt;
        this.sign = properties.sign;
        this.alertOnError = properties.alertOnError;
        this.alertOnStart = properties.alertOnStart;
        this.alertOnSuccess = properties.alertOnSuccess;
        this.scheduledStartTime = properties.scheduledStartTime;
        this.failedDependencyAction = properties.failedDependencyAction;
        this.wrapColumn = properties.wrapColumn;
        this.maxMegabytesPerSecond = properties.maxMegabytesPerSecond;
        this.dependencyIDs = new ArrayList<String>(properties.dependencyIDs);
        this.excludeAttributes = new ArrayList<String>(properties.excludeAttributes);
        this.excludeBranches = new ArrayList<String>(properties.excludeBranches);
        this.excludeFilters = new ArrayList<String>(properties.excludeFilters);
        this.includeAttributes = new ArrayList<String>(properties.includeAttributes);
        this.includeBranches = new ArrayList<String>(properties.includeBranches);
        this.includeFilters = new ArrayList<String>(properties.includeFilters);
        this.notifyOnCompletion = new ArrayList<String>(properties.notifyOnCompletion);
        this.notifyOnError = new ArrayList<String>(properties.notifyOnError);
        this.notifyOnStart = new ArrayList<String>(properties.notifyOnStart);
        this.notifyOnSuccess = new ArrayList<String>(properties.notifyOnSuccess);
        this.postExportTaskProcessors = new ArrayList<String>(properties.postExportTaskProcessors);
        this.backendID = properties.backendID;
        this.encryptionPassphraseFile = properties.encryptionPassphraseFile;
        this.encryptionSettingsDefinitionID = properties.encryptionSettingsDefinitionID;
        this.ldifFile = properties.ldifFile;
        this.taskID = properties.taskID;
    }

    public ExportTaskProperties(@NotNull ExportTask task) {
        this.appendToLDIF = task.appendToLDIF();
        this.compress = task.compress();
        this.encrypt = task.encrypt();
        this.sign = task.sign();
        this.alertOnError = task.getAlertOnError();
        this.alertOnStart = task.getAlertOnStart();
        this.alertOnSuccess = task.getAlertOnSuccess();
        this.scheduledStartTime = task.getScheduledStartTime();
        this.failedDependencyAction = task.getFailedDependencyAction();
        this.wrapColumn = task.getWrapColumn();
        this.maxMegabytesPerSecond = task.getMaxMegabytesPerSecond();
        this.dependencyIDs = new ArrayList<String>(task.getDependencyIDs());
        this.excludeAttributes = new ArrayList<String>(task.getExcludeAttributes());
        this.excludeBranches = new ArrayList<String>(task.getExcludeBranches());
        this.excludeFilters = new ArrayList<String>(task.getExcludeFilters());
        this.includeAttributes = new ArrayList<String>(task.getIncludeAttributes());
        this.includeBranches = new ArrayList<String>(task.getIncludeBranches());
        this.includeFilters = new ArrayList<String>(task.getIncludeFilters());
        this.notifyOnCompletion = new ArrayList<String>(task.getNotifyOnCompletionAddresses());
        this.notifyOnError = new ArrayList<String>(task.getNotifyOnErrorAddresses());
        this.notifyOnStart = new ArrayList<String>(task.getNotifyOnStartAddresses());
        this.notifyOnSuccess = new ArrayList<String>(task.getNotifyOnSuccessAddresses());
        this.postExportTaskProcessors = new ArrayList<String>(task.getPostExportTaskProcessors());
        this.backendID = task.getBackendID();
        this.encryptionPassphraseFile = task.getEncryptionPassphraseFile();
        this.encryptionSettingsDefinitionID = task.getEncryptionSettingsDefinitionID();
        this.ldifFile = task.getLDIFFile();
        this.taskID = task.getTaskID();
    }

    @NotNull
    public String getBackendID() {
        return this.backendID;
    }

    public void setBackendID(@NotNull String backendID) {
        Validator.ensureNotNullWithMessage(backendID, "ExportTaskProperties.backendID must not be null.");
        this.backendID = backendID;
    }

    @NotNull
    public String getLDIFFile() {
        return this.ldifFile;
    }

    public void setLDIFFile(@NotNull String ldifFile) {
        Validator.ensureNotNullWithMessage(this.backendID, "ExportTaskProperties.ldifFile must not be null.");
        this.ldifFile = ldifFile;
    }

    public boolean appendToLDIF() {
        return this.appendToLDIF;
    }

    public void setAppendToLDIF(boolean appendToLDIF) {
        this.appendToLDIF = appendToLDIF;
    }

    @NotNull
    public List<String> getIncludeBranches() {
        return this.includeBranches;
    }

    public void setIncludeBranches(@Nullable List<String> includeBranches) {
        this.includeBranches.clear();
        if (includeBranches != null) {
            this.includeBranches.addAll(includeBranches);
        }
    }

    @NotNull
    public List<String> getExcludeBranches() {
        return this.excludeBranches;
    }

    public void setExcludeBranches(@Nullable List<String> excludeBranches) {
        this.excludeBranches.clear();
        if (excludeBranches != null) {
            this.excludeBranches.addAll(excludeBranches);
        }
    }

    @NotNull
    public List<String> getIncludeFilters() {
        return this.includeFilters;
    }

    public void setIncludeFilters(@Nullable List<String> includeFilters) {
        this.includeFilters.clear();
        if (includeFilters != null) {
            this.includeFilters.addAll(includeFilters);
        }
    }

    @NotNull
    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public void setExcludeFilters(@Nullable List<String> excludeFilters) {
        this.excludeFilters.clear();
        if (excludeFilters != null) {
            this.excludeFilters.addAll(excludeFilters);
        }
    }

    @NotNull
    public List<String> getIncludeAttributes() {
        return this.includeAttributes;
    }

    public void setIncludeAttributes(@Nullable List<String> includeAttributes) {
        this.includeAttributes.clear();
        if (includeAttributes != null) {
            this.includeAttributes.addAll(includeAttributes);
        }
    }

    @NotNull
    public List<String> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public void setExcludeAttributes(@Nullable List<String> excludeAttributes) {
        this.excludeAttributes.clear();
        if (excludeAttributes != null) {
            this.excludeAttributes.addAll(excludeAttributes);
        }
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn > 0 ? wrapColumn : -1;
    }

    public boolean compress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    @Nullable
    public String getEncryptionPassphraseFile() {
        return this.encryptionPassphraseFile;
    }

    public void setEncryptionPassphraseFile(@Nullable String encryptionPassphraseFile) {
        this.encryptionPassphraseFile = encryptionPassphraseFile;
    }

    @Nullable
    public String getEncryptionSettingsDefinitionID() {
        return this.encryptionSettingsDefinitionID;
    }

    public void setEncryptionSettingsDefinitionID(@Nullable String encryptionSettingsDefinitionID) {
        this.encryptionSettingsDefinitionID = encryptionSettingsDefinitionID;
    }

    public boolean sign() {
        return this.sign;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    @Nullable
    public Integer getMaxMegabytesPerSecond() {
        return this.maxMegabytesPerSecond;
    }

    public void setMaxMegabytesPerSecond(@Nullable Integer maxMegabytesPerSecond) {
        this.maxMegabytesPerSecond = maxMegabytesPerSecond == null || maxMegabytesPerSecond <= 0 ? null : maxMegabytesPerSecond;
    }

    @NotNull
    public List<String> getPostExportTaskProcessors() {
        return this.postExportTaskProcessors;
    }

    public void setPostExportTaskProcessors(@Nullable List<String> postExportTaskProcessors) {
        this.postExportTaskProcessors.clear();
        if (postExportTaskProcessors != null) {
            this.postExportTaskProcessors.addAll(postExportTaskProcessors);
        }
    }

    @Nullable
    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(@Nullable String taskID) {
        this.taskID = taskID;
    }

    @Nullable
    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(@Nullable Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    @NotNull
    public List<String> getDependencyIDs() {
        return new ArrayList<String>(this.dependencyIDs);
    }

    public void setDependencyIDs(@Nullable List<String> dependencyIDs) {
        this.dependencyIDs.clear();
        if (dependencyIDs != null) {
            this.dependencyIDs.addAll(dependencyIDs);
        }
    }

    @Nullable
    public FailedDependencyAction getFailedDependencyAction() {
        return this.failedDependencyAction;
    }

    public void setFailedDependencyAction(@Nullable FailedDependencyAction failedDependencyAction) {
        this.failedDependencyAction = failedDependencyAction;
    }

    @NotNull
    public List<String> getNotifyOnStart() {
        return new ArrayList<String>(this.notifyOnStart);
    }

    public void setNotifyOnStart(@Nullable List<String> notifyOnStart) {
        this.notifyOnStart.clear();
        if (notifyOnStart != null) {
            this.notifyOnStart.addAll(notifyOnStart);
        }
    }

    @NotNull
    public List<String> getNotifyOnCompletion() {
        return new ArrayList<String>(this.notifyOnCompletion);
    }

    public void setNotifyOnCompletion(@Nullable List<String> notifyOnCompletion) {
        this.notifyOnCompletion.clear();
        if (notifyOnCompletion != null) {
            this.notifyOnCompletion.addAll(notifyOnCompletion);
        }
    }

    @NotNull
    public List<String> getNotifyOnSuccess() {
        return new ArrayList<String>(this.notifyOnSuccess);
    }

    public void setNotifyOnSuccess(@Nullable List<String> notifyOnSuccess) {
        this.notifyOnSuccess.clear();
        if (notifyOnSuccess != null) {
            this.notifyOnSuccess.addAll(notifyOnSuccess);
        }
    }

    @NotNull
    public List<String> getNotifyOnError() {
        return new ArrayList<String>(this.notifyOnError);
    }

    public void setNotifyOnError(@Nullable List<String> notifyOnError) {
        this.notifyOnError.clear();
        if (notifyOnError != null) {
            this.notifyOnError.addAll(notifyOnError);
        }
    }

    @Nullable
    public Boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    public void setAlertOnStart(@Nullable Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
    }

    @Nullable
    public Boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    public void setAlertOnSuccess(@Nullable Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
    }

    @Nullable
    public Boolean getAlertOnError() {
        return this.alertOnError;
    }

    public void setAlertOnError(@Nullable Boolean alertOnError) {
        this.alertOnError = alertOnError;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ExportTaskProperties(");
        ExportTaskProperties.appendNameValuePair(buffer, "taskID", this.taskID);
        ExportTaskProperties.appendNameValuePair(buffer, "backendID", this.backendID);
        ExportTaskProperties.appendNameValuePair(buffer, "ldifFile", this.ldifFile);
        ExportTaskProperties.appendNameValuePair(buffer, "appendToLDIF", this.appendToLDIF);
        ExportTaskProperties.appendNameValuePair(buffer, "includeBranches", this.includeBranches);
        ExportTaskProperties.appendNameValuePair(buffer, "excludeBranches", this.excludeBranches);
        ExportTaskProperties.appendNameValuePair(buffer, "includeFilters", this.includeFilters);
        ExportTaskProperties.appendNameValuePair(buffer, "excludeFilters", this.excludeFilters);
        ExportTaskProperties.appendNameValuePair(buffer, "includeAttributes", this.includeAttributes);
        ExportTaskProperties.appendNameValuePair(buffer, "excludeAttributes", this.excludeAttributes);
        ExportTaskProperties.appendNameValuePair(buffer, "wrapColumn", this.wrapColumn);
        ExportTaskProperties.appendNameValuePair(buffer, "compress", this.compress);
        ExportTaskProperties.appendNameValuePair(buffer, "encrypt", this.encrypt);
        ExportTaskProperties.appendNameValuePair(buffer, "encryptionPassphraseFile", this.encryptionPassphraseFile);
        ExportTaskProperties.appendNameValuePair(buffer, "encryptionSettingsDefinitionID", this.encryptionSettingsDefinitionID);
        ExportTaskProperties.appendNameValuePair(buffer, "sign", this.sign);
        ExportTaskProperties.appendNameValuePair(buffer, "maxMegabytesPerSecond", this.maxMegabytesPerSecond);
        ExportTaskProperties.appendNameValuePair(buffer, "postExportTaskProcessors", this.postExportTaskProcessors);
        ExportTaskProperties.appendNameValuePair(buffer, "scheduledStartTime", this.scheduledStartTime);
        ExportTaskProperties.appendNameValuePair(buffer, "dependencyIDs", this.dependencyIDs);
        ExportTaskProperties.appendNameValuePair(buffer, "failedDependencyAction", (Object)this.failedDependencyAction);
        ExportTaskProperties.appendNameValuePair(buffer, "notifyOnStart", this.notifyOnStart);
        ExportTaskProperties.appendNameValuePair(buffer, "notifyOnCompletion", this.notifyOnCompletion);
        ExportTaskProperties.appendNameValuePair(buffer, "notifyOnSuccess", this.notifyOnSuccess);
        ExportTaskProperties.appendNameValuePair(buffer, "notifyOnError", this.notifyOnError);
        ExportTaskProperties.appendNameValuePair(buffer, "alertOnStart", this.alertOnStart);
        ExportTaskProperties.appendNameValuePair(buffer, "alertOnSuccess", this.alertOnSuccess);
        ExportTaskProperties.appendNameValuePair(buffer, "alertOnError", this.alertOnError);
        buffer.append(')');
    }

    private static void appendNameValuePair(@NotNull StringBuilder buffer, @NotNull String name, @Nullable Object value) {
        if (value == null) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append("='");
        buffer.append(value);
        buffer.append('\'');
    }

    private static void appendNameValuePair(@NotNull StringBuilder buffer, @NotNull String name, @Nullable List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(", ");
        }
        buffer.append(name);
        buffer.append("={ ");
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
    }
}

