/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EnterLockdownModeTask
extends Task {
    @NotNull
    static final String ENTER_LOCKDOWN_MODE_TASK_CLASS = "com.unboundid.directory.server.tasks.EnterLockdownModeTask";
    @NotNull
    private static final String ATTR_ENTER_LOCKDOWN_REASON = "ds-task-enter-lockdown-reason";
    @NotNull
    private static final TaskProperty PROPERTY_ENTER_LOCKDOWN_REASON = new TaskProperty("ds-task-enter-lockdown-reason", TaskMessages.INFO_DISPLAY_NAME_ENTER_LOCKDOWN_REASON.get(), TaskMessages.INFO_DESCRIPTION_ENTER_LOCKDOWN_REASON.get(), String.class, false, false, false);
    @NotNull
    private static final String OC_ENTER_LOCKDOWN_MODE_TASK = "ds-task-enter-lockdown-mode";
    private static final long serialVersionUID = -4104020769734351458L;
    @Nullable
    private final String reason;

    public EnterLockdownModeTask() {
        this.reason = null;
    }

    public EnterLockdownModeTask(@Nullable String taskID) {
        this(taskID, (String)null);
    }

    public EnterLockdownModeTask(@Nullable String taskID, @Nullable String reason) {
        this(taskID, reason, null, null, null, null, null);
    }

    public EnterLockdownModeTask(@Nullable String taskID, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, null, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
    }

    public EnterLockdownModeTask(@Nullable String taskID, @Nullable String reason, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, reason, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public EnterLockdownModeTask(@Nullable String taskID, @Nullable String reason, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, ENTER_LOCKDOWN_MODE_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.reason = reason;
    }

    public EnterLockdownModeTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.reason = entry.getAttributeValue(ATTR_ENTER_LOCKDOWN_REASON);
    }

    public EnterLockdownModeTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(ENTER_LOCKDOWN_MODE_TASK_CLASS, properties);
        String r = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (!attrName.equalsIgnoreCase(ATTR_ENTER_LOCKDOWN_REASON)) continue;
            r = EnterLockdownModeTask.parseString(p, values, null);
            break;
        }
        this.reason = r;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_ENTER_LOCKDOWN_MODE.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_ENTER_LOCKDOWN_MODE.get();
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_ENTER_LOCKDOWN_MODE_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        if (this.reason != null) {
            attrs.add(new Attribute(ATTR_ENTER_LOCKDOWN_REASON, this.reason));
        }
        return attrs;
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Collections.singletonList(PROPERTY_ENTER_LOCKDOWN_REASON);
        return Collections.unmodifiableList(propList);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(10));
        if (this.reason != null) {
            props.put(PROPERTY_ENTER_LOCKDOWN_REASON, Collections.singletonList(this.reason));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

