/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GroupCacheMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String GROUP_CACHE_MONITOR_OC = "ds-group-cache-monitor-entry";
    @NotNull
    private static final String ATTR_CURRENT_CACHE_USED_BYTES = "current-cache-used-bytes";
    @NotNull
    private static final String ATTR_CURRENT_CACHE_USED_PERCENT = "current-cache-used-as-percentage-of-max-heap";
    @NotNull
    private static final String ATTR_CURRENT_CACHE_USED_UPDATE_MILLIS = "current-cache-used-update-ms";
    @NotNull
    private static final String ATTR_DYNAMIC_GROUP_ENTRIES = "dynamic-group-entries";
    @NotNull
    private static final String ATTR_STATIC_GROUP_ENTRIES = "static-group-entries";
    @NotNull
    private static final String ATTR_TOTAL_STATIC_GROUP_MEMBERS = "static-group-members";
    @NotNull
    private static final String ATTR_UNIQUE_STATIC_GROUP_MEMBERS = "static-group-unique-members";
    @NotNull
    private static final String ATTR_VIRTUAL_STATIC_GROUP_ENTRIES = "virtual-static-group-entries";
    private static final long serialVersionUID = -5665905374595185773L;
    @Nullable
    private final Double currentCacheUsedUpdateMillis;
    @Nullable
    private final Integer currentCacheUsedPercent;
    @Nullable
    private final Long currentCacheUsedBytes;
    @Nullable
    private final Long dynamicGroupEntries;
    @Nullable
    private final Long staticGroupEntries = this.getLong("static-group-entries");
    @Nullable
    private final Long staticGroupMembers = this.getLong("static-group-members");
    @Nullable
    private final Long staticGroupUniqueMembers = this.getLong("static-group-unique-members");
    @Nullable
    private final Long virtualStaticGroupEntries;

    public GroupCacheMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.dynamicGroupEntries = this.getLong(ATTR_DYNAMIC_GROUP_ENTRIES);
        this.virtualStaticGroupEntries = this.getLong(ATTR_VIRTUAL_STATIC_GROUP_ENTRIES);
        this.currentCacheUsedBytes = this.getLong(ATTR_CURRENT_CACHE_USED_BYTES);
        this.currentCacheUsedPercent = this.getInteger(ATTR_CURRENT_CACHE_USED_PERCENT);
        this.currentCacheUsedUpdateMillis = this.getDouble(ATTR_CURRENT_CACHE_USED_UPDATE_MILLIS);
    }

    @Nullable
    public Long getStaticGroupEntries() {
        return this.staticGroupEntries;
    }

    @Nullable
    public Long getTotalStaticGroupMembers() {
        return this.staticGroupMembers;
    }

    @Nullable
    public Long getUniqueStaticGroupMembers() {
        return this.staticGroupUniqueMembers;
    }

    @Nullable
    public Long getDynamicGroupEntries() {
        return this.dynamicGroupEntries;
    }

    @Nullable
    public Long getVirtualStaticGroupEntries() {
        return this.virtualStaticGroupEntries;
    }

    @Nullable
    public Long getCurrentCacheUsedBytes() {
        return this.currentCacheUsedBytes;
    }

    @Nullable
    public Integer getCurrentCacheUsedAsPercentOfMaxHeap() {
        return this.currentCacheUsedPercent;
    }

    @Nullable
    public Double getCurrentCacheUsedUpdateDurationMillis() {
        return this.currentCacheUsedUpdateMillis;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_GROUP_CACHE_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_GROUP_CACHE_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(8));
        if (this.staticGroupEntries != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_STATIC_GROUP_ENTRIES, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_STATIC_GROUP_ENTRIES.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_STATIC_GROUP_ENTRIES.get(), this.staticGroupEntries);
        }
        if (this.staticGroupMembers != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_STATIC_GROUP_MEMBERS, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_STATIC_GROUP_MEMBERS.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_STATIC_GROUP_MEMBERS.get(), this.staticGroupMembers);
        }
        if (this.staticGroupUniqueMembers != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_UNIQUE_STATIC_GROUP_MEMBERS, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_STATIC_GROUP_UNIQUE_MEMBERS.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_STATIC_GROUP_UNIQUE_MEMBERS.get(), this.staticGroupUniqueMembers);
        }
        if (this.dynamicGroupEntries != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_DYNAMIC_GROUP_ENTRIES, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_DYNAMIC_GROUP_ENTRIES.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_DYNAMIC_GROUP_ENTRIES.get(), this.dynamicGroupEntries);
        }
        if (this.virtualStaticGroupEntries != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_VIRTUAL_STATIC_GROUP_ENTRIES, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_VIRTUAL_STATIC_GROUP_ENTRIES.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_VIRTUAL_STATIC_GROUP_ENTRIES.get(), this.virtualStaticGroupEntries);
        }
        if (this.currentCacheUsedBytes != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_CACHE_USED_BYTES, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_CACHE_SIZE_BYTES.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_CACHE_SIZE_BYTES.get(), this.currentCacheUsedBytes);
        }
        if (this.currentCacheUsedPercent != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_CACHE_USED_PERCENT, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_CACHE_SIZE_PERCENT.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_CACHE_SIZE_PERCENT.get(), this.currentCacheUsedPercent);
        }
        if (this.currentCacheUsedUpdateMillis != null) {
            GroupCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_CACHE_USED_UPDATE_MILLIS, MonitorMessages.INFO_GROUP_CACHE_DISPNAME_CACHE_SIZE_UPDATE_MILLIS.get(), MonitorMessages.INFO_GROUP_CACHE_DESC_CACHE_SIZE_UPDATE_MILLIS.get(), this.currentCacheUsedUpdateMillis);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

