/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SearchResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedForwardAccessLogMessageHelper;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedResultAccessLogMessageHelper;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedSearchResultAccessLogMessage
extends TextFormattedSearchRequestAccessLogMessage
implements SearchResultAccessLogMessage {
    private static final long serialVersionUID = -5895892142452308149L;
    @Nullable
    private final Boolean isUnindexed;
    @Nullable
    private final Long entriesReturned = this.getLongNoThrow(TextFormattedAccessLogFields.SEARCH_ENTRIES_RETURNED);
    @NotNull
    private final TextFormattedForwardAccessLogMessageHelper forwardHelper;
    @NotNull
    private final TextFormattedResultAccessLogMessageHelper resultHelper;

    public TextFormattedSearchResultAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedSearchResultAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.isUnindexed = this.getBooleanNoThrow(TextFormattedAccessLogFields.SEARCH_UNINDEXED);
        this.resultHelper = new TextFormattedResultAccessLogMessageHelper(this);
        this.forwardHelper = new TextFormattedForwardAccessLogMessageHelper(this);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.RESULT;
    }

    @Override
    @Nullable
    public ResultCode getResultCode() {
        return this.resultHelper.getResultCode();
    }

    @Override
    @Nullable
    public String getDiagnosticMessage() {
        return this.resultHelper.getDiagnosticMessage();
    }

    @Override
    @Nullable
    public String getAdditionalInformation() {
        return this.resultHelper.getAdditionalInformation();
    }

    @Override
    @Nullable
    public String getMatchedDN() {
        return this.resultHelper.getMatchedDN();
    }

    @Override
    @NotNull
    public List<String> getReferralURLs() {
        return this.resultHelper.getReferralURLs();
    }

    @Override
    @Nullable
    public Double getProcessingTimeMillis() {
        return this.resultHelper.getProcessingTimeMillis();
    }

    @Override
    @Nullable
    public Double getWorkQueueWaitTimeMillis() {
        return this.resultHelper.getWorkQueueWaitTimeMillis();
    }

    @Override
    @NotNull
    public Set<String> getResponseControlOIDs() {
        return this.resultHelper.getResponseControlOIDs();
    }

    @Override
    @Nullable
    public Long getIntermediateResponsesReturned() {
        return this.resultHelper.getIntermediateResponsesReturned();
    }

    @Override
    @NotNull
    public List<String> getServersAccessed() {
        return this.resultHelper.getServersAccessed();
    }

    @Override
    @Nullable
    public Boolean getUncachedDataAccessed() {
        return this.resultHelper.getUncachedDataAccessed();
    }

    @Override
    @NotNull
    public Set<String> getUsedPrivileges() {
        return this.resultHelper.getUsedPrivileges();
    }

    @Override
    @NotNull
    public Set<String> getPreAuthorizationUsedPrivileges() {
        return this.resultHelper.getPreAuthorizationUsedPrivileges();
    }

    @Override
    @NotNull
    public Set<String> getMissingPrivileges() {
        return this.resultHelper.getMissingPrivileges();
    }

    @Override
    @Nullable
    public String getAlternateAuthorizationDN() {
        return this.resultHelper.getAlternateAuthorizationDN();
    }

    @Override
    @NotNull
    public Set<String> getIndexesWithKeysAccessedNearEntryLimit() {
        return this.resultHelper.getIndexesWithKeysAccessedNearEntryLimit();
    }

    @Override
    @NotNull
    public Set<String> getIndexesWithKeysAccessedExceedingEntryLimit() {
        return this.resultHelper.getIndexesWithKeysAccessedExceedingEntryLimit();
    }

    @Nullable
    public String getIntermediateClientResponseControl() {
        return this.resultHelper.getIntermediateClientResponseControl();
    }

    @Override
    @Nullable
    public String getTargetHost() {
        return this.forwardHelper.getTargetHost();
    }

    @Override
    @Nullable
    public Integer getTargetPort() {
        return this.forwardHelper.getTargetPort();
    }

    @Override
    @Nullable
    public String getTargetProtocol() {
        return this.forwardHelper.getTargetProtocol();
    }

    @Override
    @Nullable
    public Long getEntriesReturned() {
        return this.entriesReturned;
    }

    @Override
    @Nullable
    public Boolean getUnindexed() {
        return this.isUnindexed;
    }
}

