/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.SearchEntryAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSearchRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONSearchEntryAccessLogMessage
extends JSONSearchRequestAccessLogMessage
implements SearchEntryAccessLogMessage {
    private static final long serialVersionUID = 198085732170528719L;
    @NotNull
    private final Set<String> attributesReturned;
    @NotNull
    private final Set<String> responseControlOIDs;
    @Nullable
    private final String dn = this.getString(JSONFormattedAccessLogFields.SEARCH_RESULT_ENTRY_DN);

    public JSONSearchEntryAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.attributesReturned = this.getStringSet(JSONFormattedAccessLogFields.SEARCH_RESULT_ENTRY_ATTRIBUTES);
        this.responseControlOIDs = this.getStringSet(JSONFormattedAccessLogFields.RESPONSE_CONTROL_OIDS);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY;
    }

    @Override
    @Nullable
    public String getDN() {
        return this.dn;
    }

    @Override
    @NotNull
    public Set<String> getAttributesReturned() {
        return this.attributesReturned;
    }

    @Override
    @NotNull
    public Set<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }
}

