/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONIntermediateClientResponseControl
implements Serializable {
    private static final long serialVersionUID = -3708412493324053872L;
    @Nullable
    private final Boolean upstreamServerSecure;
    @Nullable
    private final JSONIntermediateClientResponseControl upstreamResponse;
    @NotNull
    private final JSONObject controlObject;
    @Nullable
    private final String serverName;
    @Nullable
    private final String upstreamServerAddress;
    @Nullable
    private final String responseID;
    @Nullable
    private final String sessionID;

    public JSONIntermediateClientResponseControl(@NotNull JSONObject controlObject) {
        this.controlObject = controlObject;
        this.upstreamServerAddress = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_SERVER_ADDRESS.getFieldName());
        this.upstreamServerSecure = controlObject.getFieldAsBoolean(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_SERVER_SECURE.getFieldName());
        this.serverName = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESPONSE_CONTROL_SERVER_NAME.getFieldName());
        this.sessionID = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESPONSE_CONTROL_SESSION_ID.getFieldName());
        this.responseID = controlObject.getFieldAsString(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESPONSE_CONTROL_RESPONSE_ID.getFieldName());
        JSONObject upstreamObject = controlObject.getFieldAsObject(JSONFormattedAccessLogFields.INTERMEDIATE_CLIENT_RESPONSE_CONTROL_UPSTREAM_RESPONSE.getFieldName());
        this.upstreamResponse = upstreamObject == null ? null : new JSONIntermediateClientResponseControl(upstreamObject);
    }

    @NotNull
    public JSONObject getControlObject() {
        return this.controlObject;
    }

    @Nullable
    public String getUpstreamServerAddress() {
        return this.upstreamServerAddress;
    }

    @Nullable
    public Boolean getUpstreamServerSecure() {
        return this.upstreamServerSecure;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    @Nullable
    public String getSessionID() {
        return this.sessionID;
    }

    @Nullable
    public String getResponseID() {
        return this.responseID;
    }

    @Nullable
    public JSONIntermediateClientResponseControl getUpstreamResponse() {
        return this.upstreamResponse;
    }

    @NotNull
    public String toString() {
        return this.controlObject.toSingleLineString();
    }
}

