/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.AccessLogReader;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAbandonForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAbandonForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAbandonRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAbandonResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAddAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAddForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAddForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAddRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAddResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONBindForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONBindForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONBindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONBindResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONClientCertificateAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONCompareForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONCompareForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONCompareRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONCompareResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONDeleteAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONDeleteForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONDeleteForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONDeleteRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONDeleteResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONDisconnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONEntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONEntryRebalancingResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONExtendedForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONExtendedForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONExtendedRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONExtendedResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONIntermediateResponseAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONLogMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyDNAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyDNForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyDNForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyDNRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyDNResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONModifyResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSearchEntryAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSearchForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSearchForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSearchReferenceAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSearchResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONSecurityNegotiationAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONUnbindRequestAccessLogMessage;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONObjectReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class JSONAccessLogReader
implements AccessLogReader {
    @NotNull
    private final JSONObjectReader jsonObjectReader;

    public JSONAccessLogReader(@NotNull String logFilePath) throws IOException {
        this(new File(logFilePath));
    }

    public JSONAccessLogReader(@NotNull File logFile) throws IOException {
        this(new FileInputStream(logFile));
    }

    public JSONAccessLogReader(@NotNull InputStream inputStream) {
        this.jsonObjectReader = new JSONObjectReader(inputStream);
    }

    @Override
    @Nullable
    public JSONAccessLogMessage readMessage() throws IOException, LogException {
        JSONObject messageObject;
        try {
            messageObject = this.jsonObjectReader.readObject();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new IOException(JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_NOT_VALID_JSON.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (messageObject == null) {
            return null;
        }
        return JSONAccessLogReader.parseMessage(messageObject);
    }

    @NotNull
    public static JSONAccessLogMessage parseMessage(@NotNull JSONObject messageObject) throws LogException {
        String messageTypeStr = messageObject.getFieldAsString(JSONFormattedAccessLogFields.MESSAGE_TYPE.getFieldName());
        if (messageTypeStr == null) {
            String messageStr = messageObject.toSingleLineString();
            throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_MISSING_MESSAGE_TYPE.get(messageStr, JSONFormattedAccessLogFields.MESSAGE_TYPE.getFieldName()));
        }
        AccessLogMessageType messageType = AccessLogMessageType.forName(messageTypeStr);
        if (messageType == null) {
            String messageStr = messageObject.toSingleLineString();
            throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_MESSAGE_TYPE.get(messageStr, messageTypeStr));
        }
        switch (messageType) {
            case CONNECT: {
                return new JSONConnectAccessLogMessage(messageObject);
            }
            case DISCONNECT: {
                return new JSONDisconnectAccessLogMessage(messageObject);
            }
            case SECURITY_NEGOTIATION: {
                return new JSONSecurityNegotiationAccessLogMessage(messageObject);
            }
            case CLIENT_CERTIFICATE: {
                return new JSONClientCertificateAccessLogMessage(messageObject);
            }
            case ENTRY_REBALANCING_REQUEST: {
                return new JSONEntryRebalancingRequestAccessLogMessage(messageObject);
            }
            case ENTRY_REBALANCING_RESULT: {
                return new JSONEntryRebalancingResultAccessLogMessage(messageObject);
            }
            case ENTRY: {
                return new JSONSearchEntryAccessLogMessage(messageObject);
            }
            case REFERENCE: {
                return new JSONSearchReferenceAccessLogMessage(messageObject);
            }
            case INTERMEDIATE_RESPONSE: {
                return new JSONIntermediateResponseAccessLogMessage(messageObject);
            }
            case REQUEST: {
                return JSONAccessLogReader.createRequestMessage(messageObject);
            }
            case RESULT: {
                return JSONAccessLogReader.createResultMessage(messageObject);
            }
            case FORWARD: {
                return JSONAccessLogReader.createForwardMessage(messageObject);
            }
            case FORWARD_FAILED: {
                return JSONAccessLogReader.createForwardFailedMessage(messageObject);
            }
            case ASSURANCE_COMPLETE: {
                return JSONAccessLogReader.createAssuranceCompleteMessage(messageObject);
            }
        }
        String messageStr = messageObject.toSingleLineString();
        throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_MESSAGE_TYPE.get(messageStr, messageTypeStr));
    }

    @NotNull
    private static JSONAccessLogMessage createRequestMessage(@NotNull JSONObject messageObject) throws LogException {
        AccessLogOperationType operationType = JSONAccessLogReader.getOperationType(messageObject);
        switch (operationType) {
            case ABANDON: {
                return new JSONAbandonRequestAccessLogMessage(messageObject);
            }
            case ADD: {
                return new JSONAddRequestAccessLogMessage(messageObject);
            }
            case BIND: {
                return new JSONBindRequestAccessLogMessage(messageObject);
            }
            case COMPARE: {
                return new JSONCompareRequestAccessLogMessage(messageObject);
            }
            case DELETE: {
                return new JSONDeleteRequestAccessLogMessage(messageObject);
            }
            case EXTENDED: {
                return new JSONExtendedRequestAccessLogMessage(messageObject);
            }
            case MODIFY: {
                return new JSONModifyRequestAccessLogMessage(messageObject);
            }
            case MODDN: {
                return new JSONModifyDNRequestAccessLogMessage(messageObject);
            }
            case SEARCH: {
                return new JSONSearchRequestAccessLogMessage(messageObject);
            }
            case UNBIND: {
                return new JSONUnbindRequestAccessLogMessage(messageObject);
            }
        }
        String messageStr = messageObject.toSingleLineString();
        throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_REQUEST_OP_TYPE.get(messageStr, operationType.getLogIdentifier()));
    }

    @NotNull
    private static JSONAccessLogMessage createResultMessage(@NotNull JSONObject messageObject) throws LogException {
        AccessLogOperationType operationType = JSONAccessLogReader.getOperationType(messageObject);
        switch (operationType) {
            case ABANDON: {
                return new JSONAbandonResultAccessLogMessage(messageObject);
            }
            case ADD: {
                return new JSONAddResultAccessLogMessage(messageObject);
            }
            case BIND: {
                return new JSONBindResultAccessLogMessage(messageObject);
            }
            case COMPARE: {
                return new JSONCompareResultAccessLogMessage(messageObject);
            }
            case DELETE: {
                return new JSONDeleteResultAccessLogMessage(messageObject);
            }
            case EXTENDED: {
                return new JSONExtendedResultAccessLogMessage(messageObject);
            }
            case MODIFY: {
                return new JSONModifyResultAccessLogMessage(messageObject);
            }
            case MODDN: {
                return new JSONModifyDNResultAccessLogMessage(messageObject);
            }
            case SEARCH: {
                return new JSONSearchResultAccessLogMessage(messageObject);
            }
        }
        String messageStr = messageObject.toSingleLineString();
        throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_RESULT_OP_TYPE.get(messageStr, operationType.getLogIdentifier()));
    }

    @NotNull
    private static JSONAccessLogMessage createForwardMessage(@NotNull JSONObject messageObject) throws LogException {
        AccessLogOperationType operationType = JSONAccessLogReader.getOperationType(messageObject);
        switch (operationType) {
            case ABANDON: {
                return new JSONAbandonForwardAccessLogMessage(messageObject);
            }
            case ADD: {
                return new JSONAddForwardAccessLogMessage(messageObject);
            }
            case BIND: {
                return new JSONBindForwardAccessLogMessage(messageObject);
            }
            case COMPARE: {
                return new JSONCompareForwardAccessLogMessage(messageObject);
            }
            case DELETE: {
                return new JSONDeleteForwardAccessLogMessage(messageObject);
            }
            case EXTENDED: {
                return new JSONExtendedForwardAccessLogMessage(messageObject);
            }
            case MODIFY: {
                return new JSONModifyForwardAccessLogMessage(messageObject);
            }
            case MODDN: {
                return new JSONModifyDNForwardAccessLogMessage(messageObject);
            }
            case SEARCH: {
                return new JSONSearchForwardAccessLogMessage(messageObject);
            }
        }
        String messageStr = messageObject.toSingleLineString();
        throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_FORWARD_OP_TYPE.get(messageStr, operationType.getLogIdentifier()));
    }

    @NotNull
    private static JSONAccessLogMessage createForwardFailedMessage(@NotNull JSONObject messageObject) throws LogException {
        AccessLogOperationType operationType = JSONAccessLogReader.getOperationType(messageObject);
        switch (operationType) {
            case ABANDON: {
                return new JSONAbandonForwardFailedAccessLogMessage(messageObject);
            }
            case ADD: {
                return new JSONAddForwardFailedAccessLogMessage(messageObject);
            }
            case BIND: {
                return new JSONBindForwardFailedAccessLogMessage(messageObject);
            }
            case COMPARE: {
                return new JSONCompareForwardFailedAccessLogMessage(messageObject);
            }
            case DELETE: {
                return new JSONDeleteForwardFailedAccessLogMessage(messageObject);
            }
            case EXTENDED: {
                return new JSONExtendedForwardFailedAccessLogMessage(messageObject);
            }
            case MODIFY: {
                return new JSONModifyForwardFailedAccessLogMessage(messageObject);
            }
            case MODDN: {
                return new JSONModifyDNForwardFailedAccessLogMessage(messageObject);
            }
            case SEARCH: {
                return new JSONSearchForwardFailedAccessLogMessage(messageObject);
            }
        }
        String messageStr = messageObject.toSingleLineString();
        throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_FORWARD_FAILED_OP_TYPE.get(messageStr, operationType.getLogIdentifier()));
    }

    @NotNull
    private static JSONAccessLogMessage createAssuranceCompleteMessage(@NotNull JSONObject messageObject) throws LogException {
        AccessLogOperationType operationType = JSONAccessLogReader.getOperationType(messageObject);
        switch (operationType) {
            case ADD: {
                return new JSONAddAssuranceCompletedAccessLogMessage(messageObject);
            }
            case DELETE: {
                return new JSONDeleteAssuranceCompletedAccessLogMessage(messageObject);
            }
            case MODIFY: {
                return new JSONModifyAssuranceCompletedAccessLogMessage(messageObject);
            }
            case MODDN: {
                return new JSONModifyDNAssuranceCompletedAccessLogMessage(messageObject);
            }
        }
        String messageStr = messageObject.toSingleLineString();
        throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_ASSURANCE_COMPLETED_OP_TYPE.get(messageStr, operationType.getLogIdentifier()));
    }

    @NotNull
    private static AccessLogOperationType getOperationType(@NotNull JSONObject messageObject) throws LogException {
        String opTypeStr = messageObject.getFieldAsString(JSONFormattedAccessLogFields.OPERATION_TYPE.getFieldName());
        if (opTypeStr == null) {
            String messageStr = messageObject.toSingleLineString();
            throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_MISSING_OPERATION_TYPE.get(messageStr, JSONFormattedAccessLogFields.OPERATION_TYPE.getFieldName()));
        }
        AccessLogOperationType opType = AccessLogOperationType.forName(opTypeStr);
        if (opType == null) {
            String messageStr = messageObject.toSingleLineString();
            throw new LogException(messageStr, JSONLogMessages.ERR_JSON_ACCESS_LOG_READER_UNSUPPORTED_OPERATION_TYPE.get(messageStr, opTypeStr));
        }
        return opType;
    }

    @Override
    public void close() throws IOException {
        this.jsonObjectReader.close();
    }
}

