/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationRequestAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class ModifyRequestAccessLogMessage
extends OperationRequestAccessLogMessage {
    private static final long serialVersionUID = -8276481811479971408L;
    @Nullable
    private final List<String> attributeNames;
    @Nullable
    private final String dn = this.getNamedValue("dn");

    public ModifyRequestAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public ModifyRequestAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        String attrs = this.getNamedValue("attrs");
        if (attrs == null) {
            this.attributeNames = null;
        } else {
            ArrayList<String> l = new ArrayList<String>(10);
            StringTokenizer tokenizer = new StringTokenizer(attrs, ",");
            while (tokenizer.hasMoreTokens()) {
                l.add(tokenizer.nextToken());
            }
            this.attributeNames = Collections.unmodifiableList(l);
        }
    }

    @Nullable
    public final String getDN() {
        return this.dn;
    }

    @Nullable
    public final List<String> getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.MODIFY;
    }
}

