/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.JVMDefaultReplaceCertificateTrustBehavior;
import com.unboundid.ldap.sdk.unboundidds.extensions.TrustManagerProviderReplaceCertificateTrustBehavior;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class ReplaceCertificateTrustBehavior
implements Serializable {
    private static final long serialVersionUID = 2978084206955241218L;

    @NotNull
    public abstract ASN1Element encode();

    @NotNull
    public static ReplaceCertificateTrustBehavior decode(@NotNull ASN1Element element) throws LDAPException {
        switch (element.getType()) {
            case -124: {
                return new TrustManagerProviderReplaceCertificateTrustBehavior(element.decodeAsOctetString().stringValue());
            }
            case -123: {
                return JVMDefaultReplaceCertificateTrustBehavior.getInstance();
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_TB_DECODE_UNRECOGNIZED_TYPE.get(StaticUtils.toHex(element.getType())));
    }

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(@NotNull StringBuilder var1);
}

