/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.MultiUpdateErrorBehavior;
import com.unboundid.ldap.sdk.unboundidds.extensions.MultiUpdateExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MultiUpdateExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String MULTI_UPDATE_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.17";
    private static final long serialVersionUID = 6101686180473949142L;
    @NotNull
    private final List<LDAPRequest> requests;
    @NotNull
    private final MultiUpdateErrorBehavior errorBehavior;

    public MultiUpdateExtendedRequest(@NotNull MultiUpdateErrorBehavior errorBehavior, LDAPRequest ... requests) throws LDAPException {
        this(errorBehavior, Arrays.asList(requests), new Control[0]);
    }

    public MultiUpdateExtendedRequest(@NotNull MultiUpdateErrorBehavior errorBehavior, @NotNull LDAPRequest[] requests, Control ... controls) throws LDAPException {
        this(errorBehavior, Arrays.asList(requests), controls);
    }

    public MultiUpdateExtendedRequest(@NotNull MultiUpdateErrorBehavior errorBehavior, @NotNull List<LDAPRequest> requests, Control ... controls) throws LDAPException {
        super(MULTI_UPDATE_REQUEST_OID, MultiUpdateExtendedRequest.encodeValue(errorBehavior, requests), controls);
        this.errorBehavior = errorBehavior;
        ArrayList<LDAPRequest> requestList = new ArrayList<LDAPRequest>(requests.size());
        block3: for (LDAPRequest r : requests) {
            switch (r.getOperationType()) {
                case ADD: 
                case DELETE: 
                case MODIFY: 
                case MODIFY_DN: 
                case EXTENDED: {
                    requestList.add(r);
                    continue block3;
                }
            }
            throw new LDAPException(ResultCode.PARAM_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_REQUEST_INVALID_REQUEST_TYPE.get(r.getOperationType().name()));
        }
        this.requests = Collections.unmodifiableList(requestList);
    }

    private MultiUpdateExtendedRequest(@NotNull MultiUpdateErrorBehavior errorBehavior, @NotNull List<LDAPRequest> requests, @NotNull ASN1OctetString encodedValue, Control ... controls) {
        super(MULTI_UPDATE_REQUEST_OID, encodedValue, controls);
        this.errorBehavior = errorBehavior;
        this.requests = requests;
    }

    public MultiUpdateExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] ve = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.errorBehavior = MultiUpdateErrorBehavior.valueOf(ASN1Enumerated.decodeAsEnumerated(ve[0]).intValue());
            if (this.errorBehavior == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_REQUEST_INVALID_ERROR_BEHAVIOR.get(ASN1Enumerated.decodeAsEnumerated(ve[0]).intValue()));
            }
            ASN1Element[] requestSequenceElements = ASN1Sequence.decodeAsSequence(ve[1]).elements();
            ArrayList<LDAPRequest> rl = new ArrayList<LDAPRequest>(requestSequenceElements.length);
            block10: for (ASN1Element rse : requestSequenceElements) {
                ASN1Element[] requestElements = ASN1Sequence.decodeAsSequence(rse).elements();
                Control[] controls = requestElements.length == 2 ? Control.decodeControls(ASN1Sequence.decodeAsSequence(requestElements[1])) : StaticUtils.NO_CONTROLS;
                switch (requestElements[0].getType()) {
                    case 104: {
                        rl.add(AddRequestProtocolOp.decodeProtocolOp(requestElements[0]).toAddRequest(controls));
                        continue block10;
                    }
                    case 74: {
                        rl.add(DeleteRequestProtocolOp.decodeProtocolOp(requestElements[0]).toDeleteRequest(controls));
                        continue block10;
                    }
                    case 119: {
                        rl.add(ExtendedRequestProtocolOp.decodeProtocolOp(requestElements[0]).toExtendedRequest(controls));
                        continue block10;
                    }
                    case 102: {
                        rl.add(ModifyRequestProtocolOp.decodeProtocolOp(requestElements[0]).toModifyRequest(controls));
                        continue block10;
                    }
                    case 108: {
                        rl.add(ModifyDNRequestProtocolOp.decodeProtocolOp(requestElements[0]).toModifyDNRequest(controls));
                        continue block10;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_REQUEST_INVALID_OP_TYPE.get(StaticUtils.toHex(requestElements[0].getType())));
                    }
                }
            }
            this.requests = Collections.unmodifiableList(rl);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MULTI_UPDATE_REQUEST_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull MultiUpdateErrorBehavior errorBehavior, @NotNull List<LDAPRequest> requests) {
        ArrayList<ASN1Sequence> requestElements = new ArrayList<ASN1Sequence>(requests.size());
        for (LDAPRequest r : requests) {
            ArrayList<ASN1Element> rsElements = new ArrayList<ASN1Element>(2);
            switch (r.getOperationType()) {
                case ADD: {
                    rsElements.add(((AddRequest)r).encodeProtocolOp());
                    break;
                }
                case DELETE: {
                    rsElements.add(((DeleteRequest)r).encodeProtocolOp());
                    break;
                }
                case MODIFY: {
                    rsElements.add(((ModifyRequest)r).encodeProtocolOp());
                    break;
                }
                case MODIFY_DN: {
                    rsElements.add(((ModifyDNRequest)r).encodeProtocolOp());
                    break;
                }
                case EXTENDED: {
                    rsElements.add(((ExtendedRequest)r).encodeProtocolOp());
                }
            }
            if (r.hasControl()) {
                rsElements.add(Control.encodeControls(r.getControls()));
            }
            requestElements.add(new ASN1Sequence(rsElements));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1Enumerated(errorBehavior.intValue()), new ASN1Sequence(requestElements));
        return new ASN1OctetString(valueSequence.encode());
    }

    @Override
    @NotNull
    public MultiUpdateExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new MultiUpdateExtendedResult(extendedResponse);
    }

    @NotNull
    public MultiUpdateErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    @NotNull
    public List<LDAPRequest> getRequests() {
        return this.requests;
    }

    @Override
    @NotNull
    public MultiUpdateExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public MultiUpdateExtendedRequest duplicate(@Nullable Control[] controls) {
        MultiUpdateExtendedRequest r = new MultiUpdateExtendedRequest(this.errorBehavior, this.requests, this.getValue(), controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_MULTI_UPDATE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MultiUpdateExtendedRequest(errorBehavior=");
        buffer.append(this.errorBehavior.name());
        buffer.append(", requests={");
        Iterator<LDAPRequest> iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

