/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.CollectSupportDataLogCaptureWindow;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DurationCollectSupportDataLogCaptureWindow
extends CollectSupportDataLogCaptureWindow {
    private static final long serialVersionUID = -6685577889240682295L;
    @NotNull
    private final ASN1Element encodedWindow;
    private final long durationMillis;

    public DurationCollectSupportDataLogCaptureWindow(long durationMillis) {
        Validator.ensureTrue(durationMillis >= 0L, "DurationCollectSupportDataLogCaptureWindow.durationMillis must be greater than or equal to zero.");
        this.durationMillis = durationMillis;
        this.encodedWindow = new ASN1Long(-127, durationMillis);
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    @NotNull
    static DurationCollectSupportDataLogCaptureWindow decodeInternal(@NotNull ASN1Element e) throws LDAPException {
        try {
            long durationMillis = ASN1Long.decodeAsLong(e).longValue();
            return new DurationCollectSupportDataLogCaptureWindow(durationMillis);
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DURATION_CSD_LOG_WINDOW_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        return this.encodedWindow;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("DurationCollectSupportDataLogCaptureWindow(durationMillis=");
        buffer.append(this.durationMillis);
        buffer.append(')');
    }
}

