/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetAuthorizationEntryRequestControl
extends Control {
    @NotNull
    public static final String GET_AUTHORIZATION_ENTRY_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.6";
    private static final byte TYPE_INCLUDE_AUTHN_ENTRY = -128;
    private static final byte TYPE_INCLUDE_AUTHZ_ENTRY = -127;
    private static final byte TYPE_ATTRIBUTES = -94;
    @NotNull
    private static final String JSON_FIELD_ATTRIBUTES = "attributes";
    @NotNull
    private static final String JSON_FIELD_INCLUDE_AUTHENTICATION_ENTRY = "include-authentication-entry";
    @NotNull
    private static final String JSON_FIELD_INCLUDE_AUTHORIZATION_ENTRY = "include-authorization-entry";
    private static final long serialVersionUID = -5540345171260624216L;
    private final boolean includeAuthNEntry;
    private final boolean includeAuthZEntry;
    @NotNull
    private final List<String> attributes;

    public GetAuthorizationEntryRequestControl() {
        this(false, true, true, (List<String>)null);
    }

    public GetAuthorizationEntryRequestControl(boolean includeAuthNEntry, boolean includeAuthZEntry, String ... attributes) {
        this(false, includeAuthNEntry, includeAuthZEntry, attributes == null ? null : Arrays.asList(attributes));
    }

    public GetAuthorizationEntryRequestControl(boolean includeAuthNEntry, boolean includeAuthZEntry, @Nullable List<String> attributes) {
        this(false, includeAuthNEntry, includeAuthZEntry, attributes);
    }

    public GetAuthorizationEntryRequestControl(boolean isCritical, boolean includeAuthNEntry, boolean includeAuthZEntry, String ... attributes) {
        this(isCritical, includeAuthNEntry, includeAuthZEntry, attributes == null ? null : Arrays.asList(attributes));
    }

    public GetAuthorizationEntryRequestControl(boolean isCritical, boolean includeAuthNEntry, boolean includeAuthZEntry, @Nullable List<String> attributes) {
        super(GET_AUTHORIZATION_ENTRY_REQUEST_OID, isCritical, GetAuthorizationEntryRequestControl.encodeValue(includeAuthNEntry, includeAuthZEntry, attributes));
        this.includeAuthNEntry = includeAuthNEntry;
        this.includeAuthZEntry = includeAuthZEntry;
        this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(attributes));
    }

    public GetAuthorizationEntryRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            this.includeAuthNEntry = true;
            this.includeAuthZEntry = true;
            this.attributes = Collections.emptyList();
            return;
        }
        try {
            ArrayList<String> attrs = new ArrayList<String>(20);
            boolean includeAuthN = true;
            boolean includeAuthZ = true;
            ASN1Element element = ASN1Element.decode(value.getValue());
            block8: for (ASN1Element e : ASN1Sequence.decodeAsSequence(element).elements()) {
                switch (e.getType()) {
                    case -128: {
                        includeAuthN = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -127: {
                        includeAuthZ = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -94: {
                        for (ASN1Element ae : ASN1Sequence.decodeAsSequence(e).elements()) {
                            attrs.add(ASN1OctetString.decodeAsOctetString(ae).stringValue());
                        }
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_INVALID_SEQUENCE_ELEMENT.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.includeAuthNEntry = includeAuthN;
            this.includeAuthZEntry = includeAuthZ;
            this.attributes = attrs;
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    private static ASN1OctetString encodeValue(boolean includeAuthNEntry, boolean includeAuthZEntry, @Nullable List<String> attributes) {
        if (includeAuthNEntry && includeAuthZEntry && (attributes == null || attributes.isEmpty())) {
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        if (!includeAuthNEntry) {
            elements.add(new ASN1Boolean(-128, false));
        }
        if (!includeAuthZEntry) {
            elements.add(new ASN1Boolean(-127, false));
        }
        if (attributes != null && !attributes.isEmpty()) {
            ArrayList<ASN1OctetString> attrElements = new ArrayList<ASN1OctetString>(attributes.size());
            for (String s : attributes) {
                attrElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-94, attrElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public boolean includeAuthNEntry() {
        return this.includeAuthNEntry;
    }

    public boolean includeAuthZEntry() {
        return this.includeAuthZEntry;
    }

    @NotNull
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_AUTHORIZATION_ENTRY_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_INCLUDE_AUTHENTICATION_ENTRY, new JSONBoolean(this.includeAuthNEntry));
        valueFields.put(JSON_FIELD_INCLUDE_AUTHORIZATION_ENTRY, new JSONBoolean(this.includeAuthZEntry));
        if (!this.attributes.isEmpty()) {
            ArrayList<JSONString> attributeValues = new ArrayList<JSONString>(this.attributes.size());
            for (String attribute : this.attributes) {
                attributeValues.add(new JSONString(attribute));
            }
            valueFields.put(JSON_FIELD_ATTRIBUTES, new JSONArray(attributeValues));
        }
        return new JSONObject(new JSONField("oid", GET_AUTHORIZATION_ENTRY_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_AUTHORIZATION_ENTRY_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static GetAuthorizationEntryRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ArrayList<String> attributes;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetAuthorizationEntryRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Boolean includeAuthNEntry = valueObject.getFieldAsBoolean(JSON_FIELD_INCLUDE_AUTHENTICATION_ENTRY);
        if (includeAuthNEntry == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_INCLUDE_AUTHENTICATION_ENTRY));
        }
        Boolean includeAuthZEntry = valueObject.getFieldAsBoolean(JSON_FIELD_INCLUDE_AUTHORIZATION_ENTRY);
        if (includeAuthZEntry == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_INCLUDE_AUTHORIZATION_ENTRY));
        }
        List<JSONValue> attributeValues = valueObject.getFieldAsArray(JSON_FIELD_ATTRIBUTES);
        if (attributeValues == null) {
            attributes = null;
        } else {
            attributes = new ArrayList<String>(attributeValues.size());
            for (JSONValue v : attributeValues) {
                if (v instanceof JSONString) {
                    attributes.add(((JSONString)v).stringValue());
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_JSON_ATTR_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_ATTRIBUTES));
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_INCLUDE_AUTHENTICATION_ENTRY, JSON_FIELD_INCLUDE_AUTHORIZATION_ENTRY, JSON_FIELD_ATTRIBUTES)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetAuthorizationEntryRequestControl(jsonControl.getCriticality(), (boolean)includeAuthNEntry, (boolean)includeAuthZEntry, attributes);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetAuthorizationEntryRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", includeAuthNEntry=");
        buffer.append(this.includeAuthNEntry);
        buffer.append(", includeAuthZEntry=");
        buffer.append(this.includeAuthZEntry);
        buffer.append(", attributes={");
        Iterator<String> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

