/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AssuredReplicationRequestControl
extends Control {
    @NotNull
    public static final String ASSURED_REPLICATION_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.28";
    private static final byte TYPE_MIN_LOCAL_LEVEL = -128;
    private static final byte TYPE_MAX_LOCAL_LEVEL = -127;
    private static final byte TYPE_MIN_REMOTE_LEVEL = -126;
    private static final byte TYPE_MAX_REMOTE_LEVEL = -125;
    private static final byte TYPE_SEND_RESPONSE_IMMEDIATELY = -124;
    private static final byte TYPE_TIMEOUT = -123;
    @NotNull
    private static final String JSON_FIELD_MAXIMUM_LOCAL_LEVEL = "maximum-local-level";
    @NotNull
    private static final String JSON_FIELD_MAXIMUM_REMOTE_LEVEL = "maximum-remote-level";
    @NotNull
    private static final String JSON_FIELD_MINIMUM_LOCAL_LEVEL = "minimum-local-level";
    @NotNull
    private static final String JSON_FIELD_MINIMUM_REMOTE_LEVEL = "minimum-remote-level";
    @NotNull
    private static final String JSON_FIELD_SEND_RESPONSE_IMMEDIATELY = "send-response-immediately";
    @NotNull
    private static final String JSON_FIELD_TIMEOUT_MILLIS = "timeout-millis";
    private static final long serialVersionUID = -2013933506118879241L;
    @Nullable
    private final AssuredReplicationLocalLevel maximumLocalLevel;
    @Nullable
    private final AssuredReplicationLocalLevel minimumLocalLevel;
    @Nullable
    private final AssuredReplicationRemoteLevel maximumRemoteLevel;
    @Nullable
    private final AssuredReplicationRemoteLevel minimumRemoteLevel;
    private final boolean sendResponseImmediately;
    @Nullable
    private final Long timeoutMillis;

    public AssuredReplicationRequestControl(@Nullable AssuredReplicationLocalLevel minimumLocalLevel, @Nullable AssuredReplicationRemoteLevel minimumRemoteLevel, @Nullable Long timeoutMillis) {
        this(false, minimumLocalLevel, null, minimumRemoteLevel, null, timeoutMillis, false);
    }

    public AssuredReplicationRequestControl(boolean isCritical, @Nullable AssuredReplicationLocalLevel minimumLocalLevel, @Nullable AssuredReplicationLocalLevel maximumLocalLevel, @Nullable AssuredReplicationRemoteLevel minimumRemoteLevel, @Nullable AssuredReplicationRemoteLevel maximumRemoteLevel, @Nullable Long timeoutMillis, boolean sendResponseImmediately) {
        super(ASSURED_REPLICATION_REQUEST_OID, isCritical, AssuredReplicationRequestControl.encodeValue(minimumLocalLevel, maximumLocalLevel, minimumRemoteLevel, maximumRemoteLevel, sendResponseImmediately, timeoutMillis));
        this.minimumLocalLevel = minimumLocalLevel;
        this.maximumLocalLevel = maximumLocalLevel;
        this.minimumRemoteLevel = minimumRemoteLevel;
        this.maximumRemoteLevel = maximumRemoteLevel;
        this.sendResponseImmediately = sendResponseImmediately;
        this.timeoutMillis = timeoutMillis;
    }

    public AssuredReplicationRequestControl(@NotNull Control c) throws LDAPException {
        super(c);
        ASN1OctetString value = c.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_NO_VALUE.get());
        }
        AssuredReplicationLocalLevel maxLocalLevel = null;
        AssuredReplicationLocalLevel minLocalLevel = null;
        AssuredReplicationRemoteLevel maxRemoteLevel = null;
        AssuredReplicationRemoteLevel minRemoteLevel = null;
        boolean sendImmediately = false;
        Long timeout = null;
        try {
            block11: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        minLocalLevel = AssuredReplicationLocalLevel.valueOf(intValue);
                        if (minLocalLevel != null) continue block11;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_INVALID_MIN_LOCAL_LEVEL.get(intValue));
                    }
                    case -127: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        maxLocalLevel = AssuredReplicationLocalLevel.valueOf(intValue);
                        if (maxLocalLevel != null) continue block11;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_INVALID_MAX_LOCAL_LEVEL.get(intValue));
                    }
                    case -126: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        minRemoteLevel = AssuredReplicationRemoteLevel.valueOf(intValue);
                        if (minRemoteLevel != null) continue block11;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_INVALID_MIN_REMOTE_LEVEL.get(intValue));
                    }
                    case -125: {
                        int intValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        maxRemoteLevel = AssuredReplicationRemoteLevel.valueOf(intValue);
                        if (maxRemoteLevel != null) continue block11;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_INVALID_MAX_REMOTE_LEVEL.get(intValue));
                    }
                    case -124: {
                        sendImmediately = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block11;
                    }
                    case -123: {
                        timeout = ASN1Long.decodeAsLong(e).longValue();
                        continue block11;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_UNEXPECTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.minimumLocalLevel = minLocalLevel;
        this.maximumLocalLevel = maxLocalLevel;
        this.minimumRemoteLevel = minRemoteLevel;
        this.maximumRemoteLevel = maxRemoteLevel;
        this.sendResponseImmediately = sendImmediately;
        this.timeoutMillis = timeout;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable AssuredReplicationLocalLevel minimumLocalLevel, @Nullable AssuredReplicationLocalLevel maximumLocalLevel, @Nullable AssuredReplicationRemoteLevel minimumRemoteLevel, @Nullable AssuredReplicationRemoteLevel maximumRemoteLevel, boolean sendResponseImmediately, @Nullable Long timeoutMillis) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(6);
        if (minimumLocalLevel != null) {
            elements.add(new ASN1Enumerated(-128, minimumLocalLevel.intValue()));
        }
        if (maximumLocalLevel != null) {
            elements.add(new ASN1Enumerated(-127, maximumLocalLevel.intValue()));
        }
        if (minimumRemoteLevel != null) {
            elements.add(new ASN1Enumerated(-126, minimumRemoteLevel.intValue()));
        }
        if (maximumRemoteLevel != null) {
            elements.add(new ASN1Enumerated(-125, maximumRemoteLevel.intValue()));
        }
        if (sendResponseImmediately) {
            elements.add(new ASN1Boolean(-124, true));
        }
        if (timeoutMillis != null) {
            elements.add(new ASN1Long(-123, timeoutMillis));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public AssuredReplicationLocalLevel getMinimumLocalLevel() {
        return this.minimumLocalLevel;
    }

    @Nullable
    public AssuredReplicationLocalLevel getMaximumLocalLevel() {
        return this.maximumLocalLevel;
    }

    @Nullable
    public AssuredReplicationRemoteLevel getMinimumRemoteLevel() {
        return this.minimumRemoteLevel;
    }

    @Nullable
    public AssuredReplicationRemoteLevel getMaximumRemoteLevel() {
        return this.maximumRemoteLevel;
    }

    public boolean sendResponseImmediately() {
        return this.sendResponseImmediately;
    }

    @Nullable
    public Long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ASSURED_REPLICATION_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> jsonValueFields = new LinkedHashMap<String, JSONValue>();
        if (this.minimumLocalLevel != null) {
            jsonValueFields.put(JSON_FIELD_MINIMUM_LOCAL_LEVEL, new JSONString(this.minimumLocalLevel.getName()));
        }
        if (this.maximumLocalLevel != null) {
            jsonValueFields.put(JSON_FIELD_MAXIMUM_LOCAL_LEVEL, new JSONString(this.maximumLocalLevel.getName()));
        }
        if (this.minimumRemoteLevel != null) {
            jsonValueFields.put(JSON_FIELD_MINIMUM_REMOTE_LEVEL, new JSONString(this.minimumRemoteLevel.getName()));
        }
        if (this.maximumRemoteLevel != null) {
            jsonValueFields.put(JSON_FIELD_MAXIMUM_REMOTE_LEVEL, new JSONString(this.maximumRemoteLevel.getName()));
        }
        if (this.timeoutMillis != null) {
            jsonValueFields.put(JSON_FIELD_TIMEOUT_MILLIS, new JSONNumber(this.timeoutMillis));
        }
        jsonValueFields.put(JSON_FIELD_SEND_RESPONSE_IMMEDIATELY, new JSONBoolean(this.sendResponseImmediately));
        return new JSONObject(new JSONField("oid", ASSURED_REPLICATION_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_ASSURED_REPLICATION_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(jsonValueFields)));
    }

    @NotNull
    public static AssuredReplicationRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new AssuredReplicationRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        AssuredReplicationLocalLevel minimumLocalLevel = null;
        AssuredReplicationLocalLevel maximumLocalLevel = null;
        AssuredReplicationRemoteLevel minimumRemoteLevel = null;
        AssuredReplicationRemoteLevel maximumRemoteLevel = null;
        Long timeoutMillis = null;
        Boolean sendImmediately = null;
        JSONObject valueObject = jsonControl.getValueObject();
        String minLocalLevelStr = valueObject.getFieldAsString(JSON_FIELD_MINIMUM_LOCAL_LEVEL);
        if (minLocalLevelStr != null && (minimumLocalLevel = AssuredReplicationLocalLevel.forName(minLocalLevelStr)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_JSON_INVALID_MIN_LOCAL_LEVEL.get(controlObject.toSingleLineString(), minLocalLevelStr));
        }
        String maxLocalLevelStr = valueObject.getFieldAsString(JSON_FIELD_MAXIMUM_LOCAL_LEVEL);
        if (maxLocalLevelStr != null && (maximumLocalLevel = AssuredReplicationLocalLevel.forName(maxLocalLevelStr)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_JSON_INVALID_MAX_LOCAL_LEVEL.get(controlObject.toSingleLineString(), maxLocalLevelStr));
        }
        String minRemoteLevelStr = valueObject.getFieldAsString(JSON_FIELD_MINIMUM_REMOTE_LEVEL);
        if (minRemoteLevelStr != null && (minimumRemoteLevel = AssuredReplicationRemoteLevel.forName(minRemoteLevelStr)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_JSON_INVALID_MIN_REMOTE_LEVEL.get(controlObject.toSingleLineString(), minRemoteLevelStr));
        }
        String maxRemoteLevelStr = valueObject.getFieldAsString(JSON_FIELD_MAXIMUM_REMOTE_LEVEL);
        if (maxRemoteLevelStr != null && (maximumRemoteLevel = AssuredReplicationRemoteLevel.forName(maxRemoteLevelStr)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_JSON_INVALID_MAX_REMOTE_LEVEL.get(controlObject.toSingleLineString(), maxRemoteLevelStr));
        }
        timeoutMillis = valueObject.getFieldAsLong(JSON_FIELD_TIMEOUT_MILLIS);
        sendImmediately = valueObject.getFieldAsBoolean(JSON_FIELD_SEND_RESPONSE_IMMEDIATELY);
        if (sendImmediately == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_SEND_RESPONSE_IMMEDIATELY));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_MINIMUM_LOCAL_LEVEL, JSON_FIELD_MAXIMUM_LOCAL_LEVEL, JSON_FIELD_MINIMUM_REMOTE_LEVEL, JSON_FIELD_MAXIMUM_REMOTE_LEVEL, JSON_FIELD_TIMEOUT_MILLIS, JSON_FIELD_SEND_RESPONSE_IMMEDIATELY)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_REQUEST_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new AssuredReplicationRequestControl(jsonControl.getCriticality(), minimumLocalLevel, maximumLocalLevel, minimumRemoteLevel, maximumRemoteLevel, timeoutMillis, sendImmediately);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AssuredReplicationRequestControl(isCritical=");
        buffer.append(this.isCritical());
        if (this.minimumLocalLevel != null) {
            buffer.append(", minimumLocalLevel=");
            buffer.append(this.minimumLocalLevel.name());
        }
        if (this.maximumLocalLevel != null) {
            buffer.append(", maximumLocalLevel=");
            buffer.append(this.maximumLocalLevel.name());
        }
        if (this.minimumRemoteLevel != null) {
            buffer.append(", minimumRemoteLevel=");
            buffer.append(this.minimumRemoteLevel.name());
        }
        if (this.maximumRemoteLevel != null) {
            buffer.append(", maximumRemoteLevel=");
            buffer.append(this.maximumRemoteLevel.name());
        }
        buffer.append(", sendResponseImmediately=");
        buffer.append(this.sendResponseImmediately);
        if (this.timeoutMillis != null) {
            buffer.append(", timeoutMillis=");
            buffer.append(this.timeoutMillis);
        }
        buffer.append(')');
    }
}

