/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SingleServerSet
extends ServerSet {
    @Nullable
    private final BindRequest bindRequest;
    private final int port;
    @NotNull
    private final LDAPConnectionOptions connectionOptions;
    @Nullable
    private final PostConnectProcessor postConnectProcessor;
    @NotNull
    private final SocketFactory socketFactory;
    @NotNull
    private final String address;

    public SingleServerSet(@NotNull String address, int port) {
        this(address, port, null, null);
    }

    public SingleServerSet(@NotNull String address, int port, @Nullable LDAPConnectionOptions connectionOptions) {
        this(address, port, null, connectionOptions);
    }

    public SingleServerSet(@NotNull String address, int port, @Nullable SocketFactory socketFactory) {
        this(address, port, socketFactory, null);
    }

    public SingleServerSet(@NotNull String address, int port, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions connectionOptions) {
        this(address, port, socketFactory, connectionOptions, null, null);
    }

    public SingleServerSet(@NotNull String address, int port, @Nullable SocketFactory socketFactory, @Nullable LDAPConnectionOptions connectionOptions, @Nullable BindRequest bindRequest, @Nullable PostConnectProcessor postConnectProcessor) {
        Validator.ensureNotNull(address);
        Validator.ensureTrue(port > 0 && port < 65536, "SingleServerSet.port must be between 1 and 65535.");
        this.address = address;
        this.port = port;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @Override
    public boolean includesAuthentication() {
        return this.bindRequest != null;
    }

    @Override
    public boolean includesPostConnectProcessing() {
        return this.postConnectProcessor != null;
    }

    @Override
    @NotNull
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    @NotNull
    public LDAPConnection getConnection(@Nullable LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        LDAPConnection connection = new LDAPConnection(this.socketFactory, this.connectionOptions, this.address, this.port);
        SingleServerSet.doBindPostConnectAndHealthCheckProcessing(connection, this.bindRequest, this.postConnectProcessor, healthCheck);
        this.associateConnectionWithThisServerSet(connection);
        return connection;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SingleServerSet(server=");
        buffer.append(this.address);
        buffer.append(':');
        buffer.append(this.port);
        buffer.append(", includesAuthentication=");
        buffer.append(this.bindRequest != null);
        buffer.append(", includesPostConnectProcessing=");
        buffer.append(this.postConnectProcessor != null);
        buffer.append(')');
    }
}

