/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ToCodeRequestHandler
extends LDAPListenerRequestHandler {
    @NotNull
    private final AtomicBoolean firstMessage;
    private final boolean includeProcessing;
    @Nullable
    private final LDAPListenerClientConnection clientConnection;
    @NotNull
    private final LDAPListenerRequestHandler requestHandler;
    @NotNull
    private final PrintStream logStream;
    @NotNull
    private final ThreadLocal<List<String>> lineLists;

    public ToCodeRequestHandler(@NotNull String outputFilePath, boolean includeProcessing, @NotNull LDAPListenerRequestHandler requestHandler) throws IOException {
        this(new File(outputFilePath), includeProcessing, requestHandler);
    }

    public ToCodeRequestHandler(@NotNull File outputFile, boolean includeProcessing, @NotNull LDAPListenerRequestHandler requestHandler) throws IOException {
        this(new FileOutputStream(outputFile, true), includeProcessing, requestHandler);
    }

    public ToCodeRequestHandler(@NotNull OutputStream outputStream, boolean includeProcessing, @NotNull LDAPListenerRequestHandler requestHandler) {
        this.logStream = new PrintStream(outputStream, true);
        this.includeProcessing = includeProcessing;
        this.requestHandler = requestHandler;
        this.firstMessage = new AtomicBoolean(true);
        this.lineLists = new ThreadLocal();
        this.clientConnection = null;
    }

    private ToCodeRequestHandler(@NotNull ToCodeRequestHandler parentHandler, @NotNull LDAPListenerClientConnection connection) throws LDAPException {
        this.logStream = parentHandler.logStream;
        this.includeProcessing = parentHandler.includeProcessing;
        this.requestHandler = parentHandler.requestHandler.newInstance(connection);
        this.firstMessage = parentHandler.firstMessage;
        this.clientConnection = connection;
        this.lineLists = parentHandler.lineLists;
    }

    @Override
    @NotNull
    public ToCodeRequestHandler newInstance(@NotNull LDAPListenerClientConnection connection) throws LDAPException {
        return new ToCodeRequestHandler(this, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInstance() {
        this.requestHandler.closeInstance();
        if (this.clientConnection == null) {
            PrintStream printStream = this.logStream;
            synchronized (printStream) {
                this.logStream.close();
            }
        }
    }

    @Override
    public void processAbandonRequest(int messageID, @NotNull AbandonRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.includeProcessing) {
            List<String> lineList = this.getLineList(messageID);
            ArrayList<ToCodeArgHelper> args = new ArrayList<ToCodeArgHelper>(2);
            args.add(ToCodeArgHelper.createRaw("asyncRequestID" + request.getIDToAbandon(), "Async Request ID"));
            if (!controls.isEmpty()) {
                Control[] controlArray = new Control[controls.size()];
                controls.toArray(controlArray);
                args.add(ToCodeArgHelper.createControlArray(controlArray, "Request Controls"));
            }
            ToCodeHelper.generateMethodCall(lineList, 0, null, null, "connection.abandon", args);
            this.writeLines(lineList);
        }
        this.requestHandler.processAbandonRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processAddRequest(int messageID, @NotNull AddRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "Add";
        AddRequest addRequest = request.toAddRequest(ToCodeRequestHandler.getControlArray(controls));
        addRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processAddRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processBindRequest(int messageID, @NotNull BindRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "Bind";
        BindRequest bindRequest = request.toBindRequest(ToCodeRequestHandler.getControlArray(controls));
        bindRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processBindRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processCompareRequest(int messageID, @NotNull CompareRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "Compare";
        CompareRequest compareRequest = request.toCompareRequest(ToCodeRequestHandler.getControlArray(controls));
        compareRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processCompareRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processDeleteRequest(int messageID, @NotNull DeleteRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "Delete";
        DeleteRequest deleteRequest = request.toDeleteRequest(ToCodeRequestHandler.getControlArray(controls));
        deleteRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processDeleteRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processExtendedRequest(int messageID, @NotNull ExtendedRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "Extended";
        ExtendedRequest extendedRequest = request.toExtendedRequest(ToCodeRequestHandler.getControlArray(controls));
        extendedRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processExtendedRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processModifyRequest(int messageID, @NotNull ModifyRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "Modify";
        ModifyRequest modifyRequest = request.toModifyRequest(ToCodeRequestHandler.getControlArray(controls));
        modifyRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processModifyRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processModifyDNRequest(int messageID, @NotNull ModifyDNRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "ModifyDN";
        ModifyDNRequest modifyDNRequest = request.toModifyDNRequest(ToCodeRequestHandler.getControlArray(controls));
        modifyDNRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processModifyDNRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processSearchRequest(int messageID, @NotNull SearchRequestProtocolOp request, @NotNull List<Control> controls) {
        List<String> lineList = this.getLineList(messageID);
        String requestID = "conn" + this.clientConnection.getConnectionID() + "Msg" + messageID + "Search";
        SearchRequest searchRequest = request.toSearchRequest(ToCodeRequestHandler.getControlArray(controls));
        searchRequest.toCode(lineList, requestID, 0, this.includeProcessing);
        this.writeLines(lineList);
        return this.requestHandler.processSearchRequest(messageID, request, controls);
    }

    @Override
    public void processUnbindRequest(int messageID, @NotNull UnbindRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.includeProcessing) {
            List<String> lineList = this.getLineList(messageID);
            ArrayList<ToCodeArgHelper> args = new ArrayList<ToCodeArgHelper>(1);
            if (!controls.isEmpty()) {
                Control[] controlArray = new Control[controls.size()];
                controls.toArray(controlArray);
                args.add(ToCodeArgHelper.createControlArray(controlArray, "Request Controls"));
            }
            ToCodeHelper.generateMethodCall(lineList, 0, null, null, "connection.close", args);
            this.writeLines(lineList);
        }
        this.requestHandler.processUnbindRequest(messageID, request, controls);
    }

    @NotNull
    private List<String> getLineList(int messageID) {
        List<String> lineList = this.lineLists.get();
        if (lineList == null) {
            lineList = new ArrayList<String>(20);
            this.lineLists.set(lineList);
        } else {
            lineList.clear();
        }
        lineList.add("// Time:  " + new Date());
        lineList.add("// Client Address: " + this.clientConnection.getSocket().getInetAddress().getHostAddress() + ':' + this.clientConnection.getSocket().getPort());
        lineList.add("// Server Address: " + this.clientConnection.getSocket().getLocalAddress().getHostAddress() + ':' + this.clientConnection.getSocket().getLocalPort());
        lineList.add("// Connection ID: " + this.clientConnection.getConnectionID());
        lineList.add("// Message ID: " + messageID);
        return lineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLines(@NotNull List<String> lineList) {
        PrintStream printStream = this.logStream;
        synchronized (printStream) {
            if (!this.firstMessage.compareAndSet(true, false)) {
                this.logStream.println();
                this.logStream.println();
            }
            for (String s : lineList) {
                this.logStream.println(s);
            }
        }
    }

    @NotNull
    private static Control[] getControlArray(@Nullable List<Control> controls) {
        if (controls == null || controls.isEmpty()) {
            return StaticUtils.NO_CONTROLS;
        }
        Control[] controlArray = new Control[controls.size()];
        return controls.toArray(controlArray);
    }
}

