/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import java.net.InetAddress;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InMemoryListenerConfig {
    private final boolean requestClientCertificate;
    private final boolean requireClientCertificate;
    @Nullable
    private final InetAddress listenAddress;
    private final int listenPort;
    @Nullable
    private final ServerSocketFactory serverSocketFactory;
    @Nullable
    private final SocketFactory clientSocketFactory;
    @Nullable
    private final SSLSocketFactory startTLSSocketFactory;
    @NotNull
    private final String listenerName;

    public InMemoryListenerConfig(@NotNull String listenerName, @Nullable InetAddress listenAddress, int listenPort, @Nullable ServerSocketFactory serverSocketFactory, @Nullable SocketFactory clientSocketFactory, @Nullable SSLSocketFactory startTLSSocketFactory) throws LDAPException {
        this(listenerName, listenAddress, listenPort, serverSocketFactory, clientSocketFactory, startTLSSocketFactory, false, false);
    }

    public InMemoryListenerConfig(@NotNull String listenerName, @Nullable InetAddress listenAddress, int listenPort, @Nullable ServerSocketFactory serverSocketFactory, @Nullable SocketFactory clientSocketFactory, @Nullable SSLSocketFactory startTLSSocketFactory, boolean requestClientCertificate, boolean requireClientCertificate) throws LDAPException {
        if (listenerName == null || listenerName.isEmpty()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_LISTENER_CFG_NO_NAME.get());
        }
        if (listenPort < 0 || listenPort > 65535) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_LISTENER_CFG_INVALID_PORT.get(listenPort));
        }
        this.listenerName = listenerName;
        this.listenAddress = listenAddress;
        this.listenPort = listenPort;
        this.serverSocketFactory = serverSocketFactory;
        this.clientSocketFactory = clientSocketFactory;
        this.startTLSSocketFactory = startTLSSocketFactory;
        this.requestClientCertificate = requestClientCertificate;
        this.requireClientCertificate = requireClientCertificate;
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPConfig(@NotNull String listenerName) throws LDAPException {
        return new InMemoryListenerConfig(listenerName, null, 0, null, null, null);
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPConfig(@NotNull String listenerName, int listenPort) throws LDAPException {
        return new InMemoryListenerConfig(listenerName, null, listenPort, null, null, null);
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPConfig(@NotNull String listenerName, @Nullable InetAddress listenAddress, int listenPort, @Nullable SSLSocketFactory startTLSSocketFactory) throws LDAPException {
        return InMemoryListenerConfig.createLDAPConfig(listenerName, listenAddress, listenPort, startTLSSocketFactory, false, false);
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPConfig(@NotNull String listenerName, @Nullable InetAddress listenAddress, int listenPort, @Nullable SSLSocketFactory startTLSSocketFactory, boolean requestClientCertificate, boolean requireClientCertificate) throws LDAPException {
        return new InMemoryListenerConfig(listenerName, listenAddress, listenPort, null, null, startTLSSocketFactory, requestClientCertificate, requireClientCertificate);
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPSConfig(@NotNull String listenerName, @NotNull SSLServerSocketFactory serverSocketFactory) throws LDAPException {
        return InMemoryListenerConfig.createLDAPSConfig(listenerName, null, 0, serverSocketFactory, null);
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPSConfig(@NotNull String listenerName, int listenPort, @NotNull SSLServerSocketFactory serverSocketFactory) throws LDAPException {
        return InMemoryListenerConfig.createLDAPSConfig(listenerName, null, listenPort, serverSocketFactory, null);
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPSConfig(@NotNull String listenerName, @Nullable InetAddress listenAddress, int listenPort, @NotNull SSLServerSocketFactory serverSocketFactory, @Nullable SSLSocketFactory clientSocketFactory) throws LDAPException {
        return InMemoryListenerConfig.createLDAPSConfig(listenerName, listenAddress, listenPort, serverSocketFactory, clientSocketFactory, false, false);
    }

    @NotNull
    public static InMemoryListenerConfig createLDAPSConfig(@NotNull String listenerName, @Nullable InetAddress listenAddress, int listenPort, @NotNull SSLServerSocketFactory serverSocketFactory, @Nullable SSLSocketFactory clientSocketFactory, boolean requestClientCertificate, boolean requireClientCertificate) throws LDAPException {
        SSLSocketFactory clientFactory;
        if (serverSocketFactory == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_LISTENER_CFG_NO_SSL_SERVER_SOCKET_FACTORY.get());
        }
        if (clientSocketFactory == null) {
            try {
                SSLUtil sslUtil = new SSLUtil(new TrustAllTrustManager());
                clientFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_LISTENER_CFG_COULD_NOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
            }
        } else {
            clientFactory = clientSocketFactory;
        }
        return new InMemoryListenerConfig(listenerName, listenAddress, listenPort, serverSocketFactory, clientFactory, null, requestClientCertificate, requireClientCertificate);
    }

    @NotNull
    public String getListenerName() {
        return this.listenerName;
    }

    @Nullable
    public InetAddress getListenAddress() {
        return this.listenAddress;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    @Nullable
    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    @Nullable
    public SocketFactory getClientSocketFactory() {
        return this.clientSocketFactory;
    }

    @Nullable
    public SSLSocketFactory getStartTLSSocketFactory() {
        return this.startTLSSocketFactory;
    }

    public boolean requestClientCertificate() {
        return this.requestClientCertificate;
    }

    public boolean requireClientCertificate() {
        return this.requireClientCertificate;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InMemoryListenerConfig(name='");
        buffer.append(this.listenerName);
        buffer.append('\'');
        if (this.listenAddress != null) {
            buffer.append(", listenAddress='");
            buffer.append(this.listenAddress.getHostAddress());
            buffer.append('\'');
        }
        buffer.append(", listenPort=");
        buffer.append(this.listenPort);
        if (this.serverSocketFactory != null) {
            buffer.append(", serverSocketFactoryClass='");
            buffer.append(this.serverSocketFactory.getClass().getName());
            buffer.append('\'');
        }
        if (this.clientSocketFactory != null) {
            buffer.append(", clientSocketFactoryClass='");
            buffer.append(this.clientSocketFactory.getClass().getName());
            buffer.append('\'');
        }
        if (this.startTLSSocketFactory != null) {
            buffer.append(", startTLSSocketFactoryClass='");
            buffer.append(this.startTLSSocketFactory.getClass().getName());
            buffer.append('\'');
        }
        buffer.append(", requestClientCertificate=");
        buffer.append(this.requestClientCertificate);
        buffer.append(", requireClientCertificate=");
        buffer.append(this.requireClientCertificate);
        buffer.append(')');
    }
}

