/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import reactor.netty.http.server.compression.HttpCompressionOptionsSpec;
import reactor.util.annotation.Nullable;

final class SimpleCompressionHandler
extends HttpContentCompressor {
    boolean decoded;
    HttpRequest request;

    private SimpleCompressionHandler() {
        super((CompressionOptions[])null);
    }

    private SimpleCompressionHandler(CompressionOptions ... options) {
        super(options);
    }

    static SimpleCompressionHandler create(@Nullable HttpCompressionOptionsSpec compressionOptions) {
        return compressionOptions == null ? new SimpleCompressionHandler() : new SimpleCompressionHandler(compressionOptions.adapt());
    }

    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) throws Exception {
        this.decoded = true;
        super.decode(ctx, msg, out);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            super.write(ctx, (Object)new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            if (!this.decoded && msg instanceof HttpResponse) {
                this.decode(ctx, this.request);
            }
            if (this.decoded && this.request != null && msg instanceof LastHttpContent) {
                this.decoded = false;
                this.request = null;
            }
            super.write(ctx, msg, promise);
        }
    }

    void decode(ChannelHandlerContext ctx, HttpRequest msg) {
        ArrayList<Object> out = new ArrayList<Object>();
        HttpRequest request = msg;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).content().refCnt() == 0) {
                request = new DefaultHttpRequest(msg.protocolVersion(), msg.method(), msg.uri(), msg.headers());
            }
            this.decode(ctx, request, out);
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException((Throwable)e);
        }
        finally {
            ReferenceCountUtil.release((Object)request);
            out.clear();
        }
    }
}

