/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategy;
import org.apache.james.modules.blobstore.validation.StorageStrategyChanged;
import org.apache.james.server.blob.deduplication.StorageStrategy;

public class StorageStrategyAggregate {
    private final AggregateId aggregateId;
    private final History history;
    private State state;

    public static StorageStrategyAggregate load(AggregateId aggregateId, History history) {
        return new StorageStrategyAggregate(aggregateId, history);
    }

    public StorageStrategyAggregate(AggregateId aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.history = history;
        this.state = State.initial();
        history.getEventsJava().forEach(this::apply);
    }

    public List<EventWithState> registerStorageStrategy(RegisterStorageStrategy command) {
        if (this.state.holds(command.getStorageStrategy())) {
            return ImmutableList.of();
        }
        if (!this.state.isAssignable(command.getStorageStrategy())) {
            throw new IllegalStateException(String.format("Cannot use %s as a BlobStoreStorageStrategy when current BlobStoreStorageStrategy is %s", command.getStorageStrategy(), this.state.getStorageStrategy()));
        }
        return ImmutableList.of((Object)EventWithState.noState((Event)new StorageStrategyChanged(this.history.getNextEventId(), this.aggregateId, command.getStorageStrategy())));
    }

    private void apply(Event event) {
        if (event instanceof StorageStrategyChanged) {
            StorageStrategyChanged changed = (StorageStrategyChanged)event;
            this.state = State.forStorageStrategy(changed.getStorageStrategy());
        }
    }

    static class State {
        private final Optional<StorageStrategy> storageStrategy;

        static State initial() {
            return new State(Optional.empty());
        }

        static State forStorageStrategy(StorageStrategy storageStrategy) {
            return new State(Optional.of(storageStrategy));
        }

        State(Optional<StorageStrategy> storageStrategy) {
            this.storageStrategy = storageStrategy;
        }

        public Optional<StorageStrategy> getStorageStrategy() {
            return this.storageStrategy;
        }

        public boolean holds(StorageStrategy storageStrategy) {
            return this.storageStrategy.filter(arg_0 -> storageStrategy.equals(arg_0)).isPresent();
        }

        public boolean isAssignable(StorageStrategy storageStrategy) {
            return !this.holds(StorageStrategy.DEDUPLICATION) || !storageStrategy.equals((Object)StorageStrategy.PASSTHROUGH);
        }
    }
}

