/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.mailbox.tools.indexer.FullReindexingTask;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;

public class FullReindexingTaskDTO
implements TaskDTO {
    private final String type;
    private final Optional<RunningOptionsDTO> runningOptions;

    private static FullReindexingTaskDTO toDTO(FullReindexingTask task, String type) {
        return new FullReindexingTaskDTO(type, Optional.of(RunningOptionsDTO.toDTO(task.getRunningOptions())));
    }

    public static TaskDTOModule<FullReindexingTask, FullReindexingTaskDTO> module(ReIndexerPerformer reIndexerPerformer) {
        return (TaskDTOModule)DTOModule.forDomainObject(FullReindexingTask.class).convertToDTO(FullReindexingTaskDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject(reIndexerPerformer)).toDTOConverter(FullReindexingTaskDTO::toDTO).typeName(FullReindexingTask.FULL_RE_INDEXING.asString()).withFactory(TaskDTOModule::new);
    }

    public FullReindexingTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.type = type;
        this.runningOptions = runningOptions;
    }

    public String getType() {
        return this.type;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }

    private FullReindexingTask toDomainObject(ReIndexerPerformer reIndexerPerformer) {
        return new FullReindexingTask(reIndexerPerformer, this.runningOptions.map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT));
    }
}

