/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.github.fge.lambdas.Throwing;
import com.rabbitmq.client.Channel;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.events.EventBus;
import org.apache.james.events.Group;
import org.apache.james.events.GroupRegistration;
import org.apache.james.events.NamingStrategy;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public class RabbitEventBusConsumerHealthCheck
implements HealthCheck {
    public static final String COMPONENT = "EventbusConsumers";
    private final EventBus eventBus;
    private final NamingStrategy namingStrategy;
    private final SimpleConnectionPool connectionPool;
    private final Group groupRegistrationHandlerGroup;

    public RabbitEventBusConsumerHealthCheck(EventBus eventBus, NamingStrategy namingStrategy, SimpleConnectionPool connectionPool, Group groupRegistrationHandlerGroup) {
        this.eventBus = eventBus;
        this.namingStrategy = namingStrategy;
        this.connectionPool = connectionPool;
        this.groupRegistrationHandlerGroup = groupRegistrationHandlerGroup;
    }

    public ComponentName componentName() {
        return new ComponentName("EventbusConsumers-" + this.namingStrategy.getEventBusName().value());
    }

    public Mono<Result> check() {
        return this.connectionPool.getResilientConnection().map((Function)Throwing.function(connection -> {
            try (Channel channel = connection.createChannel();){
                Result result = this.check(channel);
                return result;
            }
        })).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private Result check(Channel channel) {
        Stream<Group> groups = Stream.concat(this.eventBus.listRegisteredGroups().stream(), Stream.of(this.groupRegistrationHandlerGroup));
        Optional<String> queueWithoutConsumers = groups.map(this.namingStrategy::workQueue).map(GroupRegistration.WorkQueueName::asString).filter((Predicate<String>)Throwing.predicate(queue -> channel.consumerCount(queue) == 0L)).findAny();
        if (queueWithoutConsumers.isPresent()) {
            this.eventBus.restart();
            return Result.degraded((ComponentName)this.componentName(), (String)("No consumers on " + queueWithoutConsumers.get()));
        }
        return Result.healthy((ComponentName)this.componentName());
    }
}

