/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.backends.rabbitmq.Constants;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.GroupConsumerRetry;
import org.apache.james.events.ListenerExecutor;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.Registration;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.WaitDelayGenerator;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.ConsumeOptions;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;
import reactor.util.retry.Retry;

class GroupRegistration
implements Registration {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupRegistration.class);
    static final String RETRY_COUNT = "retry-count";
    static final int DEFAULT_RETRY_COUNT = 0;
    private final NamingStrategy namingStrategy;
    private final ReactorRabbitMQChannelPool channelPool;
    private final EventListener.ReactiveEventListener listener;
    private final WorkQueueName queueName;
    private final Runnable unregisterGroup;
    private final EventSerializer eventSerializer;
    private final GroupConsumerRetry retryHandler;
    private final WaitDelayGenerator delayGenerator;
    private final Group group;
    private final RetryBackoffConfiguration retryBackoff;
    private final ListenerExecutor listenerExecutor;
    private final RabbitMQConfiguration configuration;
    private Optional<Disposable> receiverSubscriber;
    private final ReceiverProvider receiverProvider;
    private Scheduler scheduler;

    GroupRegistration(NamingStrategy namingStrategy, ReactorRabbitMQChannelPool channelPool, Sender sender, ReceiverProvider receiverProvider, EventSerializer eventSerializer, EventListener.ReactiveEventListener listener, Group group, RetryBackoffConfiguration retryBackoff, EventDeadLetters eventDeadLetters, Runnable unregisterGroup, ListenerExecutor listenerExecutor, RabbitMQConfiguration configuration) {
        this.namingStrategy = namingStrategy;
        this.channelPool = channelPool;
        this.eventSerializer = eventSerializer;
        this.listener = listener;
        this.configuration = configuration;
        this.queueName = namingStrategy.workQueue(group);
        this.receiverProvider = receiverProvider;
        this.retryBackoff = retryBackoff;
        this.listenerExecutor = listenerExecutor;
        this.receiverSubscriber = Optional.empty();
        this.unregisterGroup = unregisterGroup;
        this.retryHandler = new GroupConsumerRetry(namingStrategy, sender, group, retryBackoff, eventDeadLetters, eventSerializer, configuration);
        this.delayGenerator = WaitDelayGenerator.of(retryBackoff);
        this.group = group;
    }

    GroupRegistration start() {
        this.scheduler = Schedulers.newBoundedElastic((int)10, (int)ReactorUtils.DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, (String)"group-handler");
        this.receiverSubscriber = Optional.of((Disposable)this.createGroupWorkQueue().then(this.retryHandler.createRetryExchange(this.queueName)).then(Mono.fromCallable(this::consumeWorkQueue)).retryWhen((Retry)Retry.backoff((long)this.retryBackoff.getMaxRetries(), (Duration)this.retryBackoff.getFirstBackoff()).jitter(this.retryBackoff.getJitterFactor()).scheduler(Schedulers.boundedElastic())).block());
        return this;
    }

    void restart() {
        Optional<Disposable> previousSubscriber = this.receiverSubscriber;
        this.receiverSubscriber = Optional.of(this.consumeWorkQueue());
        previousSubscriber.filter(Predicate.not(Disposable::isDisposed)).ifPresent(Disposable::dispose);
    }

    private Mono<Void> createGroupWorkQueue() {
        return this.channelPool.createWorkQueue(QueueSpecification.queue((String)this.queueName.asString()).durable(Constants.evaluateDurable((boolean)true, (boolean)this.configuration.isQuorumQueuesUsed())).exclusive(Constants.evaluateExclusive((boolean)false, (boolean)this.configuration.isQuorumQueuesUsed())).autoDelete(Constants.evaluateAutoDelete((boolean)false, (boolean)this.configuration.isQuorumQueuesUsed())).arguments((Map)this.configuration.workQueueArgumentsBuilder().deadLetter(this.namingStrategy.deadLetterExchange()).build()));
    }

    private Disposable consumeWorkQueue() {
        return Flux.using(() -> ((ReceiverProvider)this.receiverProvider).createReceiver(), receiver -> receiver.consumeManualAck(this.queueName.asString(), new ConsumeOptions().qos(10)), Receiver::close).publishOn(Schedulers.parallel()).filter(delivery -> Objects.nonNull(delivery.getBody())).flatMap(this::deliver, 10).subscribeOn(this.scheduler).subscribe();
    }

    private Mono<Void> deliver(AcknowledgableDelivery acknowledgableDelivery) {
        byte[] eventAsBytes = acknowledgableDelivery.getBody();
        int currentRetryCount = this.getRetryCount(acknowledgableDelivery);
        return this.deserializeEvent(eventAsBytes).flatMap(event -> this.delayGenerator.delayIfHaveTo(currentRetryCount).flatMap(any -> this.runListenerReliably(currentRetryCount, (Event)event)).then(Mono.fromRunnable(() -> ((AcknowledgableDelivery)acknowledgableDelivery).ack()).subscribeOn(Schedulers.boundedElastic()))).onErrorResume(e -> {
            LOGGER.error("Unable to process delivery for group {}", (Object)this.group, e);
            return Mono.fromRunnable(() -> acknowledgableDelivery.nack(false)).subscribeOn(Schedulers.boundedElastic()).then();
        });
    }

    public Mono<Void> runListenerReliably(int currentRetryCount, Event event) {
        return this.runListener(event).onErrorResume(throwable -> this.retryHandler.handleRetry(event, currentRetryCount, (Throwable)throwable));
    }

    public Mono<Void> runListenerReliably(int currentRetryCount, List<Event> events) {
        return this.runListener(events).onErrorResume(throwable -> Flux.fromIterable((Iterable)events).concatMap(event -> this.retryHandler.handleRetry((Event)event, currentRetryCount, (Throwable)throwable)).then());
    }

    private Mono<Event> deserializeEvent(byte[] eventAsBytes) {
        return Mono.fromCallable(() -> this.eventSerializer.fromBytes(eventAsBytes)).subscribeOn(Schedulers.parallel());
    }

    Mono<Void> reDeliver(Event event) {
        return this.retryHandler.retryOrStoreToDeadLetter(event, 0);
    }

    private Mono<Void> runListener(Event event) {
        return this.listenerExecutor.execute(this.listener, MDCBuilder.create().addToContext("group", this.group.asString()), event);
    }

    private Mono<Void> runListener(List<Event> events) {
        return this.listenerExecutor.execute(this.listener, MDCBuilder.create().addToContext("group", this.group.asString()), events);
    }

    private int getRetryCount(AcknowledgableDelivery acknowledgableDelivery) {
        return Optional.ofNullable(acknowledgableDelivery.getProperties().getHeaders()).flatMap(headers -> Optional.ofNullable(headers.get(RETRY_COUNT))).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(0);
    }

    public Mono<Void> unregister() {
        return Mono.fromRunnable(() -> {
            this.receiverSubscriber.filter(Predicate.not(Disposable::isDisposed)).ifPresent(Disposable::dispose);
            this.unregisterGroup.run();
            this.scheduler.dispose();
        });
    }

    static class WorkQueueName {
        private final String prefix;
        private final Group group;

        WorkQueueName(String prefix, Group group) {
            this.prefix = prefix;
            Preconditions.checkNotNull((Object)group, (Object)"Group must be specified");
            this.group = group;
        }

        String asString() {
            return this.prefix + "-workQueue-" + this.group.asString();
        }
    }
}

