/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.LMSimilarity;

public class IndriDirichletSimilarity
extends LMSimilarity {
    private final float mu;

    public IndriDirichletSimilarity(LMSimilarity.CollectionModel collectionModel, boolean discountOverlaps, float mu) {
        super(collectionModel, discountOverlaps);
        this.mu = mu;
    }

    public IndriDirichletSimilarity(LMSimilarity.CollectionModel collectionModel, float mu) {
        super(collectionModel);
        this.mu = mu;
    }

    public IndriDirichletSimilarity(float mu) {
        this.mu = mu;
    }

    public IndriDirichletSimilarity(LMSimilarity.CollectionModel collectionModel) {
        this(collectionModel, 2000.0f);
    }

    public IndriDirichletSimilarity() {
        this((LMSimilarity.CollectionModel)new IndriCollectionModel(), 2000.0f);
    }

    @Override
    protected double score(BasicStats stats, double freq, double docLen) {
        double collectionProbability = ((LMSimilarity.LMStats)stats).getCollectionProbability();
        double score = (freq + (double)this.mu * collectionProbability) / (docLen + (double)this.mu);
        return Math.log(score);
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, double freq, double docLen) {
        if (stats.getBoost() != 1.0) {
            subs.add(Explanation.match((Number)stats.getBoost(), "boost", new Explanation[0]));
        }
        subs.add(Explanation.match((Number)Float.valueOf(this.mu), "mu", new Explanation[0]));
        double collectionProbability = ((LMSimilarity.LMStats)stats).getCollectionProbability();
        Explanation weightExpl = Explanation.match((Number)Float.valueOf((float)Math.log((freq + (double)this.mu * collectionProbability) / (docLen + (double)this.mu))), "term weight", new Explanation[0]);
        subs.add(weightExpl);
        subs.add(Explanation.match((Number)Float.valueOf((float)Math.log((double)this.mu / (docLen + (double)this.mu))), "document norm", new Explanation[0]));
        super.explain(subs, stats, freq, docLen);
    }

    public float getMu() {
        return this.mu;
    }

    @Override
    public String getName() {
        return String.format(Locale.ROOT, "IndriDirichlet(%f)", Float.valueOf(this.getMu()));
    }

    public static class IndriCollectionModel
    implements LMSimilarity.CollectionModel {
        @Override
        public double computeProbability(BasicStats stats) {
            return (double)stats.getTotalTermFreq() / (double)stats.getNumberOfFieldTokens();
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

