/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.AMQP;
import java.util.Arrays;
import reactor.rabbitmq.OutboundMessage;
import reactor.util.annotation.Nullable;

public class CorrelableOutboundMessage<T>
extends OutboundMessage {
    private final T correlationMetadata;

    public CorrelableOutboundMessage(String exchange, String routingKey, byte[] body, T correlationMetadata) {
        super(exchange, routingKey, body);
        this.correlationMetadata = correlationMetadata;
    }

    public CorrelableOutboundMessage(String exchange, String routingKey, @Nullable AMQP.BasicProperties properties, byte[] body, T correlationMetadata) {
        super(exchange, routingKey, properties, body);
        this.correlationMetadata = correlationMetadata;
    }

    public T getCorrelationMetadata() {
        return this.correlationMetadata;
    }

    @Override
    public String toString() {
        return "CorrelableOutboundMessage{exchange='" + this.getExchange() + '\'' + ", routingKey='" + this.getRoutingKey() + '\'' + ", properties=" + this.getProperties() + '\'' + ", body=" + Arrays.toString(this.getBody()) + '\'' + ", correlationMetadata=" + this.getCorrelationMetadata() + '}';
    }
}

