/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;

public class StorageInformation {
    private final BucketName bucketName;
    private final BlobId blobId;

    public static Builder.RequireBucketName builder() {
        return bucketName -> blobId -> new StorageInformation(bucketName, blobId);
    }

    private StorageInformation(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        this.bucketName = bucketName;
        this.blobId = blobId;
    }

    public BucketName getBucketName() {
        return this.bucketName;
    }

    public BlobId getBlobId() {
        return this.blobId;
    }

    public final boolean equals(Object o) {
        if (o instanceof StorageInformation) {
            StorageInformation that = (StorageInformation)o;
            return Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.blobId, that.blobId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.bucketName, this.blobId);
    }

    public static class Builder {

        @FunctionalInterface
        public static interface RequireBlobId {
            public StorageInformation blobId(BlobId var1);
        }

        @FunctionalInterface
        public static interface RequireBucketName {
            public RequireBlobId bucketName(BucketName var1);
        }
    }
}

