/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.rest_client.RestClientTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class ClientProvider
implements Provider<ReactorOpenSearchClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientProvider.class);
    private final OpenSearchConfiguration configuration;
    private final RestClient lowLevelRestClient;
    private final OpenSearchAsyncClient openSearchClient;
    private final HttpAsyncClientConfigurer httpAsyncClientConfigurer;
    private final ReactorOpenSearchClient client;

    @Inject
    public ClientProvider(OpenSearchConfiguration configuration) {
        this.httpAsyncClientConfigurer = new HttpAsyncClientConfigurer(configuration);
        this.configuration = configuration;
        this.lowLevelRestClient = this.buildRestClient();
        this.openSearchClient = this.connect();
        this.client = new ReactorOpenSearchClient(this.openSearchClient, this.lowLevelRestClient);
    }

    private RestClient buildRestClient() {
        return RestClient.builder((HttpHost[])this.hostsToHttpHosts()).setHttpClientConfigCallback(this.httpAsyncClientConfigurer::configure).build();
    }

    private OpenSearchAsyncClient connect() {
        Duration waitDelay = Duration.ofMillis(this.configuration.getMinDelay());
        boolean suppressLeadingZeroElements = true;
        boolean suppressTrailingZeroElements = true;
        return (OpenSearchAsyncClient)Mono.fromCallable(this::connectToCluster).doOnError(e -> LOGGER.warn("Error establishing OpenSearch connection. Next retry scheduled in {}", (Object)DurationFormatUtils.formatDurationWords((long)waitDelay.toMillis(), (boolean)suppressLeadingZeroElements, (boolean)suppressTrailingZeroElements), e)).retryWhen((Retry)Retry.backoff((long)this.configuration.getMaxRetries(), (Duration)waitDelay).scheduler(Schedulers.boundedElastic())).publishOn(Schedulers.boundedElastic()).block();
    }

    private OpenSearchAsyncClient connectToCluster() {
        LOGGER.info("Trying to connect to OpenSearch service at {}", (Object)LocalDateTime.now());
        RestClientTransport transport = new RestClientTransport(this.lowLevelRestClient, (JsonpMapper)new JacksonJsonpMapper());
        return new OpenSearchAsyncClient((OpenSearchTransport)transport);
    }

    private HttpHost[] hostsToHttpHosts() {
        return (HttpHost[])this.configuration.getHosts().stream().map(host -> new HttpHost(host.getHostName(), host.getPort(), this.configuration.getHostScheme().name())).toArray(HttpHost[]::new);
    }

    public ReactorOpenSearchClient get() {
        return this.client;
    }

    @PreDestroy
    public void close() throws IOException {
        this.lowLevelRestClient.close();
    }

    private static class HttpAsyncClientConfigurer {
        private static final TrustStrategy TRUST_ALL = (x509Certificates, authType) -> true;
        private static final HostnameVerifier ACCEPT_ANY_HOSTNAME = (hostname, sslSession) -> true;
        private final OpenSearchConfiguration configuration;

        private HttpAsyncClientConfigurer(OpenSearchConfiguration configuration) {
            this.configuration = configuration;
        }

        private HttpAsyncClientBuilder configure(HttpAsyncClientBuilder builder) {
            this.configureAuthentication(builder);
            this.configureHostScheme(builder);
            this.configureTimeout(builder);
            this.configuration.getMaxConnections().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)builder).setMaxConnTotal(arg_0));
            this.configuration.getMaxConnectionsPerHost().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)builder).setMaxConnPerRoute(arg_0));
            builder.setThreadFactory((ThreadFactory)NamedThreadFactory.withName((String)"OpenSearch-driver"));
            return builder;
        }

        private void configureHostScheme(HttpAsyncClientBuilder builder) {
            OpenSearchConfiguration.HostScheme scheme = this.configuration.getHostScheme();
            switch (scheme) {
                case HTTP: {
                    return;
                }
                case HTTPS: {
                    this.configureSSLOptions(builder);
                    return;
                }
            }
            throw new NotImplementedException(String.format("unrecognized hostScheme '%s'", scheme.name()));
        }

        private void configureSSLOptions(HttpAsyncClientBuilder builder) {
            try {
                builder.setSSLContext(this.sslContext()).setSSLHostnameVerifier(this.hostnameVerifier());
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Cannot set SSL options to the builder", e);
            }
        }

        private void configureTimeout(HttpAsyncClientBuilder builder) {
            builder.setDefaultRequestConfig(this.requestConfig());
        }

        private SSLContext sslContext() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException, CertificateException, IOException {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            OpenSearchConfiguration.SSLConfiguration.SSLValidationStrategy strategy = this.configuration.getSslConfiguration().getStrategy();
            switch (strategy) {
                case DEFAULT: {
                    return sslContextBuilder.build();
                }
                case IGNORE: {
                    return sslContextBuilder.loadTrustMaterial(TRUST_ALL).build();
                }
                case OVERRIDE: {
                    return this.applyTrustStore(sslContextBuilder).build();
                }
            }
            throw new NotImplementedException(String.format("unrecognized strategy '%s'", strategy.name()));
        }

        private HostnameVerifier hostnameVerifier() {
            OpenSearchConfiguration.SSLConfiguration.HostNameVerifier hostnameVerifier = this.configuration.getSslConfiguration().getHostNameVerifier();
            switch (hostnameVerifier) {
                case DEFAULT: {
                    return new DefaultHostnameVerifier();
                }
                case ACCEPT_ANY_HOSTNAME: {
                    return ACCEPT_ANY_HOSTNAME;
                }
            }
            throw new NotImplementedException(String.format("unrecognized HostNameVerifier '%s'", hostnameVerifier.name()));
        }

        private RequestConfig requestConfig() {
            return RequestConfig.custom().setConnectTimeout(Math.toIntExact(this.configuration.getRequestTimeout().toMillis())).setConnectionRequestTimeout(Math.toIntExact(this.configuration.getRequestTimeout().toMillis())).setSocketTimeout(Math.toIntExact(this.configuration.getRequestTimeout().toMillis())).build();
        }

        private SSLContextBuilder applyTrustStore(SSLContextBuilder sslContextBuilder) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
            OpenSearchConfiguration.SSLConfiguration.SSLTrustStore trustStore = this.configuration.getSslConfiguration().getTrustStore().orElseThrow(() -> new IllegalStateException("SSLTrustStore cannot to be empty"));
            return sslContextBuilder.loadTrustMaterial(trustStore.getFile(), trustStore.getPassword());
        }

        private void configureAuthentication(HttpAsyncClientBuilder builder) {
            this.configuration.getCredential().ifPresent(credential -> {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(credential.getUsername(), String.valueOf(credential.getPassword())));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            });
        }
    }
}

