/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.search;

import jakarta.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;

public class AllSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final CassandraMessageIdDAO dao;

    @Inject
    public AllSearchOverride(CassandraMessageIdDAO dao) {
        this.dao = dao;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return this.isAll(searchQuery) || this.isFromOne(searchQuery) || this.isEmpty(searchQuery);
    }

    private boolean isAll(SearchQuery searchQuery) {
        return searchQuery.getCriteria().size() == 1 && ((SearchQuery.Criterion)searchQuery.getCriteria().get(0)).equals(SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(MessageUid.MIN_VALUE, MessageUid.MAX_VALUE)})) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    private boolean isFromOne(SearchQuery searchQuery) {
        return searchQuery.getCriteria().size() == 1 && ((SearchQuery.Criterion)searchQuery.getCriteria().get(0)).equals(SearchQuery.all()) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    private boolean isEmpty(SearchQuery searchQuery) {
        return searchQuery.getCriteria().isEmpty() && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        return this.dao.listUids((CassandraId)mailbox.getMailboxId());
    }
}

